/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem;

import au.com.ordermate.persistence.Displayable;
import java.util.List;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.additems.selectoptions.SelectOptions;
import waitermate.gui.screens.ordering.modifyitem.addmodification.AddModification;
import waitermate.gui.screens.ordering.modifyitem.editcomponent.EditComponent;
import waitermate.gui.screens.ordering.modifyitem.edititem.EditItem;
import waitermate.gui.screens.ordering.modifyitem.edititem.EditItemNav;
import waitermate.gui.screens.ordering.modifyitem.removemodification.RemoveModification;

public class ModifyItem {
    private Signal done;
    private SalesCombo combo;
    private SalesItem item;
    private final EditItem itemScreen = new EditItem();
    private final EditComponent componentScreen = new EditComponent();
    private final SelectOptions optionsScreen = new SelectOptions();
    private SalesComponent component;
    private static ModifyItem instance = new ModifyItem();

    public static ModifyItem getInstance() {
        return instance;
    }

    private ModifyItem() {
        AddModification addModificationState = new AddModification();
        RemoveModification removeModificationState = new RemoveModification();
        this.itemScreen.doneItem.connect((Object)this, "gotDone");
        this.itemScreen.componentSelected.connect((Object)this, "gotEditComponent");
        this.optionsScreen.optionsSelected.connect((Object)this, "gotOptionsSelected");
        this.componentScreen.doneComponent.connect((Object)this.itemScreen, "display");
        this.componentScreen.doneItem.connect((Object)this, "gotDone");
        this.componentScreen.optionsMod.connect((Object)this, "gotOptionsMod");
        this.componentScreen.addModification.connect((Object)addModificationState, "startAddModification");
        addModificationState.done.connect((Object)this.componentScreen, "edit");
        this.componentScreen.removeModification.connect((Object)removeModificationState, "startAddModification");
        removeModificationState.done.connect((Object)this.componentScreen, "edit");
        this.optionsScreen.back.connect((Object)this.componentScreen, "display");
    }

    public void startModify(SalesLineItem orderItem, Account account, Signal doneSignal) {
        this.done = doneSignal;
        if (orderItem instanceof SalesItem) {
            SalesItem orderSalesItem;
            this.item = orderSalesItem = (SalesItem)orderItem;
            List itemComponents = orderSalesItem.getComponentList();
            SalesComponent itemComponent = (SalesComponent)itemComponents.get(0);
            if (itemComponent.getUnit().getPortion().getSize() == 1.0 && itemComponents.size() == 1) {
                this.componentScreen.startEditItem(orderSalesItem, account);
            } else {
                this.itemScreen.startEditItem(this.item, account);
            }
        } else if (orderItem instanceof SalesCombo) {
            this.combo = (SalesCombo)orderItem;
            this.item = null;
            this.itemScreen.startEditComboItem(this.combo, account);
        }
    }

    public void setWastageMode(boolean build) {
        this.componentScreen.setupWasteMode(!build);
        ((EditItemNav)this.itemScreen.getNavBar()).setupWasteMode(!build);
    }

    public void gotOptionsMod(SalesComponent currentComponent) {
        this.component = currentComponent;
        Account account = this.component.getSalesItem() != null ? this.component.getSalesItem().getAccount() : null;
        TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)account);
        this.optionsScreen.selectOptions(currentComponent, context, false);
    }

    public void gotOptionsSelected(List options) {
        this.optionsScreen.tearDown();
        this.component.removeAllOptions();
        this.component.addOptions(options);
        this.componentScreen.edit();
    }

    void gotEditComponent(Displayable toEdit) {
        if (toEdit instanceof SalesComponent) {
            SalesComponent localComponent = (SalesComponent)toEdit;
            this.componentScreen.startEditComponent(localComponent, localComponent.getSalesItem());
        } else if (toEdit instanceof SalesItem) {
            SalesItem currentItem = (SalesItem)toEdit;
            this.startModify((SalesLineItem)currentItem, this.combo.getAccount(), this.done);
        }
    }

    void gotDone() {
        if (this.combo != null && this.item != null) {
            this.startModify((SalesLineItem)this.combo, this.combo.getAccount(), this.done);
        } else {
            this.combo = null;
            this.item = null;
            this.done.emit();
        }
    }
}

