/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.internationalization.Internationalization;
import ordermate.services.sales.ItemGroupPriceLevelPolicy;
import waitermate.gui.screens.ordering.accountitems.PriceLevelList;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class PriceLevelSelector {
    private PriceLevelList priceLevelList = new PriceLevelList();
    private static PriceLevelSelector instance = new PriceLevelSelector();
    private PopupWindow priceLevelPopup;
    private SalesComponent component;
    private SalesLineItem item;
    private TriggerActivationContext context;

    private PriceLevelSelector() {
        this.priceLevelList.usePriceLevel.connect((Object)this, "gotPriceLevelDone");
        this.priceLevelList.useCheapest.connect((Object)this, "gotUseCheapestPriceLevel");
        this.priceLevelPopup = Dialogs.createDialog((JComponent)this.priceLevelList, (String)Internationalization.getLiteralFor((String)"CHOOSE_A_PRICE_LEVEL"), (String)Internationalization.getLiteralFor((String)"OK"), null, (boolean)false, (boolean)true, (boolean)true);
    }

    public static final PriceLevelSelector getInstance() {
        return instance;
    }

    public void doPriceLevel(SalesLineItem itemToPriceLevel, TriggerActivationContext theContext) {
        this.item = itemToPriceLevel;
        this.component = null;
        this.context = theContext;
        HashSet<PriceLevel> priceLevels = new HashSet<PriceLevel>();
        List items = this.item.getSalesItems();
        for (SalesItem nextItem : items) {
            this.addAllPriceLevels(priceLevels, nextItem);
        }
        this.priceLevelList.setPossibleLevels(priceLevels, this.context);
        this.priceLevelList.setSingleItem(false);
        Dialogs.displayDialog((PopupWindow)this.priceLevelPopup, null, null);
    }

    private void addAllPriceLevels(Set<PriceLevel> levels, SalesItem item) {
        Iterator components = item.getComponentList().iterator();
        while (components.hasNext()) {
            List unitLevels = ((SalesComponent)components.next()).getUnit().getPrices();
            for (UnitPriceLevel unitLevel : unitLevels) {
                levels.add(unitLevel.getPriceLevel());
            }
        }
    }

    public void doPriceLevel(SalesComponent theComponent, TriggerActivationContext theContext) {
        this.component = theComponent;
        this.context = theContext;
        this.item = null;
        List unitPriceLevels = this.component.getUnit().getPrices();
        HashSet<PriceLevel> priceLevels = new HashSet<PriceLevel>();
        for (UnitPriceLevel unitPriceLevel : unitPriceLevels) {
            priceLevels.add(unitPriceLevel.getPriceLevel());
        }
        this.priceLevelList.setPossibleLevels(priceLevels, this.context);
        this.priceLevelList.setSingleItem(true);
        Dialogs.displayDialog((PopupWindow)this.priceLevelPopup, null, null);
    }

    void gotPriceLevelDone(PriceLevel level) {
        if (level != null) {
            if (this.component != null) {
                this.setPriceLevelOfComponent(this.component, level);
            } else {
                List allItems = this.item.getSalesItems();
                for (SalesItem nextItem : allItems) {
                    Iterator comps = nextItem.getComponentList().iterator();
                    while (comps.hasNext()) {
                        this.setPriceLevelOfComponent((SalesComponent)comps.next(), level);
                    }
                }
            }
        }
        ScreenResource.stopWindow((JComponent)this.priceLevelPopup);
    }

    private void setPriceLevelOfComponent(SalesComponent comp, PriceLevel level) {
        SalesItem componentItem = comp.getSalesItem();
        Account componentAccount = componentItem.getAccount();
        ItemGroupPriceLevelPolicy accountPLPolicy = null;
        if (componentAccount != null) {
            accountPLPolicy = new ItemGroupPriceLevelPolicy((ItemGroup)componentAccount);
        }
        for (UnitPriceLevel nextUnitLevel : comp.getUnit().getPrices()) {
            if (!level.equals((Object)nextUnitLevel.getPriceLevel())) continue;
            if (accountPLPolicy != null) {
                accountPLPolicy.setComponentPriceLevel(comp, nextUnitLevel);
                break;
            }
            componentItem.setComponentPriceLevel(comp, nextUnitLevel);
            break;
        }
    }

    void gotUseCheapestPriceLevel() {
        if (this.component != null) {
            this.doCheapestForComponent(this.component);
        } else {
            for (SalesItem nextItem : this.item.getSalesItems()) {
                this.doCheapestForItem(nextItem);
            }
        }
        ScreenResource.stopWindow((JComponent)this.priceLevelPopup);
    }

    private void doCheapestForItem(SalesItem anItem) {
        List comps = anItem.getComponentList();
        for (SalesComponent nextComponent : comps) {
            this.doCheapestForComponent(nextComponent);
        }
    }

    private void doCheapestForComponent(SalesComponent comp) {
        UnitPriceLevel cheapest = null;
        List unitPriceLevels = comp.getUnit().getPrices();
        for (UnitPriceLevel unitLevel : unitPriceLevels) {
            if (!unitLevel.isActive(this.context) || cheapest != null && !unitLevel.getPrice().lessThan((Object)cheapest.getPrice())) continue;
            cheapest = unitLevel;
        }
        if (cheapest == null) {
            return;
        }
        SalesItem componentItem = comp.getSalesItem();
        Account componentAccount = componentItem.getAccount();
        ItemGroupPriceLevelPolicy accountPLPolicy = null;
        if (componentAccount != null) {
            accountPLPolicy = new ItemGroupPriceLevelPolicy((ItemGroup)componentAccount);
        }
        List unitLevels = comp.getUnit().getPrices();
        for (UnitPriceLevel unitLevel : unitLevels) {
            if (!unitLevel.equals((Object)cheapest)) continue;
            if (accountPLPolicy != null) {
                accountPLPolicy.setComponentPriceLevel(comp, unitLevel);
                continue;
            }
            componentItem.setComponentPriceLevel(comp, unitLevel);
        }
    }
}

