/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editbarcodes;

import javax.swing.JComponent;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.BarcodeUtils;
import ordermate.database.sales.SalesComponent;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.ordering.modifyitem.editbarcodes.EditBarcodesNav;
import waitermate.gui.screens.ordering.modifyitem.editbarcodes.EditBarcodesPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class EditBarcodes
extends AbstractScreen {
    private EditBarcodesPanel gui;
    private EditBarcodesNav nav;
    private SalesComponent currentComponent;
    private boolean scan;
    public final Signal back = Signals.createSignal();

    public EditBarcodes() {
        this.gui = new EditBarcodesPanel();
        this.gui.delete.connect((Object)this, "deleteBarcode");
        this.nav = new EditBarcodesNav();
        this.nav.ok.connect((Object)this, "back");
        this.nav.enterBarcode.connect((Object)this, "gotEnterBarcode");
        this.stopScan();
        WaiterMateInputAdapter.getInstance().barcodeInput.connect((Object)this, "gotScanString");
        WaiterMateInputAdapter.getInstance().barcodedItemScanned.connect((Object)this, "gotBarcodedItemScanned");
    }

    public void start(SalesComponent currentComp) {
        this.currentComponent = currentComp;
        this.show();
    }

    void back() {
        this.stopScan();
        this.back.emit();
    }

    private void show() {
        this.refreshBarcodes();
        this.startScan();
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    void gotEnterBarcode() {
        String newBarcode = Dialogs.getString((String)(Internationalization.getLiteralFor((String)"ITEM_BARCODE") + ": "));
        if (!newBarcode.equalsIgnoreCase("\u0000") && !newBarcode.equalsIgnoreCase("")) {
            this.addBarcode(newBarcode);
        }
    }

    private void addBarcode(String barcode) {
        InventoryItemUnit.addUnitBarcode((String)barcode, (InventoryItemUnit)this.currentComponent.getUnit());
        this.currentComponent.getUnit().saveChild();
        this.refreshBarcodes();
    }

    private void refreshBarcodes() {
        this.gui.setBarcodes(this.currentComponent.getBarcodes());
    }

    public void deleteBarcode(String s) {
        InventoryItemUnit.deleteUnitBarcode((String)s, (InventoryItemUnit)this.currentComponent.getUnit());
        this.currentComponent.getUnit().saveChild();
        this.refreshBarcodes();
    }

    void gotScanString(String scanData) {
        String data = scanData;
        if (this.scan && !(data = BarcodeUtils.stripBarcodeDelimiter((String)data)).equalsIgnoreCase("")) {
            this.addBarcode(data);
        }
    }

    void gotBarcodedItemScanned(String PLU, Double price) {
        if (this.scan && !PLU.equalsIgnoreCase("")) {
            this.addBarcode(PLU);
        }
    }

    public void stopScan() {
        this.scan = false;
        WaiterMateInputAdapter.getInstance().enableInputParsing(true);
    }

    public void startScan() {
        this.scan = true;
        WaiterMateInputAdapter.getInstance().enableInputParsing(false);
    }
}

