/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editcomponent;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.inventory.OrderedQuantity;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemHelper;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.customer.assignment.CustomerAssignmentHelper;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockUtilities;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.TextScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.dialogs.ItemSplitDialog;
import waitermate.gui.screens.discount.DiscountGuiUtils;
import waitermate.gui.screens.ordering.modifyitem.editbarcodes.EditBarcodes;
import waitermate.gui.screens.ordering.modifyitem.editcomponent.EditComponentNav;
import waitermate.gui.screens.ordering.modifyitem.editcomponent.EditComponentPanel;
import waitermate.gui.screens.ordering.modifyitem.editcomponent.ShowRecipe;
import waitermate.gui.screens.ordering.modifyitem.editprice.EditPrice;
import waitermate.gui.screens.ordering.modifyitem.editstockcount.EditStockCount;
import waitermate.gui.screens.ordering.refunditems.RefundItems;
import waitermate.gui.screens.payment.selectadjustment.SelectPriceAdjustment;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class EditComponent
extends AbstractScreen {
    private EditComponentPanel gui;
    private EditComponentNav navPanel;
    private boolean isComponent;
    private SalesComponent currentComponent;
    private SalesItem currentItem;
    private Account currentAccount;
    private EditStockCount editStockCountScreen;
    private EditPrice editPriceScreen;
    private EditBarcodes editBarcodesScreen;
    private SalesQuantity stockCountOffset;
    private ShowRecipe showRecipe;
    private final SelectPriceAdjustment selectAdjustment = new SelectPriceAdjustment(false);
    public final Signal doneItem = Signals.createSignal();
    public final Signal doneComponent = Signals.createSignal();
    public final Signal<SalesComponent, ?, ?, ?, ?> addModification = Signals.createSignal(SalesComponent.class, (String)"component");
    public final Signal<SalesComponent, ?, ?, ?, ?> removeModification = Signals.createSignal(SalesComponent.class, (String)"component");
    public final Signal quantity = Signals.createSignal(SalesItem.class, (String)"item");
    public final Signal weightedItem = Signals.createSignal();
    public final Signal price = Signals.createSignal(SalesItem.class, (String)"item");
    public final Signal seat = Signals.createSignal(SalesItem.class, (String)"item");
    public final Signal<SalesComponent, ?, ?, ?, ?> optionsMod = Signals.createSignal(SalesComponent.class, (String)"component");
    public final Signal notesMod = Signals.createSignal(SalesComponent.class, (String)"component");
    public static final Color PLUS_COLOR = new Color(0, 192, 192, 50);
    public static final Color MINUS_COLOR = new Color(192, 0, 192, 50);

    public EditComponent() {
        this.gui = new EditComponentPanel();
        this.navPanel = new EditComponentNav();
        this.gui.addModification.connect((Object)this, "gotAddPlus");
        this.gui.removeModification.connect((Object)this, "gotAddMinus");
        this.gui.quantity.connect((Object)this, "gotQuantity");
        this.gui.price.connect((Object)this, "gotPrice");
        this.gui.seat.connect((Object)this, "gotSeat");
        this.gui.options.connect((Object)this, "gotOptionsMod");
        this.gui.priceLevelChanged.connect((Object)this, "gotPriceLevelChanged");
        this.gui.refund.connect((Object)this, "gotRefund");
        this.navPanel.ingredients.connect((Object)this, "gotIngredients");
        this.navPanel.stockControlInfo.connect((Object)this, "gotStockControlInfo");
        this.navPanel.barcodes.connect((Object)this, "gotBarcodes");
        this.navPanel.stockCount.connect((Object)this, "gotStockCount");
        this.navPanel.back.connect((Object)this, "gotDone");
        this.navPanel.ok.connect((Object)this, "gotDone");
        this.navPanel.notes.connect((Object)this, "gotNotes");
        this.navPanel.splitComponentSignal.connect((Object)this, "gotSplit");
        this.navPanel.discount.connect((Object)this, "gotStartDiscount");
        this.editPriceScreen = new EditPrice();
        this.editStockCountScreen = new EditStockCount();
        this.editBarcodesScreen = new EditBarcodes();
        this.editBarcodesScreen.back.connect((Object)this, "display");
        this.selectAdjustment.addAdjustment.connect((Object)this, "gotAddAdjustment");
        this.selectAdjustment.removeAdjustment.connect((Object)this, "gotRemoveAdjustment");
        this.selectAdjustment.back.connect((Object)this, "display");
        this.weightedItem.connect((Object)this.gui, "gotWeightedItem");
    }

    public void startEditComponent(SalesComponent currentComp, SalesItem theItem) {
        this.isComponent = true;
        this.currentComponent = currentComp;
        this.currentItem = theItem;
        this.gui.setEditingItem(false, Terminal.getLocalHost().getSeatNums(), theItem.isModifiable(LoginManager.getEventContext()));
        this.gui.setPlusMinusEnabled(!this.currentItem.hasEverPrinted());
        this.gui.setModifications(new LinkedHashSet(this.currentComponent.getCurrentPluses()), new LinkedHashSet(this.currentComponent.getCurrentMinuses()));
        this.gui.setOptions(this.currentComponent, new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount));
        this.gui.setItemName(this.currentComponent.getLabel());
        this.gui.setSeatVisible(false);
        this.gui.setSalesComponent(this.currentComponent, new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount));
        this.updateRefundButton();
        this.updatePrice();
        if (!theItem.hasNotes()) {
            this.gui.setNotes("");
        } else {
            this.gui.setNotes(Internationalization.getLiteralFor((String)"NOTES") + ": " + theItem.getNotes());
        }
        this.navPanel.setNotesVisible(false);
        this.navPanel.setSplitButtonVisible(false);
        this.navPanel.setDiscountVisible(false);
        this.navPanel.setText("<HTML>" + Internationalization.getLiteralFor((String)"MODIFY") + "<BR>" + this.currentItem.getLabel() + "</HTML>");
        this.display();
    }

    public void startEditItem(SalesItem currentEditItem, Account theAccount) {
        this.isComponent = false;
        this.currentComponent = (SalesComponent)currentEditItem.getComponentList().get(0);
        this.currentItem = currentEditItem;
        this.currentAccount = theAccount;
        OrderedQuantity uncommittedData = theAccount.getUnsavedData();
        InventoryItem singleInventoryItem = this.currentItem.getInventoryItemIfSingle();
        if (singleInventoryItem != null) {
            this.stockCountOffset = uncommittedData.getQuantity(singleInventoryItem);
        }
        boolean combo = currentEditItem.getParentCombo() != null;
        this.gui.setEditingItem(!combo, !combo && Terminal.getLocalHost().getSeatNums() && theAccount.usesSeatNums(), this.currentItem.isModifiable(LoginManager.getEventContext()));
        this.gui.setPlusMinusEnabled(!this.currentItem.hasEverPrinted());
        StockControlProperty stockProps = StockControlProperty.getInstance();
        this.gui.setModifications(new LinkedHashSet(this.currentComponent.getCurrentPluses()), new LinkedHashSet(this.currentComponent.getCurrentMinuses()));
        this.gui.setItemName(this.currentItem.getLabel());
        this.gui.setOptions(this.currentComponent, new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount));
        this.gui.setQuantity(this.resolveQuantityDisplay());
        this.gui.setSalesComponent(this.currentComponent, new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount));
        this.updateRefundButton();
        this.updatePrice();
        if (!currentEditItem.hasNotes()) {
            this.gui.setNotes("");
        } else {
            this.gui.setNotes(Internationalization.getLiteralFor((String)"NOTES") + ": " + currentEditItem.getNotes());
        }
        if (stockProps.isStockCountDownEnabled()) {
            InventoryItemUnit unit = this.currentComponent.getUnit();
            if (unit.isStockCountDownEnabled()) {
                this.navPanel.setStockCount(unit.getStockCountQuantity().subtract(this.stockCountOffset));
            } else {
                this.navPanel.setStockCount(null);
            }
        }
        this.gui.setSeat(this.currentItem.getSeat());
        this.navPanel.setNotesVisible(true);
        this.navPanel.setNotesEnabled(!this.currentItem.isPersistent());
        this.navPanel.setText("Modify " + this.currentItem.getLabel());
        this.navPanel.setSplitButtonVisible(!combo);
        this.navPanel.setSplitButtonEnabled(this.currentItem.isSplittable());
        this.navPanel.setDiscountVisible(true);
        this.display();
    }

    public void edit() {
        this.gui.setModifications(new LinkedHashSet(this.currentComponent.getCurrentPluses()), new LinkedHashSet(this.currentComponent.getCurrentMinuses()));
        this.gui.setOptions(this.currentComponent, new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount));
        this.updatePrice();
        this.display();
    }

    void gotQuantity() {
        SalesQuantity newQuantity;
        SalesQuantity oldQuantity = this.currentItem.getQuantity();
        boolean isRefund = this.currentItem.isRefund();
        BigDecimal currentQty = isRefund ? this.currentItem.getQuantity().negate().getValue() : this.currentItem.getQuantity().getValue();
        String unitStr = Internationalization.getLiteralFor((String)"QUANTITY") + ":";
        BigDecimal decimalQty = null;
        if (isRefund) {
            unitStr = unitStr + "-";
        }
        if (SystemProperty.getInstance().isFractionalQtys()) {
            decimalQty = Dialogs.getBigDecimal((String)unitStr, (BigDecimal)currentQty, (int)SystemProperty.getInstance().getMaxNumbFigures(), (boolean)true, (String)"");
        } else {
            int value = Dialogs.getInteger((String)unitStr, (int)currentQty.intValue());
            if (value > Integer.MIN_VALUE) {
                decimalQty = new BigDecimal(value);
            }
        }
        if (decimalQty == null) {
            return;
        }
        SalesQuantity salesQuantity = newQuantity = isRefund ? new SalesQuantity(decimalQty.negate()) : new SalesQuantity(decimalQty);
        if (isRefund) {
            decimalQty = decimalQty.negate();
            this.gui.setQuantity(newQuantity);
            this.currentItem.setQuantity(newQuantity, LoginManager.getEventContext());
        } else if (newQuantity != null && newQuantity.greaterThan(0L)) {
            User currentUser = LoginManager.getInstance().getUser();
            if (newQuantity.lessThan(this.currentItem.getSavedQuantity(true)) && newQuantity.lessThan(oldQuantity) && !currentUser.hasPermission(AllPermissions.DELETE_ITEM)) {
                Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"YOU_DO_NOT_HAVE_PERMISSION_TO_REMOVE_PRINTED_ITEMS"), (String)Internationalization.getLiteralFor((String)"CANNOT_DELETE"));
            } else if (this.checkForCreditLimit(decimalQty)) {
                this.currentItem.setQuantity(newQuantity, LoginManager.getEventContext());
                this.gui.setQuantity(newQuantity);
                InventoryItemUnit unit = this.currentComponent.getUnit();
                StockControlProperty stockProps = StockControlProperty.getInstance();
                if (stockProps.isStockCountDownEnabled()) {
                    boolean canOversell;
                    OrderedQuantity uncommittedData = this.currentAccount.getUnsavedData();
                    SalesQuantity uncommittedQty = uncommittedData.getQuantity(unit.getItem());
                    if (StockUtilities.checkItemSelectedOverSell((InventoryItemUnit)unit, (SalesQuantity)uncommittedQty, (boolean)(canOversell = currentUser.hasPermission(AllPermissions.STOCK_RESET)))) {
                        if (unit.isStockCountDownEnabled()) {
                            SalesQuantity stockCount = unit.getStockCountQuantity();
                            SalesQuantity quantityDiff = newQuantity.subtract(oldQuantity);
                            this.stockCountOffset = this.stockCountOffset.add(quantityDiff);
                            this.navPanel.setStockCount(stockCount.subtract(this.stockCountOffset));
                        }
                    } else {
                        this.currentItem.setQuantity(oldQuantity, LoginManager.getEventContext());
                        this.gui.setQuantity(oldQuantity);
                    }
                }
            }
        }
    }

    void gotAddPlus() {
        this.addModification.emit((Object)this.currentComponent);
    }

    void gotAddMinus() {
        this.removeModification.emit((Object)this.currentComponent);
    }

    void gotNotes() {
        String notes = null;
        notes = this.currentItem.hasNotes() ? Dialogs.getString((String)(Internationalization.getLiteralFor((String)"NOTES") + ":"), (String)this.currentItem.getNotes()) : Dialogs.getString((String)(Internationalization.getLiteralFor((String)"NOTES") + ":"));
        if (notes != "\u0000") {
            if ("".equals(notes)) {
                this.gui.setNotes(notes);
                this.currentItem.setNotes(notes);
            } else {
                this.currentItem.setNotes(notes);
                StringBuffer modifiedLabel = new StringBuffer();
                modifiedLabel.append(Internationalization.getLiteralFor((String)"NOTES") + ": ");
                modifiedLabel.append(notes);
                this.gui.setNotes(modifiedLabel.toString());
            }
        }
    }

    void gotDone() {
        if (this.isComponent) {
            this.doneComponent.emit();
        } else {
            this.doneItem.emit();
        }
    }

    void gotPrice() {
        this.editPriceScreen.start((SalesLineItem)this.currentItem);
        this.updatePrice();
    }

    void gotSeat() {
        String text = CoversHelper.getCorrectCoverLiteral();
        int newSeat = Dialogs.getInteger((String)(text + " #"));
        if (newSeat != Integer.MIN_VALUE) {
            if (newSeat > CoversHelper.getValueForSeats((ItemGroup)this.currentAccount)) {
                String dialogTitle = Internationalization.getLiteralFor((String)"INVALID_SEAT_NUMBER") + "!";
                String dialogText = Internationalization.getLiteralFor((String)"THERE_IS_NO_SEAT_NUMBER") + " " + newSeat + " " + Internationalization.getLiteralFor((String)"FOR_THIS_TABLE") + ".";
                dialogTitle = CoversHelper.amendLiteral(dialogTitle);
                dialogText = CoversHelper.amendLiteral(dialogText);
                Dialogs.displayOkDialog((String)dialogText, (String)dialogTitle);
            } else {
                this.currentItem.setSeat(newSeat);
                this.gui.setSeat(newSeat);
                this.reassignCustomer(newSeat);
            }
        }
    }

    void gotIngredients() {
        if (this.showRecipe == null) {
            this.showRecipe = new ShowRecipe();
            this.showRecipe.printRecipe.connect((Object)this, "gotPrintRecipe");
        }
        this.showRecipe.showRecipe(this.currentComponent.getUnit());
    }

    void gotPrintRecipe() {
        String toPrint = this.showRecipe.createRawTextVersion(this.currentComponent.getUnit());
        List printers = Terminal.getLocalHost().getAvailableReceiptPrinters();
        if (printers.size() > 1) {
            VirtualPrinter toPrintFrom = (VirtualPrinter)printers.get(0);
            printers.clear();
            printers.add(toPrintFrom);
        }
        try {
            DocketProcessor.printSimpleDocket((String)toPrint, (Collection)printers);
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Problem printing the recipe docket.", (Throwable)ex);
        }
    }

    void gotStockControlInfo() {
        this.displayStockControlInfo();
    }

    private void displayStockControlInfo() {
        InventoryItemUnit unit = this.currentComponent.getUnit();
        String stockControlInfoHeader = "<html><h2>" + Internationalization.getLiteralFor((String)"STOCK_CONTROL_INFORMATION") + ": </h2></html>";
        JLabel stockControlInfoLabel = new JLabel(stockControlInfoHeader);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)stockControlInfoLabel, "North");
        TextScrollPaneModel textModel = new TextScrollPaneModel(12);
        Price cogs = unit.getIngredientCostExTax();
        textModel.addLine(Internationalization.getLiteralFor((String)"COGS_EX_TAX") + ": " + cogs);
        textModel.addLine();
        PriceLevel priceLevel = this.currentComponent.getPriceLevel();
        UnitPriceLevel unitPriceLevel = unit.getUnitPriceLevel(priceLevel);
        if (unitPriceLevel == null) {
            textModel.addLine(Internationalization.getLiteralFor((String)"PRICE_LEVEL") + " : " + priceLevel.getLabel());
            textModel.addLine(Internationalization.getLiteralFor((String)"NO_LONGER_AVAILABLE_AT_THIS_PRICE_LEVEL"));
        } else {
            textModel.addLine(Internationalization.getLiteralFor((String)"PRICE_LEVEL") + " : " + priceLevel.getLabel() + " " + unitPriceLevel.getPrice());
            Price grossProfit = unitPriceLevel.getGrossProfitItemValue();
            double gpMargin = unitPriceLevel.getGrossProfitItemMargin();
            textModel.addLine(Internationalization.getLiteralFor((String)"GROSS_PROFIT") + ": " + grossProfit);
            textModel.addLine(Internationalization.getLiteralFor((String)"GP_MARGIN") + " : " + FinanceUtils.formatAsPercentage((double)gpMargin));
        }
        textModel.addLine();
        textModel.addLine("<HTML><H3>" + Internationalization.getLiteralFor((String)"INGREDIENTS") + " :</H3></HTML>");
        textModel.addLine();
        StringBuilder indentBuilder = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            indentBuilder.append("&nbsp;");
        }
        String indent = indentBuilder.toString();
        for (StockInventoryUsageLink link : unit.getStockInventoryUsageLinks()) {
            textModel.addLine("<HTML><UL><LI>" + link + "</LI></UL></HTML>");
            StockItem item = link.getStockItem();
            if (item.getTotalStockOnHand() == null) continue;
            textModel.addLine("<HTML>" + indent + indent + Internationalization.getLiteralFor((String)"ON_HAND_ALL_AREAS") + " : " + item.getTotalStockOnHand() + " " + item.getTotalStockOnHand().getMeasureUnit() + "</HTML>");
            StockArea area = Terminal.getLocalHost().getStockArea();
            if (item.getStockOnHand(area) != null) {
                textModel.addLine("<HTML>" + indent + indent + Internationalization.getLiteralFor((String)"ON_HAND_DASH") + area.toString() + " : " + item.getStockOnHand(area) + " " + item.getStockOnHand(area).getMeasureUnit() + "</HTML>");
            }
            textModel.addLine();
        }
        CustomScrollPane scrollPane = new CustomScrollPane((CustomScrollPaneModel)textModel);
        scrollPane.setPreferredSize(new Dimension(550, 300));
        panel.add((Component)scrollPane, "Center");
        Dialogs.displayOkDialog((JComponent)panel, (String)Internationalization.getLiteralFor((String)"STOCK_CONTROL_INFO"));
    }

    void gotBarcodes() {
        this.editBarcodesScreen.start(this.currentComponent);
    }

    void gotStockCount() {
        this.editStockCountScreen.start(this.currentComponent, this.stockCountOffset);
        InventoryItemUnit unit = this.currentComponent.getUnit();
        if (unit.isStockCountDownEnabled()) {
            this.navPanel.setStockCount(unit.getStockCountQuantity().subtract(this.stockCountOffset));
        } else {
            this.navPanel.setStockCount(null);
        }
    }

    void gotOptionsMod() {
        this.optionsMod.emit((Object)this.currentComponent);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }

    private void updatePrice() {
        this.gui.setPrice(this.currentItem.getItemLevelPrice());
        if (SystemProperty.getInstance().isEnforceBasePricesEnabled()) {
            Price basePrice = this.currentComponent.getBasePrice();
            if (!this.isComponent) {
                for (SalesPriceAdjustment adjustment : this.currentItem.getPriceAdjustmentsNotIncludingPriceLevelAdjs()) {
                    if (!PriceAdjustmentType.OPEN_PRICE.equals((Object)adjustment.getType())) continue;
                    basePrice = adjustment.getInventoryPriceAdjustment().getFlatPrice();
                }
            }
            this.gui.showBasePriceNotification(basePrice);
        } else {
            this.gui.hideBasePriceNotification();
        }
    }

    void gotSplit() {
        SalesItem splitItem;
        SalesQuantity splitQty;
        boolean ok;
        ItemSplitDialog itemSplitDialog = new ItemSplitDialog((SalesLineItem)this.currentItem);
        if (this.currentItem.getQuantity().equals(2L)) {
            ok = true;
            splitQty = SalesQuantity.ONE;
        } else {
            ok = itemSplitDialog.start();
            splitQty = itemSplitDialog.getSplitQuantity();
        }
        if (ok && (splitItem = (SalesItem)this.currentItem.split(splitQty, LoginManager.getEventContext())) != null) {
            this.currentItem.getAccount().getItemHelper().addItem((SalesLineItem)splitItem);
            if (this.currentItem.isPersistent() && splitItem.getAccount().isPersistent()) {
                splitItem.saveChild();
            }
            this.startEditItem(splitItem, splitItem.getAccount());
        }
    }

    void gotStartDiscount() {
        ArrayList allAdjustmentsOnCurrentItem = new ArrayList(this.currentItem.getPriceAdjustments());
        allAdjustmentsOnCurrentItem.addAll(this.currentAccount.getPriceAdjustments());
        this.selectAdjustment.start(this.currentItem.getPriceAdjustments(), allAdjustmentsOnCurrentItem, PriceAdjustmentDirection.DISCOUNT, PriceAdjustmentType.NORMAL, PriceAdjustmentLevel.ITEM_LEVEL, new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount));
    }

    void gotAddAdjustment(InventoryPriceAdjustment adj) {
        if (adj.isOpenPrice()) {
            adj = DiscountGuiUtils.getNewPriceForOpenPriceDiscountForItem(adj, this.currentItem);
        } else {
            adj.createSalesPriceAdjustment((PriceAdjustable)this.currentItem, LoginManager.getEventContext());
        }
        this.updatePrice();
        this.display();
    }

    void gotRemoveAdjustment(SalesPriceAdjustmentI adj) {
        this.currentItem.removePriceAdjustment((SalesPriceAdjustment)adj, LoginManager.getEventContext());
        this.updatePrice();
        this.display();
    }

    void gotPriceLevelChanged() {
        this.updatePrice();
        this.display();
    }

    private boolean checkForCreditLimit(BigDecimal newQuantity) {
        Account account = this.currentAccount;
        if (account == null || !(account instanceof CreditLimited)) {
            return true;
        }
        Price delta = this.currentComponent.getPrice(new SalesQuantity(newQuantity)).subtract(this.currentComponent.getPrice(this.currentItem.getQuantity()));
        if (((CreditLimited)account).exceedsCreditLimit(delta)) {
            return CreditLimitPanel.doCreditLimitDialog((CreditLimited)account, delta, account.getLabel(), true);
        }
        return true;
    }

    void gotRefund() {
        String dialogResult = null;
        dialogResult = !this.currentComponent.getSalesItem().isRefund() ? RefundItems.doRefundQuestionDialog((Displayable)this.currentComponent) : "ACTIVE";
        if (dialogResult != null) {
            this.currentComponent.getSalesItem().markAsQuickRefunded(LoginManager.getEventContext(), dialogResult);
        }
        this.updatePrice();
        this.updateRefundButton();
        this.gui.setQuantity(this.currentComponent.getSalesItem().getQuantity());
        this.display();
    }

    private void updateRefundButton() {
        SalesItem item = this.currentComponent.getSalesItem();
        if (item.isRefund()) {
            SalesItemQuantity mostRecentQuantity = SalesLineItemHelper.getLastSalesItemQuantity((SalesLineItem)item);
            this.gui.setRefundText(mostRecentQuantity.getItemState());
        } else {
            this.gui.setRefundText("ACTIVE");
        }
        this.gui.setRefundVisible(!this.currentComponent.getSalesItem().isComboItem());
    }

    public void setupWasteMode(boolean showAllComponents) {
        this.navPanel.setupWasteMode(showAllComponents);
        this.gui.setupWasteMode(showAllComponents);
    }

    private String resolveQuantityDisplay() {
        InventoryItem item = this.currentItem.getInventoryItemIfSingle();
        if (item != null && !InventoryWeightUnit.NA.equals((Object)item.getInventoryWeightUnit())) {
            this.weightedItem.emit();
            return this.currentItem.getQuantity().weightedQtyToString() + item.getInventoryWeightUnit().getDisplay();
        }
        return this.currentItem.getQuantity().toString();
    }

    private void reassignCustomer(int targetSeat) {
        if (new CustomerAssignmentHelper().isAssignmentPerSeat(this.currentAccount)) {
            TableAccount tableAcc = (TableAccount)this.currentAccount;
            Customer customer = tableAcc.getCustomerForSeat(targetSeat);
            this.currentItem.setCustomer(customer);
        }
    }
}

