/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editcomponent;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

public class EditComponentNav
extends NavBar
implements ActionListener {
    public final Signal notes = Signals.createSignal();
    public final Signal ingredients = Signals.createSignal();
    public final Signal stockControlInfo = Signals.createSignal();
    public final Signal barcodes = Signals.createSignal();
    public final Signal stockCount = Signals.createSignal();
    public final Signal splitComponentSignal = Signals.createSignal();
    public final Signal discount = Signals.createSignal();
    private JButton notesButton;
    private JButton ingredientsButton;
    private JButton stockCountButton;
    private JButton barcodesButton;
    private JButton stockControlInfoButton;
    private JButton splitButton;
    private JButton discountButton;
    private StandardSecurityDecorator notesDecorator;
    private StandardSecurityDecorator discountsDecorator;

    public EditComponentNav() {
        StockControlProperty stockProps = StockControlProperty.getInstance();
        this.ingredientsButton = this.constructButton(IconLoader.get((String)"/waitermate/images/ingredients.png"), Internationalization.getLiteralFor((String)"INGREDIENTS"), Internationalization.getLiteralFor((String)"INGREDIENTS"));
        this.addRight((Component)new StandardSecurityDecorator((JComponent)this.ingredientsButton, AllPermissions.VIEW_INGREDIENTS));
        if (stockProps.isStockControlEnabled()) {
            this.stockControlInfoButton = this.constructButton(IconLoader.get((String)"/waitermate/images/pie.png"), "<HTML>" + Internationalization.getLiteralFor((String)"STOCK") + "<BR>" + Internationalization.getLiteralFor((String)"CONTROL_INFO") + "</HTML>", "StockControl Info");
            this.addRight(this.stockControlInfoButton);
        }
        if (stockProps.isStockCountDownEnabled()) {
            this.stockCountButton = this.constructButton(IconLoader.get((String)"/waitermate/images/StockCount.png"), "<HTML>" + Internationalization.getLiteralFor((String)"STOCK") + "<BR>" + Internationalization.getLiteralFor((String)"COUNT") + "</HTML>", "StockCount");
            this.addRight((Component)new StandardSecurityDecorator((JComponent)this.stockCountButton, AllPermissions.STOCK_RESET));
        }
        if (stockProps.isStockControlEnabled() || Terminal.getLocalHost().getHasBarcodes()) {
            this.barcodesButton = this.constructButton(IconLoader.get((String)"/waitermate/images/barcode.png"), Internationalization.getLiteralFor((String)"BARCODE"), "barcode");
            this.addRight((Component)new StandardSecurityDecorator((JComponent)this.barcodesButton, AllPermissions.EDIT_BARCODES));
        }
        this.splitButton = this.constructButton(IconLoader.get((String)"/waitermate/images/comboBreak.png"), Internationalization.getLiteralFor((String)"SPLIT"), "split", this.splitComponentSignal);
        this.notesButton = this.constructButton(IconLoader.get((String)"/waitermate/images/tablet.png"), Internationalization.getLiteralFor((String)"ITEM_NOTES"), "notes");
        this.notesDecorator = new StandardSecurityDecorator((JComponent)this.notesButton, AllPermissions.KITCHEN_NOTES);
        this.discountButton = this.constructButton(IconLoader.get((String)"/waitermate/images/money.png"), Internationalization.getLiteralFor((String)"DISCOUNT"), "Discount", this.discount);
        this.discountsDecorator = new StandardSecurityDecorator((JComponent)this.discountButton, AllPermissions.DISCOUNT);
        this.addRight((Component)this.discountsDecorator);
        this.addRight(this.splitButton);
        this.addRight((Component)this.notesDecorator);
        this.addLeft(this.getBackButton());
        this.addRight(this.getOkButton());
    }

    public void setNotesEnabled(boolean enabled) {
        this.notesDecorator.setEnabled(enabled);
    }

    public void setDiscountVisible(boolean visible) {
        this.discountsDecorator.setVisible(visible);
    }

    public void setNotesVisible(boolean visible) {
        this.notesDecorator.setVisible(visible);
    }

    public void setStockCount(SalesQuantity count) {
        if (this.stockCountButton != null) {
            String countString = Internationalization.getLiteralFor((String)"OFF");
            if (count != null) {
                countString = count.toString();
            }
            this.stockCountButton.setText("<HTML>" + Internationalization.getLiteralFor((String)"STOCK") + "<BR>" + Internationalization.getLiteralFor((String)"COUNT") + " (" + countString + ")</HTML>");
        }
    }

    public void setSplitButtonEnabled(boolean isEnabled) {
        this.splitButton.setEnabled(isEnabled);
    }

    public void setSplitButtonVisible(boolean isVisible) {
        this.splitButton.setVisible(isVisible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.barcodesButton) {
            this.barcodes.emit();
        } else if (e.getSource() == this.notesButton) {
            this.notes.emit();
        } else if (e.getSource() == this.ingredientsButton) {
            this.ingredients.emit();
        } else if (e.getSource() == this.stockControlInfoButton) {
            this.stockControlInfo.emit();
        } else if (e.getSource() == this.stockCountButton) {
            this.stockCount.emit();
        } else {
            super.actionPerformed(e);
        }
    }

    public void setupWasteMode(boolean showAllComponents) {
        this.notesButton.setVisible(showAllComponents);
        if (this.stockCountButton != null) {
            this.stockCountButton.setVisible(showAllComponents);
        }
        this.barcodesButton.setVisible(showAllComponents);
        this.splitButton.setVisible(showAllComponents);
        this.discountButton.setVisible(showAllComponents);
    }
}

