/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editcomponent;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.gui.scroll.HtmlReportPanel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMate;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

class ShowRecipe {
    public Signal printRecipe = Signals.createSignal();
    private JPanel ingredientsPanel;
    private JLabel ingredientLabel;
    private HtmlReportPanel ingredientsContentPanel;
    private List<String> listIngredientsContentText;
    private static final Dimension MAX_IMAGE_SIZE = new Dimension(750, 150);

    ShowRecipe() {
    }

    public void showRecipe(InventoryItemUnit aUnit) {
        if (this.ingredientsPanel == null) {
            this.createPanel();
        }
        this.listIngredientsContentText.clear();
        this.setUpHeader(aUnit);
        this.setUpIngredients(aUnit);
        this.setUpProcedure(aUnit);
        this.ingredientsContentPanel.setListData(this.listIngredientsContentText);
        Dialogs.displayDialog((PopupWindow)this.createPopup(), null, null);
    }

    private void createPanel() {
        this.ingredientsPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(1));
        this.ingredientLabel = new JLabel();
        topPanel.add(this.ingredientLabel);
        this.ingredientLabel.setHorizontalTextPosition(2);
        this.ingredientsPanel.add((Component)topPanel, "North");
        this.ingredientsContentPanel = new HtmlReportPanel("Ingredients");
        this.ingredientsContentPanel.setName("IngredientsContent");
        this.ingredientsPanel.add((Component)this.ingredientsContentPanel, "Center");
        this.ingredientsPanel.setMinimumSize(new Dimension(400, 300));
        this.ingredientsPanel.setPreferredSize(new Dimension(600, 400));
        this.listIngredientsContentText = new ArrayList<String>();
    }

    private void setUpHeader(InventoryItemUnit unit) {
        String ingredientIconUrl = unit.getItem().getIngredientIcon();
        ImageIcon icon = null;
        if (ingredientIconUrl != null && ingredientIconUrl.trim().length() > 0) {
            try {
                icon = IconLoader.get((String)ingredientIconUrl);
            }
            catch (IconLoader.IconNotFoundException ex) {
                WaiterMate.LOG.warn("Ingredient icon cannot be found:" + ingredientIconUrl);
            }
            if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
                double scaleFactor = MAX_IMAGE_SIZE.getHeight() / (double)icon.getIconHeight();
                if (MAX_IMAGE_SIZE.getWidth() / (double)icon.getIconWidth() < scaleFactor) {
                    scaleFactor = MAX_IMAGE_SIZE.getWidth() / (double)icon.getIconWidth();
                }
                if (scaleFactor < 1.0 && scaleFactor > 0.0) {
                    ImageHelper helper = new ImageHelper();
                    icon.setImage(helper.rescaleImage(icon.getImage(), scaleFactor));
                }
            } else {
                icon = null;
            }
        }
        this.ingredientLabel.setIcon(icon);
        this.ingredientLabel.setText("<html><h2>" + unit.getLabel() + "</h2></html>");
    }

    private void setUpIngredients(InventoryItemUnit unit) {
        List ingredients = unit.getStockInventoryUsageLinks();
        if (!ingredients.isEmpty()) {
            StringBuilder SB = new StringBuilder("<ul>");
            for (int i = 0; i < ingredients.size(); ++i) {
                SB.append("<li>");
                SB.append(((StockInventoryUsageLink)ingredients.get(i)).toUsageString());
                SB.append("</li>");
            }
            SB.append("</ul>");
            this.listIngredientsContentText.add(SB.toString());
        } else if (unit.getItem().getMinuses().size() > 0) {
            this.listIngredientsContentText.add("<h2>" + Internationalization.getLiteralFor((String)"REMOVE_INGREDIENTS") + ":</h2>");
            StringBuilder SB = new StringBuilder("<ul>");
            Iterator i = unit.getItem().getMinuses().iterator();
            while (i.hasNext()) {
                SB.append("<li>");
                SB.append(i.next().toString());
                SB.append("</li>");
            }
            SB.append("</ul>");
            this.listIngredientsContentText.add(SB.toString());
        } else if (unit.getRecipe() == null || unit.getRecipe().length() == 0) {
            this.listIngredientsContentText.add(Internationalization.getLiteralFor((String)"NO_INGREDIENTS_SET"));
        }
    }

    private void setUpProcedure(InventoryItemUnit unit) {
        String recipe = unit.getRecipe();
        if (recipe != null && recipe.length() > 0) {
            String[] splits;
            this.listIngredientsContentText.add("<h2>" + Internationalization.getLiteralFor((String)"RECIPE") + ":</h2>");
            for (String split : splits = recipe.split("\\n")) {
                this.listIngredientsContentText.add(split);
            }
        }
    }

    private PopupWindow createPopup() {
        this.ingredientsContentPanel.setListData(this.listIngredientsContentText);
        PopupWindow popup = new PopupWindow(false);
        popup.setComponent((JComponent)this.ingredientsPanel);
        popup.setText(Internationalization.getLiteralFor((String)"INGREDIENTS"));
        NavBar bar = popup.getNavBar();
        JButton printBut = bar.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/print.png"), Internationalization.getLiteralFor((String)"PRINT_RECIPE"), "printRecipe", this.printRecipe);
        bar.addLeft((Component)printBut);
        bar.removeLeft((Component)bar.getCancelButton());
        return popup;
    }

    public String createRawTextVersion(InventoryItemUnit unit) {
        String recipe;
        StringBuilder SB = new StringBuilder(unit.getItemLabel());
        SB.append(" " + Internationalization.getLiteralFor((String)"RECIPE") + "\n\n");
        List ingredients = unit.getStockInventoryUsageLinks();
        if (!ingredients.isEmpty()) {
            SB.append(Internationalization.getLiteralFor((String)"INGREDIENTS") + ":\n\n");
            for (int i = 0; i < ingredients.size(); ++i) {
                SB.append(ingredients.get(i));
                SB.append("\n");
            }
        } else if (unit.getItem().getMinuses().size() > 0) {
            SB.append(Internationalization.getLiteralFor((String)"REMOVABLE_INGREDIENTS") + ":\n\n");
            Iterator i = unit.getItem().getMinuses().iterator();
            while (i.hasNext()) {
                SB.append(i.next().toString());
                SB.append("\n");
            }
        } else if (unit.getRecipe() == null || unit.getRecipe().length() == 0) {
            SB.append(Internationalization.getLiteralFor((String)"NO_INGREDIENTS_SET_"));
        }
        if ((recipe = unit.getRecipe()) != null && recipe.length() > 0) {
            String[] splits;
            SB.append("\n\n" + Internationalization.getLiteralFor((String)"PROCEDURE") + ":\n\n");
            String stringRecipe = StringUtils.removeHTMLTags((String)recipe);
            for (String split : splits = stringRecipe.split("\\n")) {
                SB.append(split);
                SB.append("\n");
            }
        }
        return SB.toString();
    }
}

