/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.edititem;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.finance.CreditLimited;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemHelper;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.customer.assignment.CustomerAssignmentHelper;
import ordermate.gui.ordering.OrderComboHelper;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.ordering.modifyitem.PriceLevelSelector;
import waitermate.gui.screens.ordering.modifyitem.edititem.EditItemNav;
import waitermate.gui.screens.ordering.modifyitem.edititem.EditItemPanel;
import waitermate.gui.screens.ordering.modifyitem.editprice.EditPrice;
import waitermate.gui.screens.ordering.refunditems.RefundItems;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class EditItem
extends AbstractScreen {
    private EditItemPanel gui;
    private EditItemNav navPanel;
    private EditPrice editPriceScreen;
    private SalesLineItem currentItem;
    private Account currentAccount;
    public Signal doneItem = Signals.createSignal();
    public Signal componentSelected = Signals.createSignal(Displayable.class, (String)"theItem");
    public Signal price = Signals.createSignal(SalesItem.class, (String)"item");
    public Signal seat = Signals.createSignal(SalesItem.class, (String)"item");

    public EditItem() {
        this.gui = new EditItemPanel();
        this.navPanel = new EditItemNav();
        this.gui.componentSelected.connect((Object)this, "gotComponent");
        this.gui.quantity.connect((Object)this, "gotQuantity");
        this.gui.price.connect((Object)this, "gotPrice");
        this.gui.seat.connect((Object)this, "gotSeat");
        this.gui.priceLevel.connect((Object)this, "gotPriceLevel");
        this.gui.refund.connect((Object)this, "gotRefund");
        this.navPanel.back.connect((Object)this, "gotDone");
        this.navPanel.ok.connect((Object)this, "gotDone");
        this.navPanel.notes.connect((Object)this, "gotNotes");
        this.navPanel.breakCombo.connect((Object)this, "gotBreakCombo");
        this.editPriceScreen = new EditPrice();
    }

    private void startEditLineItem(SalesLineItem editItem, Account theAccount) {
        this.currentItem = editItem;
        this.currentAccount = theAccount;
        this.gui.setQuantityVisible(editItem.isModifiable(LoginManager.getEventContext()));
        this.gui.setSeat(editItem.getSeat());
        this.gui.setRefundText(SalesLineItemHelper.getLastSalesItemQuantity((SalesLineItem)editItem).getItemState());
        this.gui.setRefundButtonStatus(editItem);
        this.updatePrice();
        this.navPanel.setNotesEnabled(!editItem.isPersistent());
        this.navPanel.setBreakComboVisible(this.currentItem instanceof SalesCombo);
        this.display();
    }

    public void startEditItem(SalesItem editItem, Account account) {
        this.gui.setConstituents(editItem.getQuantity(), editItem.getLabel(), editItem.getComponentList(), this.hasManyPriceLevels(editItem.getComponentList()));
        this.gui.setSeatVisible(account.usesSeatNums() && Terminal.getLocalHost().getSeatNums());
        this.gui.setPriceVisible(true);
        this.navPanel.setNotesVisible(true);
        this.startEditLineItem((SalesLineItem)editItem, account);
    }

    public void startEditComboItem(SalesCombo editCombo, Account account) {
        ArrayList salesItemList = new ArrayList(editCombo.getSalesItems());
        salesItemList.sort(SalesItem.getSortBySequenceComparator());
        this.gui.setConstituents(editCombo.getQuantity(), editCombo.getLabel(), salesItemList, this.hasManyPriceLevels(salesItemList));
        this.gui.setPriceVisible(true);
        this.navPanel.setNotesVisible(false);
        this.gui.setSeatVisible(account.usesSeatNums() && Terminal.getLocalHost().getSeatNums());
        this.navPanel.setBreakComboVisible(true);
        this.startEditLineItem((SalesLineItem)editCombo, account);
    }

    private boolean hasManyPriceLevels(List components) {
        boolean levelsAvailable = false;
        block0: for (Object nextComponent : components) {
            if (nextComponent instanceof SalesComponent) {
                if (((SalesComponent)nextComponent).getUnit().getPrices().size() <= 1) continue;
                levelsAvailable = true;
                break;
            }
            if (!(nextComponent instanceof SalesItem)) continue;
            for (SalesComponent subComp : ((SalesItem)nextComponent).getComponentList()) {
                if (subComp.getUnit().getPrices().size() <= 1) continue;
                levelsAvailable = true;
                continue block0;
            }
        }
        return levelsAvailable;
    }

    void gotQuantity() {
        Price newPrice;
        Price delta;
        SalesQuantity newQuantity;
        SalesQuantity oldQuantity = this.currentItem.getQuantity();
        boolean isRefund = this.currentItem.isRefund();
        BigDecimal currentQty = isRefund ? this.currentItem.getQuantity().negate().getValue() : this.currentItem.getQuantity().getValue();
        String unitStr = Internationalization.getLiteralFor((String)"QUANTITY") + ":";
        if (isRefund) {
            unitStr = unitStr + "-";
        }
        BigDecimal newAmount = null;
        if (SystemProperty.getInstance().isFractionalQtys()) {
            newAmount = Dialogs.getBigDecimal((String)unitStr, (BigDecimal)currentQty, (int)SystemProperty.getInstance().getMaxNumbFigures(), (boolean)true, (String)"");
        } else {
            int value = Dialogs.getInteger((String)unitStr, (int)currentQty.intValue());
            if (value > Integer.MIN_VALUE) {
                newAmount = new BigDecimal(value);
            }
        }
        if (newAmount == null) {
            return;
        }
        SalesQuantity salesQuantity = newQuantity = isRefund ? new SalesQuantity(newAmount.negate()) : new SalesQuantity(newAmount);
        if (newQuantity.greaterThan(0L) && this.currentAccount instanceof CreditLimited && !this.checkOversell(delta = (newPrice = this.currentItem.getPricePerItem().multiply(newAmount.doubleValue())).subtract(this.currentItem.getPrice()))) {
            return;
        }
        if (newQuantity.equals(0L) && this.currentItem instanceof SalesCombo) {
            newQuantity = oldQuantity;
        }
        this.currentItem.setQuantity(newQuantity, LoginManager.getEventContext());
        this.gui.setQuantity(newQuantity);
        this.gui.setPrice(this.currentItem.getPricePerItem().multiply(newQuantity));
        if (this.currentItem instanceof SalesCombo) {
            this.gui.setConstituents(newQuantity, this.currentItem.getLabel(), this.currentItem.getSalesItems(), this.hasManyPriceLevels(this.currentItem.getSalesItems()));
        }
    }

    void gotComponent(Displayable theComponent) {
        this.componentSelected.emit((Object)theComponent);
    }

    void gotDone() {
        this.doneItem.emit();
    }

    void gotPrice() {
        this.editPriceScreen.start(this.currentItem);
        this.gui.setPrice(this.currentItem.getItemLevelPrice());
        this.updatePrice();
    }

    void gotSeat() {
        String text = CoversHelper.getCorrectCoverLiteral();
        int newSeat = Dialogs.getInteger((String)(text + " #"));
        if (newSeat != Integer.MIN_VALUE) {
            if (newSeat > CoversHelper.getValueForSeats((ItemGroup)this.currentAccount)) {
                String dialogTitle = Internationalization.getLiteralFor((String)"INVALID_SEAT_NUMBER") + "!";
                String dialogText = Internationalization.getLiteralFor((String)"THERE_IS_NO_SEAT_NUMBER") + " " + newSeat + " " + Internationalization.getLiteralFor((String)"FOR_THIS_TABLE") + ".";
                dialogTitle = CoversHelper.amendLiteral(dialogTitle);
                dialogText = CoversHelper.amendLiteral(dialogText);
                Dialogs.displayOkDialog((String)dialogText, (String)dialogTitle);
            } else {
                this.currentItem.setSeat(newSeat);
                this.gui.setSeat(newSeat);
                this.reassignCustomer(newSeat);
            }
        }
    }

    void gotNotes() {
        String notes = null;
        notes = this.currentItem.hasNotes() ? Dialogs.getString((String)(Internationalization.getLiteralFor((String)"NOTES") + ":"), (String)this.currentItem.getNotes()) : Dialogs.getString((String)(Internationalization.getLiteralFor((String)"NOTES") + ":"));
        if (!notes.equals("\u0000")) {
            this.currentItem.setNotes(notes);
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }

    void gotPriceLevel() {
        PriceLevelSelector.getInstance().doPriceLevel(this.currentItem, new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount));
        this.gui.setPrice(this.currentItem.getPricePerItem());
    }

    void gotBreakCombo() {
        if (this.currentItem instanceof SalesCombo) {
            new OrderComboHelper((GuiHandler)new WaitermateGuiHandler()).replaceCombo(this.currentAccount, (SalesCombo)this.currentItem, Terminal.getLocalHost(), LoginManager.getInstance().getUser());
            this.gotDone();
        } else {
            if (Config.isDebuging()) {
                throw new IllegalStateException("Cannot call break combo when editing an item");
            }
            WaiterMate.LOG.warn("Call to break combo from edit item screen when NOT editing a combo");
        }
    }

    private boolean checkOversell(Price newPriceOfItem) {
        Account account = this.currentAccount;
        if (account != null && account instanceof CreditLimited && ((CreditLimited)account).exceedsCreditLimit(newPriceOfItem)) {
            return CreditLimitPanel.doCreditLimitDialog((CreditLimited)account, newPriceOfItem, account.getLabel(), true);
        }
        return true;
    }

    void gotRefund() {
        String dialogResult = null;
        dialogResult = !this.currentItem.isRefund() ? RefundItems.doRefundQuestionDialog((Displayable)this.currentItem) : "ACTIVE";
        if (dialogResult != null) {
            this.currentItem.markAsQuickRefunded(LoginManager.getEventContext(), dialogResult);
        }
        this.updatePrice();
        this.updateRefundButton();
        this.gui.setQuantity(this.currentItem.getQuantity());
        this.display();
    }

    private void updatePrice() {
        Price itemLevelPrice = this.currentItem.getItemLevelPrice();
        this.gui.setPrice(itemLevelPrice);
        if (SystemProperty.getInstance().isEnforceBasePricesEnabled()) {
            this.gui.showBasePriceNotification(this.currentItem.getBasePrice());
        } else {
            this.gui.hideBasePriceNotification();
        }
    }

    private void updateRefundButton() {
        if (this.currentItem.isRefund()) {
            SalesItemQuantity mostRecentQuantity = SalesLineItemHelper.getLastSalesItemQuantity((SalesLineItem)this.currentItem);
            this.gui.setRefundText(mostRecentQuantity.getItemState());
        } else {
            this.gui.setRefundText("ACTIVE");
        }
        this.gui.setRefundButtonStatus(this.currentItem);
    }

    private void reassignCustomer(int targetSeat) {
        if (new CustomerAssignmentHelper().isAssignmentPerSeat(this.currentAccount)) {
            TableAccount tableAcc = (TableAccount)this.currentAccount;
            Customer customer = tableAcc.getCustomerForSeat(targetSeat);
            this.currentItem.setCustomer(customer);
        }
    }
}

