/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editprice;

import au.com.ordermate.util.Price;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.internationalization.Internationalization;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.modifyitem.editprice.EditPricePanel;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.guikit.ModalScreen;
import waitermate.guikit.NavBar;

public class EditPrice
extends ModalScreen {
    private EditPricePanel gui = new EditPricePanel();
    private NavBar nav = new NavBar();
    private SalesLineItem currentItem;

    public EditPrice() {
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.addRight((Component)this.nav.getCancelButton());
        this.nav.setText(Internationalization.getLiteralFor((String)"ENTER_NEW_PRICE_FOR_ITEM"));
        this.nav.cancel.connect((Object)this, "gotCancel");
        this.nav.ok.connect((Object)this, "gotOk");
    }

    public void start(SalesLineItem newCurrentItem) {
        this.currentItem = newCurrentItem;
        this.gui.setItem(newCurrentItem);
        this.display();
    }

    void gotOk() {
        Price newPrice = this.gui.getEnteredPrice();
        if (!this.checkForOversell(newPrice)) {
            return;
        }
        if (newPrice.doubleValue() != Double.MIN_VALUE) {
            Iterator it = this.currentItem.getDiscounts().iterator();
            while (it.hasNext()) {
                this.currentItem.removePriceAdjustment((SalesPriceAdjustment)it.next(), LoginManager.getEventContext());
            }
            boolean exTax = SystemProperty.getInstance().isExTax();
            if (this.gui.isPermanent()) {
                SalesItem item = (SalesItem)this.currentItem;
                SalesComponent firstComp = (SalesComponent)item.getComponentList().get(0);
                PriceLevel priceLevel = firstComp.getPriceLevel();
                InventoryItemUnit unit = firstComp.getUnit();
                UnitPriceLevel unitPriceLevel = unit.getUnitPriceLevel(priceLevel);
                newPrice = exTax ? unitPriceLevel.getPriceIncTaxFor(newPrice) : newPrice;
                unitPriceLevel.setPrice(newPrice);
                unitPriceLevel.save();
                SystemCurrentInfo.setMenuUpdate((String)Internationalization.getLiteralFor((String)"SALES_ITEM_PRICE_CHANGED"));
                item.resetPrice();
                TerminalEventLog.logPriceChange((EventContext)LoginManager.getEventContext(), (SalesItem)item, (Price)newPrice, (boolean)true);
            } else {
                this.currentItem.setPrice(newPrice, LoginManager.getEventContext());
            }
        }
        this.stopDisplay();
    }

    void gotCancel() {
        this.stopDisplay();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    private boolean checkForOversell(Price newPrice) {
        Price delta;
        Account account = this.currentItem.getAccount();
        if (account instanceof CreditLimited && ((CreditLimited)account).exceedsCreditLimit(delta = newPrice.multiply(this.currentItem.getQuantity()).subtract(this.currentItem.getPrice()))) {
            return CreditLimitPanel.doCreditLimitDialog((CreditLimited)account, delta, account.getLabel(), true);
        }
        return true;
    }
}

