/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editprice;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.AllPermissions;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.keypad.KeypadModel;
import ordermate.gui.keypad.PriceModel;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.LoginManager;

public class EditPricePanel
extends JPanel {
    private Keypad keypad;
    private JCheckBox permanentChangeCheck;
    private JPanel checkBoxPanel;
    private JLabel saveAll;

    public EditPricePanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(11, 10)));
        JLabel amountLabel = new JLabel(Internationalization.getLiteralFor((String)"PRICE") + ":");
        this.setAmountLabel(amountLabel);
        JLabel keypadLabel = new JLabel();
        this.keypad = new Keypad.KeypadBuilder().setOutputLabel(keypadLabel).build();
        this.keypad.setModel((KeypadModel)new PriceModel());
        this.keypad.setRenderer(Keypad.PRICE_RENDERER);
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(false);
        JPanel keypadPanel = new JPanel();
        keypadPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 10)));
        keypadPanel.add((Component)amountLabel, new Rectangle(1, 0, 2, 1));
        keypadPanel.add((Component)keypadLabel, new Rectangle(3, 0, 5, 1));
        keypadPanel.add((Component)this.keypad, new Rectangle(1, 1, 8, 8));
        this.add((Component)keypadPanel, new Rectangle(3, 1, 5, 8));
        this.checkBoxPanel = new JPanel(new FlowLayout());
        this.saveAll = new JLabel();
        this.saveAll.setFont(OrderMateTheme.getMediumFont());
        this.checkBoxPanel.add(this.saveAll);
        this.permanentChangeCheck = new JCheckBox();
        OrderMateTheme.setupTransparentButton((AbstractButton)this.permanentChangeCheck);
        this.permanentChangeCheck.setIcon(IconLoader.get((String)"/waitermate/images/cancel32.png"));
        this.permanentChangeCheck.setSelectedIcon(IconLoader.get((String)"/waitermate/images/ok32.png"));
        this.permanentChangeCheck.setPreferredSize(new Dimension(35, 35));
        this.checkBoxPanel.add((Component)new StandardSecurityDecorator((JComponent)this.permanentChangeCheck, AllPermissions.PERMANENT_PRICE_CHANGE));
        this.add((Component)this.checkBoxPanel, new Rectangle(2, 9, 7, 1));
    }

    private void setAmountLabel(JLabel amountLabel) {
        if (SystemProperty.getInstance().isExTax()) {
            amountLabel.setText(Internationalization.getLiteralFor((String)"PRICE_EX_TAX"));
        }
    }

    public Price getEnteredPrice() {
        Price thePrice = new Price(this.keypad.getValueAsDouble(), 0.01);
        this.keypad.setValue("");
        return thePrice;
    }

    public void setItem(SalesLineItem currentItem) {
        Price itemLevelPrice = currentItem.getItemLevelPricePerItem();
        this.keypad.setValue(itemLevelPrice.toString());
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(true);
        this.permanentChangeCheck.setSelected(false);
        if (currentItem instanceof SalesItem && ((SalesItem)currentItem).getComponentList().size() == 1 && LoginManager.getInstance().hasPermission(AllPermissions.PERMANENT_PRICE_CHANGE)) {
            SalesItem item = (SalesItem)currentItem;
            SalesComponent component = (SalesComponent)item.getComponentList().get(0);
            InventoryItemUnit unit = component.getUnit();
            PriceLevel priceLevel = component.getPriceLevel();
            unit = (InventoryItemUnit)PersistenceManager.reacquire((PersistentObjectI)unit);
            this.saveAll.setText(Internationalization.getLiteralFor((String)"MAKE_CHANGE_PERMANENT_FOR_PRICE_LEVEL") + " '" + priceLevel.getLabel() + "'");
            this.setCheckBoxVisible(true);
            this.setCheckBoxEnabled(unit.isPubliclyAccessible() && unit.hasUnitPriceLevel(priceLevel));
        } else {
            this.setCheckBoxVisible(false);
        }
    }

    private void setCheckBoxVisible(boolean b) {
        this.checkBoxPanel.setVisible(b);
    }

    private void setCheckBoxEnabled(boolean b) {
        this.permanentChangeCheck.setEnabled(b);
    }

    public boolean isPermanent() {
        return this.permanentChangeCheck.isSelected() && this.checkBoxPanel.isVisible() && this.permanentChangeCheck.isEnabled();
    }
}

