/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editstockcount;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.ConcurrentDatabaseModificationException;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.sales.SalesComponent;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.modifyitem.editstockcount.EditStockCountPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class EditStockCount
extends AbstractScreen {
    public final Signal back = Signals.createSignal();
    public final Signal confrimEdit = Signals.createSignal();
    private EditStockCountPanel gui = new EditStockCountPanel();
    private NavBar nav = new NavBar();
    private SalesQuantity stockCountOffset;
    private SalesComponent currentComp;
    private InventoryItemUnit unit;

    public EditStockCount() {
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.addRight((Component)this.nav.getCancelButton());
        JButton soldOut = this.nav.getClearButton();
        soldOut.setText(Internationalization.getLiteralFor((String)"ZERO_STOCK"));
        soldOut.setIcon(IconLoader.get((String)"/waitermate/images/StockCount.png"));
        this.nav.addLeft((Component)soldOut);
        this.nav.setText(Internationalization.getLiteralFor((String)"ENTER_NEW_STOCK_COUNT_FOR_ITEM"));
        this.nav.clear.connect((Object)this, "gotClear");
        this.nav.cancel.connect((Object)this, "gotCancel");
        this.nav.ok.connect((Object)this, "gotOk");
    }

    public void start(SalesComponent newCurrentComp, SalesQuantity stockCountOffsetBy) {
        this.stockCountOffset = stockCountOffsetBy;
        this.currentComp = newCurrentComp;
        this.unit = this.currentComp.getUnit();
        if (this.unit == null) {
            throw new NullPointerException("Sales component should have inventory item unit.");
        }
        SalesQuantity displayedStockCount = this.unit.getStockCountQuantity();
        displayedStockCount.subtract(this.stockCountOffset);
        boolean countDisabled = !this.unit.isStockCountDownEnabled();
        this.gui.setDisplayedData(displayedStockCount, countDisabled, this.stockCountOffset);
        this.gui.setCurrentOrderedQuantityDisplay(true);
        this.display(false);
    }

    public void start(InventoryItemUnit newItemUnit) {
        this.unit = newItemUnit;
        this.stockCountOffset = SalesQuantity.ZERO;
        if (this.unit == null) {
            throw new NullPointerException("Sales component should have inventory item unit.");
        }
        SalesQuantity displayedStockCount = this.unit.getStockCountQuantity();
        displayedStockCount.subtract(this.stockCountOffset);
        boolean countDisabled = !this.unit.isStockCountDownEnabled();
        this.gui.setDisplayedData(displayedStockCount, countDisabled, this.stockCountOffset);
        this.gui.setCurrentOrderedQuantityDisplay(false);
        this.display(false);
    }

    void gotOk() {
        SalesQuantity stockCount = this.gui.getStockCount();
        try {
            if (stockCount != null) {
                EventContext context = new EventContext(Terminal.getLocalHost(), User.getSystemUser());
                this.unit.setStockCountQty(stockCount.add(this.stockCountOffset), context);
            } else {
                this.unit.cancelStockCount();
            }
            this.tearDown();
            this.confrimEdit.emit();
        }
        catch (ConcurrentDatabaseModificationException ex) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"THIS_STOCK_COUNT_HAS_BEEN_CHANGED_AT_THE_SAME_TIME_BY_SOMEONE_ELSE") + " " + Internationalization.getLiteralFor((String)"CHECK_YOUR_COUNT_AND_RETRY")), (String)Internationalization.getLiteralFor((String)"CONCURRENT_MODIFICATION"));
        }
    }

    void gotCancel() {
        this.tearDown();
        this.back.emit();
    }

    void gotClear() {
        try {
            EventContext context = new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser());
            this.unit.setStockCountQty(new SalesQuantity(new BigDecimal(0)), context);
            this.tearDown();
            this.confrimEdit.emit();
        }
        catch (ConcurrentDatabaseModificationException ex) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"THIS_STOCK_COUNT_HAS_BEEN_CHANGED_AT_THE_SAME_TIME_BY_SOMEONE_ELSE") + " " + Internationalization.getLiteralFor((String)"CHECK_YOUR_COUNT_AND_RETRY")), (String)Internationalization.getLiteralFor((String)"CONCURRENT_MODIFICATION"));
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }
}

