/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editstockcount;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.units.SalesQuantity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.keypad.IntModel;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.keypad.KeypadModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.components.CustomCheckButton;

public class EditStockCountPanel
extends JPanel {
    private Keypad keypad;
    private CustomCheckButton enableButton;
    private CustomCheckButton includeCurrentOrderedQuantityButton;
    private JPanel buttonPanel;
    private JLabel includeCurrentOrderLabel;
    SalesQuantity currentOrderedQuantity = SalesQuantity.ZERO;
    private boolean updatesAllowed = true;

    public EditStockCountPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(10, 15)));
        JLabel amountLabel = new JLabel(Internationalization.getLiteralFor((String)"COUNT") + ":");
        JLabel keypadLabel = new JLabel();
        this.keypad = new Keypad.KeypadBuilder().setOutputLabel(keypadLabel).build();
        this.keypad.setModel((KeypadModel)new IntModel(4));
        this.keypad.setRenderer(Keypad.INT_RENDERER);
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(true);
        JPanel keypadPanel = new JPanel();
        keypadPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 10)));
        keypadPanel.add((Component)amountLabel, new Rectangle(1, 0, 2, 1));
        keypadPanel.add((Component)keypadLabel, new Rectangle(3, 0, 5, 1));
        keypadPanel.add((Component)this.keypad, new Rectangle(1, 1, 8, 9));
        this.add((Component)keypadPanel, new Rectangle(3, 1, 5, 11));
        this.buttonPanel = new JPanel(new FlowLayout(2));
        JLabel saveAll = new JLabel(Internationalization.getLiteralFor((String)"STOCK_COUNT_ENABLED"));
        saveAll.setFont(OrderMateTheme.getMediumFont());
        this.buttonPanel.add(saveAll);
        this.enableButton = new CustomCheckButton(false);
        this.enableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditStockCountPanel.this.updatesAllowed) {
                    EditStockCountPanel.this.updatesAllowed = false;
                    if (!EditStockCountPanel.this.enableButton.isSelected()) {
                        EditStockCountPanel.this.keypad.setValue("");
                        EditStockCountPanel.this.includeCurrentOrderedQuantityButton.setSelected(false);
                    }
                    EditStockCountPanel.this.enableCurrentOrderButton(EditStockCountPanel.this.enableButton.isSelected());
                    EditStockCountPanel.this.updatesAllowed = true;
                }
            }
        });
        this.enableButton.setName("enableStockCount");
        this.buttonPanel.add((Component)this.enableButton);
        this.includeCurrentOrderedQuantityButton = new CustomCheckButton(false);
        this.includeCurrentOrderedQuantityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditStockCountPanel.this.updatesAllowed) {
                    EditStockCountPanel.this.updatesAllowed = false;
                    if (EditStockCountPanel.this.includeCurrentOrderedQuantityButton.isSelected()) {
                        EditStockCountPanel.this.keypad.setValue(EditStockCountPanel.this.currentOrderedQuantity.add(new SalesQuantity(EditStockCountPanel.this.keypad.getValueAsBigDecimal())) + "");
                    } else {
                        EditStockCountPanel.this.keypad.setValue(SalesQuantity.valueOf((long)EditStockCountPanel.this.keypad.getValueAsInt()).subtract(EditStockCountPanel.this.currentOrderedQuantity) + "");
                    }
                    EditStockCountPanel.this.updatesAllowed = true;
                }
            }
        });
        this.includeCurrentOrderLabel = new JLabel("<html><h3>" + Internationalization.getLiteralFor((String)"INCLUDE_CURRENT_ORDERED_QUANTITY_QUESTIONMARK"));
        this.buttonPanel.add(this.includeCurrentOrderLabel);
        this.buttonPanel.add((Component)this.includeCurrentOrderedQuantityButton);
        this.keypad.updated.connect((Object)this, "gotKeypadUpdated");
        this.add((Component)this.buttonPanel, new Rectangle(3, 12, 5, 3));
        this.enableCurrentOrderButton(this.enableButton.isSelected());
    }

    void gotKeypadUpdated() {
        if (this.updatesAllowed) {
            this.enableButton.setSelected(true);
            this.enableCurrentOrderButton(true);
        }
    }

    public SalesQuantity getStockCount() {
        SalesQuantity count = SalesQuantity.valueOf((long)this.keypad.getValueAsInt());
        if (!this.enableButton.isSelected()) {
            return null;
        }
        if (this.includeCurrentOrderedQuantityButton.isSelected()) {
            return count.subtract(this.currentOrderedQuantity);
        }
        return count;
    }

    private void enableCurrentOrderButton(boolean enableIt) {
        if (enableIt) {
            this.includeCurrentOrderedQuantityButton.setEnabled(true);
            this.includeCurrentOrderLabel.setForeground(OrderMateTheme.getDefaultTextColor());
        } else {
            this.includeCurrentOrderedQuantityButton.setEnabled(false);
            this.includeCurrentOrderLabel.setForeground(Color.GRAY);
        }
    }

    public void setDisplayedData(SalesQuantity displayedCountValue, boolean disabled, SalesQuantity newCurrentOrderedQuantity) {
        this.currentOrderedQuantity = newCurrentOrderedQuantity;
        this.keypad.setValue(displayedCountValue + "");
        this.enableButton.setSelected(!disabled);
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(true);
        this.includeCurrentOrderLabel.setText("<html><h3>" + Internationalization.getLiteralFor((String)"INCLUDE_CURRENT_ORDERED_QUANTITY") + " (" + newCurrentOrderedQuantity + ")?</h3></html>");
        this.includeCurrentOrderedQuantityButton.setSelected(false);
        this.enableCurrentOrderButton(!disabled);
    }

    public void setCurrentOrderedQuantityDisplay(boolean b) {
        this.includeCurrentOrderedQuantityButton.setVisible(b);
        this.includeCurrentOrderLabel.setVisible(b);
    }
}

