/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.removemodification;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.persistence.Displayable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.modifyitem.editcomponent.EditComponent;

class RemoveModificationPanel
extends JPanel
implements ActionListener {
    private DefaultScrollPaneModel minuses;
    private CustomScrollPane minusPane;
    private DataScrollPaneModel addRemoveTypes;
    private CustomScrollPane addRemoveTypesPane;
    public final Signal<Displayable, ?, ?, ?, ?> minusSelected = Signals.createSignal(Displayable.class, (String)"theMinus");
    public final Signal typeSelected = Signals.createSignal(ModificationSize.class, (String)"theType");
    private static final int GRAPH_LAYOUT_WIDTH = 20;
    private static final int ADV_REMOVE_WIDTH = 3;

    public RemoveModificationPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 1)));
    }

    public void createLayout(boolean advanced) {
        if (advanced) {
            this.minuses = new DefaultScrollPaneModel(3, 5);
            this.minusPane = new CustomScrollPane((CustomScrollPaneModel)this.minuses);
            this.minusPane.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_MINUSES_FOR_THIS_ITEM"));
            this.add((Component)new NameDecorator((JComponent)this.minusPane, "minuses"), new Rectangle(0, 0, 17, 1));
            this.addRemoveTypes = new DataScrollPaneModel(1, 5);
            this.addRemoveTypes.objectSelected.connect((Object)this, "gotType");
            this.addRemoveTypesPane = new CustomScrollPane((CustomScrollPaneModel)this.addRemoveTypes);
            this.addRemoveTypesPane.setBorder((Border)new TitledBorder(Internationalization.getLiteralFor((String)"MULTIPLIER") + ":"));
            this.add((Component)new NameDecorator((JComponent)this.addRemoveTypesPane, "types"), new Rectangle(17, 0, 3, 1));
        } else {
            this.minuses = new DefaultScrollPaneModel(4, 5);
            this.minusPane = new CustomScrollPane((CustomScrollPaneModel)this.minuses);
            this.minusPane.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_MINUSES_FOR_THIS_ITEM"));
            this.add((Component)new NameDecorator((JComponent)this.minusPane, "minuses"), new Rectangle(0, 0, 20, 1));
        }
    }

    public void setMinuses(Collection<? extends InventoryRemovable> minusList, Collection<InventoryAdd> pluses) {
        List buttons = DataScrollPaneModel.createToggleButtons(pluses, null, (ActionListener)this, (boolean)false);
        for (NameDecorator decorator : buttons) {
            CustomToggleButton plusButton = (CustomToggleButton)decorator.getDecorateComponent();
            OrderMateThemeI.Helper.setButtonColour((AbstractButton)plusButton, (Color)plusButton.getForeground(), (Color)EditComponent.PLUS_COLOR);
        }
        List minusButtons = DataScrollPaneModel.createToggleButtons(minusList, null, (ActionListener)this, (boolean)false);
        for (NameDecorator decorator : minusButtons) {
            CustomToggleButton button = (CustomToggleButton)decorator.getDecorateComponent();
            Displayable disp = button.getData();
            if (!(disp instanceof StockInventoryUsageLink)) continue;
            String name = ((StockInventoryUsageLink)disp).getShortName();
            button.setText(name);
        }
        buttons.addAll(minusButtons);
        this.minuses.setItems((Collection)buttons);
        this.minusPane.displayPage(0);
    }

    public void setAddRemoveTypes(List theTypes) {
        this.addRemoveTypes.setItems(theTypes, true, true, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof CustomToggleButton) {
            CustomToggleButton source = (CustomToggleButton)e.getSource();
            Displayable data = source.getData();
            this.minusSelected.emit((Object)data);
        }
    }

    void gotType(Displayable type) {
        ModificationSize data = (ModificationSize)type;
        this.typeSelected.emit((Object)data);
    }
}

