/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount;

import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.AllPermissions;
import waitermate.LoginManager;
import waitermate.gui.actions.WaiterMatePermissibleAction;

public class AllowDeliveryAction
extends WaiterMatePermissibleAction {
    protected final Customer customer;
    protected final Account account;

    public AllowDeliveryAction(Account account, Customer customer) {
        super("Allow Delivery", AllPermissions.ALLOW_DELIVERY_TO_WARN_ZONE, IconLoader.get((String)"/waitermate/guikit/images/ok.png"));
        this.account = account;
        this.customer = customer;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.account instanceof PhoneAccount) {
            ((PhoneAccount)this.account).setDeliverToWarnZone(true);
        } else {
            OrderMate.LOG.warn("Unable to set deliver to warn zone flag on account " + this.account.getID());
        }
        TerminalEventLog.logAllowDeliveryToWarnZone((EventContext)LoginManager.getEventContext(), (Customer)this.customer, (ItemGroup)this.account);
    }
}

