/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount;

import au.com.ordermate.util.DateTimeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.integration.online.EtaMode;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.sales.Account;
import waitermate.gui.screens.ordering.saveaccount.AccountDetailsHelper;
import waitermate.gui.screens.ordering.saveaccount.EtaTimePickerNav;
import waitermate.gui.screens.ordering.saveaccount.details.EtaPickerPanel;
import waitermate.gui.screens.ordering.saveaccount.details.TimeSpinnerPanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.ObjectPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;

public class EtaTimePickerPopup
extends PopupWindow {
    private OnlineIntegrationETA etaConfiguration;
    private Date requestedDate;
    private Date requestedDateTime;
    private JLabel requestDetailsLabel;
    private TimeSpinnerPanel timePanel;
    private EtaPickerPanel etaPickerPanel;

    public EtaTimePickerPopup(OnlineIntegrationETA etaConfig, Account account) {
        this(etaConfig);
        this.setCustomerRequestDetails(account);
    }

    public EtaTimePickerPopup(OnlineIntegrationETA etaConfig) {
        super((NavBar)new EtaTimePickerNav());
        ((EtaTimePickerNav)this.getNavBar()).setAndOk.connect((Object)this, "gotSetAndOk");
        ((EtaTimePickerNav)this.getNavBar()).options.connect((Object)this, "gotOptions");
        this.etaConfiguration = etaConfig;
        this.etaPickerPanel = new EtaPickerPanel(this.etaConfiguration.getCurrentETA());
        this.etaPickerPanel.changed.connect((Object)this, "etaDefaultChange");
        JPanel centerEtaPanel = new JPanel(new BorderLayout());
        centerEtaPanel.add((Component)this.etaPickerPanel, "Center");
        this.requestDetailsLabel = new JLabel();
        this.requestDetailsLabel.setName("customerDetails");
        this.requestDetailsLabel.setVerticalTextPosition(0);
        this.requestDetailsLabel.setVerticalAlignment(0);
        this.requestDetailsLabel.setHorizontalAlignment(0);
        this.requestDetailsLabel.setHorizontalTextPosition(0);
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createTitledBorder("Customer Details:"));
        labelPanel.add((Component)this.requestDetailsLabel, "Center");
        JPanel etaChangerPanel = new JPanel(new BorderLayout());
        etaChangerPanel.add((Component)centerEtaPanel, "Center");
        etaChangerPanel.add((Component)labelPanel, "South");
        this.timePanel = new TimeSpinnerPanel();
        this.timePanel.changed.connect((Object)this, "timePickerChanged");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)etaChangerPanel, "North");
        centerPanel.add((Component)this.timePanel, "Center");
        this.setComponent(centerPanel);
    }

    public void setETAConfig(OnlineIntegrationETA config) {
        this.etaConfiguration = config;
        this.etaPickerPanel.setCurrentETA(this.etaConfiguration.getCurrentETA());
    }

    public Date getEta(Account account) {
        this.setCustomerRequestDetails(account);
        if (this.start()) {
            return this.timePanel.getSelectDatetime();
        }
        return new Date();
    }

    private void setCustomerRequestDetails(Account account) {
        this.requestedDate = account.getDateDue();
        if (this.requestedDate == null) {
            this.requestedDate = new Date();
        }
        this.requestedDateTime = AccountDetailsHelper.getRequestedDateTime(account);
        this.requestDetailsLabel.setText(AccountDetailsHelper.getCustomerOrderDetails(account, this.requestedDateTime));
        this.getNavBar().setText("Please select an estimated time for this order: " + AccountDetailsHelper.getAccountType(account));
        this.initTimePanel();
    }

    private void initTimePanel() {
        if (!DateTimeUtils.dateIsToday((Date)this.requestedDateTime)) {
            this.timePanel.setDateTime(this.requestedDateTime, this.requestedDateTime);
        } else {
            Date combinedEta = this.getEtaTime(new Time(System.currentTimeMillis()), this.etaConfiguration.getCurrentETA());
            if (combinedEta.before(this.requestedDateTime)) {
                this.timePanel.setDateTime(this.requestedDateTime, this.requestedDateTime);
            } else {
                this.timePanel.setDateTime(combinedEta, combinedEta);
            }
        }
    }

    private Date getEtaTime(Time time, int eta) {
        Time etaTime = DateTimeUtils.addMinutesToTime((Time)time, (int)eta);
        return DateTimeUtils.combineDateAndTime((Date)this.requestedDate, (Date)etaTime);
    }

    public void etaDefaultChange() {
        if (this.etaConfiguration.getCurrentETA() != this.etaPickerPanel.getETA()) {
            ((EtaTimePickerNav)this.getNavBar()).getOkButton().setVisible(false);
            ((EtaTimePickerNav)this.getNavBar()).getSetAndOkButton().setVisible(true);
        } else {
            ((EtaTimePickerNav)this.getNavBar()).getOkButton().setVisible(true);
            ((EtaTimePickerNav)this.getNavBar()).getSetAndOkButton().setVisible(false);
        }
        if (this.timePanel.isOriginalSet()) {
            Date rolledDate = this.getEtaTime(new Time(System.currentTimeMillis()), this.etaPickerPanel.getETA());
            this.timePanel.setDateTime(rolledDate, rolledDate);
        }
    }

    public void timePickerChanged() {
        if (this.requestedDateTime.after(this.timePanel.getSelectDatetime())) {
            ((EtaTimePickerNav)this.getNavBar()).getOkButton().setEnabled(false);
            ((EtaTimePickerNav)this.getNavBar()).getSetAndOkButton().setEnabled(false);
        } else {
            ((EtaTimePickerNav)this.getNavBar()).getOkButton().setEnabled(true);
            ((EtaTimePickerNav)this.getNavBar()).getSetAndOkButton().setEnabled(true);
        }
    }

    public void gotSetAndOk() {
        this.etaConfiguration.setCurrentETA(this.etaPickerPanel.getETA());
        this.etaConfiguration.save();
        this.getNavBar().ok.emit();
    }

    public void gotOptions() {
        ArrayList buttons = new ArrayList();
        Collections.addAll(buttons, EtaMode.values());
        ObjectPopupWindow optionsWindow = new ObjectPopupWindow("ETA Options", buttons, 1, buttons.size(), true, (ObjectPopupWindow.ObjectDisplayableLabelStrategy)new ObjectPopupWindow.ObjectDisplayableLabelStrategy<EtaMode>(){

            public String getDisplayableLabel(EtaMode object) {
                return object.getLabel();
            }
        });
        EtaMode newMode = (EtaMode)optionsWindow.start();
        if (newMode != null) {
            this.etaConfiguration.setETAMode(newMode);
            this.etaConfiguration.save();
        }
    }

    public Date getSelectedEstimatedDate() {
        return this.timePanel.getSelectDatetime();
    }
}

