/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TicketDataConfig;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.TakeawayAccount;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.KeyboardDialogForSamsung;
import waitermate.guikit.dialogs.KeypadDialog;
import waitermate.guikit.dialogs.OnePressPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;

public class WaiterMateTicketData {
    public static final String DINE_IN = Internationalization.getLiteralFor((String)"DINE_IN");
    public static final String TAKE_AWAY = Internationalization.getLiteralFor((String)"TAKEAWAY");
    private KeypadDialog keypadDialog;
    private KeyboardDialogForSamsung keyboardDialog;
    private PopupWindow standNamePopup;
    private PopupWindow standNumPopup;
    private OnePressPopupWindow eatInDialog;
    private final Account account;
    private String existingAccountType;
    private final Terminal terminal;
    private List<JComponent> componentList;
    private TicketDataConfig config;

    WaiterMateTicketData(Account account, Terminal terminal) {
        this.account = account;
        this.terminal = terminal;
        this.existingAccountType = null;
    }

    public boolean needsTicketData() {
        return this.account.requiresTicketDataEatIn(this.terminal) || this.account.requiresTicketDataStandNum(this.terminal) || this.account.requiresTicketDataName(this.terminal);
    }

    Collection<String> start() {
        if (!this.needsTicketData()) {
            return Collections.emptyList();
        }
        this.setupPanels();
        List<String> result = this.showPrompts();
        this.standNumPopup = null;
        this.standNamePopup = null;
        this.eatInDialog = null;
        this.keyboardDialog = null;
        this.keypadDialog = null;
        this.existingAccountType = null;
        return result;
    }

    private void setupPanels() {
        this.componentList = new ArrayList<JComponent>();
        this.config = this.terminal.getTicketDataConfig();
        this.checkTicketData();
        switch (this.config) {
            case AccountTypeFirst: {
                this.addAccountTypeDialog();
                this.addContextSensitiveTicketDialogs();
                break;
            }
            case TicketDataFirst: {
                this.addDefaultTicketDialogs();
                this.addAccountTypeDialog();
                break;
            }
            case NoAccountTypePrompt: {
                this.addDefaultTicketDialogs();
                break;
            }
        }
    }

    private boolean isUnAllocatedTableAccount() {
        TableAccount tableAccount;
        return AccountType.tableType.equals((Object)this.account.getAccountType()) && !(tableAccount = (TableAccount)this.account).isAllocated();
    }

    private void addAccountTypeDialog() {
        if (this.isUnAllocatedTableAccount()) {
            return;
        }
        if (!this.account.requiresTicketDataEatIn(this.terminal)) {
            if (this.account instanceof TakeawayAccount) {
                this.existingAccountType = AccountType.takeawayType.equals((Object)this.account.getAccountType()) ? TAKE_AWAY : DINE_IN;
            }
        } else {
            if (this.eatInDialog == null) {
                this.initEatInDialog();
            }
            this.componentList.add((JComponent)this.eatInDialog);
        }
    }

    private void initEatInDialog() {
        JButton eatInButton = new JButton(DINE_IN);
        JButton takeAwayButton = new JButton(TAKE_AWAY);
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        buttons.add(eatInButton);
        buttons.add(takeAwayButton);
        this.eatInDialog = new OnePressPopupWindow("Dine In or Take Away?", buttons, 1, 2, true);
        Dimension dim = new Dimension(200, 75);
        eatInButton.setPreferredSize(dim);
        eatInButton.setMinimumSize(dim);
        eatInButton.setMaximumSize(dim);
        takeAwayButton.setPreferredSize(dim);
        takeAwayButton.setMinimumSize(dim);
        takeAwayButton.setMaximumSize(dim);
    }

    private void addContextSensitiveTicketDialogs() {
        if (this.isUnAllocatedTableAccount()) {
            this.ensureListHasStandName(this.terminal.isQuicksaleDineinStandName());
            this.ensureListHasStandNum(this.terminal.isQuicksaleDineinStandNum());
        } else if (AccountType.takeawayType.equals((Object)this.account.getAccountType())) {
            if (((TakeawayAccount)this.account).isQuickSaleOriginated()) {
                this.ensureListHasStandName(this.terminal.isQuicksaleTakeawayStandName());
                this.ensureListHasStandNum(this.terminal.isQuicksaleTakeawayStandNum());
            } else {
                this.ensureListHasStandName(this.terminal.isTakeawayStandName());
                this.ensureListHasStandNum(this.terminal.isTakeawayStandNum());
            }
        } else if (AccountType.quickSaleDineInType.equals((Object)this.account.getAccountType())) {
            this.ensureListHasStandName(this.terminal.isQuicksaleDineinStandName());
            this.ensureListHasStandNum(this.terminal.isQuicksaleDineinStandNum());
        } else {
            this.ensureListHasStandName(this.terminal.isQuicksaleDineinStandName() || this.terminal.isQuicksaleTakeawayStandName());
            this.ensureListHasStandNum(this.terminal.isQuicksaleDineinStandNum() || this.terminal.isQuicksaleTakeawayStandNum());
        }
    }

    private PopupWindow getStandNamePopup() {
        if (this.standNamePopup == null) {
            this.standNamePopup = new PopupWindow();
            this.keyboardDialog = new KeyboardDialogForSamsung();
            this.keyboardDialog.setLabel("Customer Name:");
            this.standNamePopup.setCancelButtonVisible(false);
            this.standNamePopup.setBackButtonVisible(true);
            this.standNamePopup.setOkButtonVisible(true);
            this.standNamePopup.setComponent((JComponent)this.keyboardDialog);
            this.standNamePopup.setText("Enter Customer Name");
            this.standNamePopup.setPreferredSize(new Dimension(3000, 1500));
        }
        return this.standNamePopup;
    }

    private PopupWindow getStandNumPopup() {
        if (this.standNumPopup == null) {
            this.standNumPopup = new PopupWindow();
            this.standNumPopup.setCancelButtonVisible(false);
            this.standNumPopup.setBackButtonVisible(true);
            this.standNumPopup.setOkButtonVisible(true);
            this.keypadDialog = new KeypadDialog();
            this.keypadDialog.setup(false);
            this.keypadDialog.setUnits("Stand Number: ");
            this.keypadDialog.intInput();
            this.keypadDialog.setOverwriteValue(true);
            this.keypadDialog.setValue("0");
            this.standNumPopup.setComponent((JComponent)this.keypadDialog);
            this.standNumPopup.setText("Enter Stand Name");
        }
        return this.standNumPopup;
    }

    private void addDefaultTicketDialogs() {
        if (this.account.requiresTicketDataName(this.terminal)) {
            this.componentList.add((JComponent)this.getStandNamePopup());
        }
        if (this.account.requiresTicketDataStandNum(this.terminal)) {
            this.componentList.add((JComponent)this.getStandNumPopup());
        }
    }

    private void checkTicketData() {
        String newAccountType = null;
        for (String data : this.account.getTicketData()) {
            if (!data.equals(TAKE_AWAY) && !data.equals(DINE_IN)) continue;
            newAccountType = data;
        }
        if (newAccountType != null) {
            this.existingAccountType = newAccountType;
        }
    }

    private List<String> showPrompts() {
        boolean canceled = false;
        boolean backPressed = false;
        int counter = 0;
        ArrayList<String> data = new ArrayList<String>(this.componentList.size() + 1);
        if (this.existingAccountType != null) {
            data.add(this.existingAccountType);
        }
        while (!canceled && counter < this.componentList.size()) {
            JComponent currentComponent = this.componentList.get(counter);
            String value = null;
            if (currentComponent == this.eatInDialog) {
                JButton button = ((OnePressPopupWindow)currentComponent).start();
                if (button != null) {
                    value = button.getText();
                    if (counter == 0) {
                        this.adjustForDineInOrTakeaway(value);
                    }
                } else {
                    backPressed = true;
                }
            } else if (((PopupWindow)currentComponent).start()) {
                value = this.extractTicketData(currentComponent);
            } else {
                if (counter == 1 && this.config == TicketDataConfig.AccountTypeFirst) {
                    this.resetContextSensitiveDialogSequence();
                }
                backPressed = true;
            }
            if (backPressed) {
                if (--counter >= 0) {
                    data.remove(data.size() - 1);
                    backPressed = false;
                    continue;
                }
                canceled = true;
                continue;
            }
            if (this.existingAccountType != null && (this.componentList.size() > 1 && counter == 1 || this.componentList.size() == 1 && counter == 0)) {
                data.remove(0);
            }
            ++counter;
            data.add(value);
        }
        if (!canceled) {
            return data;
        }
        return null;
    }

    private String extractTicketData(JComponent component) {
        if (component == this.standNamePopup) {
            return "Customer: " + this.keyboardDialog.getValue();
        }
        if (component == this.standNumPopup) {
            return "Stand: " + this.keypadDialog.getValue();
        }
        return null;
    }

    private void adjustForDineInOrTakeaway(String selection) {
        if (DINE_IN.equals(selection)) {
            this.ensureListHasStandName(this.terminal.isQuicksaleDineinStandName());
            this.ensureListHasStandNum(this.terminal.isQuicksaleDineinStandNum());
        } else if (this.account instanceof TakeawayAccount && ((TakeawayAccount)this.account).isQuickSaleOriginated()) {
            this.ensureListHasStandName(this.terminal.isQuicksaleTakeawayStandName());
            this.ensureListHasStandNum(this.terminal.isQuicksaleTakeawayStandNum());
        } else {
            this.ensureListHasStandName(this.terminal.isTakeawayStandName());
            this.ensureListHasStandNum(this.terminal.isTakeawayStandNum());
        }
    }

    private void ensureListHasStandName(boolean mustHave) {
        if (mustHave) {
            if (!this.componentList.contains(this.getStandNamePopup())) {
                this.componentList.add((JComponent)this.getStandNamePopup());
            }
        } else if (this.standNamePopup != null) {
            this.componentList.remove(this.standNamePopup);
        }
    }

    private void ensureListHasStandNum(boolean mustHave) {
        if (mustHave) {
            if (!this.componentList.contains(this.getStandNumPopup())) {
                this.componentList.add((JComponent)this.getStandNumPopup());
            }
        } else if (this.standNumPopup != null) {
            this.componentList.remove(this.standNumPopup);
        }
    }

    private void resetContextSensitiveDialogSequence() {
        this.componentList.clear();
        this.addAccountTypeDialog();
        this.addContextSensitiveTicketDialogs();
    }
}

