/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount;

import au.com.ordermate.gui.GraphPaperLayout;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import ordermate.database.delivery.DeliveryZone;
import ordermate.gui.themes.OrderMateTheme;

public class WaitermateZoneSelectionPanel
extends JPanel {
    private JLabel infoLabel;
    private JLabel addressLabel;
    private JTextField addressText;
    private JLabel zoneLabel;
    private JComboBox zoneComboBox;
    private JLabel saveAddressLabel;
    private JToggleButton buttonSave;
    private JToggleButton buttonDontSave;
    private JPanel panel;
    private GridBagConstraints gc;

    public WaitermateZoneSelectionPanel() {
        this.initialize();
    }

    private void createComponents() {
        this.panel = new JPanel();
        this.infoLabel = new JLabel("This is a new address we have not seen before.", 0);
        this.addressLabel = new JLabel("Delivery Address");
        this.addressText = new JTextField();
        this.zoneLabel = new JLabel("Delivery Zone");
        this.zoneComboBox = new JComboBox();
        this.saveAddressLabel = new JLabel("Save Address For Later ?");
        this.buttonSave = new JToggleButton("Yes");
        this.buttonDontSave = new JToggleButton("No");
    }

    private void initialize() {
        this.createComponents();
        this.infoLabel.setFont(OrderMateTheme.getMediumFont());
        this.addressLabel.setFont(OrderMateTheme.getMediumFont());
        this.addressText.setFont(OrderMateTheme.getMediumFont());
        this.zoneLabel.setFont(OrderMateTheme.getMediumFont());
        this.saveAddressLabel.setFont(OrderMateTheme.getMediumFont());
        this.buttonDontSave.setFont(OrderMateTheme.getMediumFont());
        this.buttonSave.setFont(OrderMateTheme.getMediumFont());
        Border border = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1);
        this.panel.setBorder(border);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttonSave);
        buttonGroup.add(this.buttonDontSave);
        this.add(this.buttonSave);
        this.add(this.buttonDontSave);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 0));
        buttonPanel.add(this.buttonSave);
        buttonPanel.add(this.buttonDontSave);
        this.buttonSave.setSelected(true);
        this.panel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(3, 4), 10, 10));
        this.panel.add((Component)this.infoLabel, new Rectangle(0, 0, 3, 1));
        this.panel.add((Component)this.addressLabel, new Rectangle(0, 1, 1, 1));
        this.panel.add((Component)this.addressText, new Rectangle(1, 1, 2, 1));
        this.panel.add((Component)this.zoneLabel, new Rectangle(0, 2, 1, 1));
        this.panel.add((Component)this.zoneComboBox, new Rectangle(1, 2, 2, 1));
        this.panel.add((Component)this.saveAddressLabel, new Rectangle(0, 3, 1, 1));
        this.panel.add((Component)buttonPanel, new Rectangle(1, 3, 2, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.addressText.setText("");
        this.addressText.setEnabled(false);
        this.addressText.setBackground(Color.WHITE);
        this.addressText.setDisabledTextColor(Color.BLACK);
        this.addressText.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        this.addressText.setPreferredSize(new Dimension(this.addressLabel.getPreferredSize().width, 25));
        this.zoneComboBox.setModel(new EventComboBoxModel(GlazedLists.eventList((Collection)DeliveryZone.findAll())));
        this.setPreferredSize(new Dimension(650, 250));
    }

    public void setAddress(String address) {
        this.addressText.setText(address);
    }

    public boolean isSaveOptionChosen() {
        return this.buttonSave.isSelected();
    }

    public DeliveryZone getSelectedDeliveryZone() {
        return (DeliveryZone)this.zoneComboBox.getModel().getSelectedItem();
    }
}

