/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount.details;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.DecoratorLocation;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.saveaccount.details.SpinnerLabelButton;

public class EtaPickerPanel
extends JPanel {
    public final Signal<?, ?, ?, ?, ?> changed = Signals.createSignal();
    private int etaValue;
    private SpinnerLabelButton etaSpinner;
    private final int DEFAULT_INCREMENT_VALUE = 5;

    public EtaPickerPanel(int currentETAValue) {
        this.setName("EtaPickerPanel");
        this.setBorder(BorderFactory.createTitledBorder("Current ETA:"));
        this.etaValue = currentETAValue;
        JLabel label = new JLabel("Current Default ETA:");
        label.setHorizontalAlignment(0);
        this.etaSpinner = new SpinnerLabelButton("currentEta", this.getCurrentETA(), DecoratorLocation.West);
        this.etaSpinner.up.connect((Object)this, "moveUp");
        this.etaSpinner.down.connect((Object)this, "moveDown");
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(6, 1)));
        this.add((Component)label, new Rectangle(1, 0, 2, 1));
        this.add((Component)this.etaSpinner, new Rectangle(3, 0, 2, 1));
    }

    public int getETA() {
        return this.etaValue;
    }

    private String getCurrentETA() {
        return Integer.toString(this.etaValue);
    }

    public void setCurrentETA(int newETA) {
        this.etaValue = newETA;
        this.refresh();
    }

    private void refresh() {
        this.etaSpinner.setLabelText(this.getCurrentETA());
        this.changed.emit();
    }

    public void moveUp() {
        this.etaValue += 5;
        this.refresh();
    }

    public void moveDown() {
        this.etaValue = this.etaValue - 5 > 0 ? (this.etaValue -= 5) : 0;
        this.refresh();
    }
}

