/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.transferitems;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.users.User;
import ordermate.integration.reservations.ReservationNotifier;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.table.TableAccountSelection;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class QuickMoveBartabs
extends AbstractScreen {
    private LogicalTable sourceTable;
    Signal cancel = Signals.createSignal();
    Signal done = Signals.createSignal();
    private TableAccountSelection selectTable;
    private NavBar nav;

    QuickMoveBartabs(LogicalTable toMove) {
        this.sourceTable = toMove;
    }

    void startMove() {
        this.sourceTable.lock(LoginManager.getInstance().getUser());
        this.selectTable = new TableAccountSelection();
        this.selectTable.tableSelected.connect((Object)this, "gotTableSelected");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.back.connect(this.cancel);
        this.nav.setText("Please select the target table...");
        this.display();
    }

    public JComponent getMainArea() {
        return this.selectTable.getMainArea();
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotTableSelected(LogicalTable selected) {
        if (selected == null) {
            return;
        }
        if (this.sourceTable.equals((Object)selected)) {
            StringBuilder SB = new StringBuilder("<html>Cannot move to the same Table Account<br>");
            SB.append("<br>Please choose another table.</html");
            Dialogs.displayOkDialog((String)"Same Table", (String)SB.toString());
            return;
        }
        if (selected.getAccount() != null) {
            StringBuilder SB = new StringBuilder("<html>This table has a regular Table Account<br>");
            SB.append("on it.<br>BarTabs Accounts can only be linked to empty tables<br>").append("or tables with other bartabs on them.</html");
            Dialogs.displayOkDialog((String)"Cannot Move To This Table", (String)SB.toString());
            return;
        }
        User user = LoginManager.getInstance().getUser();
        if (!selected.lock(user)) {
            Dialogs.displayOkDialog((String)"Table Locked", (String)"<html>This table is currently locked by another user.</html>");
            return;
        }
        boolean goAhead = true;
        if (SystemProperty.getInstance().isShowTransferSummary()) {
            goAhead = this.confirmTransfer(selected);
        }
        if (goAhead) {
            this.doTransfer(user, selected);
        } else {
            selected.unlock();
        }
    }

    private boolean confirmTransfer(LogicalTable selection) {
        List barAccounts = this.sourceTable.getBarTabs();
        StringBuilder SB = new StringBuilder("<html>Confirm to move Tabs:<ol>");
        int count = 0;
        for (BarTabAccount account : barAccounts) {
            SB.append("<li>").append(account.getLabel()).append("</li>");
            if (++count <= 8) continue;
            SB.append("<li>").append(barAccounts.size() - count).append(" more...</li>");
        }
        SB.append("</ol>To table ").append(selection.getLabel()).append("?");
        return Dialogs.displayChoiceDialog((String)SB.toString(), (String)"Confirm Move Tabs", (boolean)true);
    }

    private void doTransfer(User user, LogicalTable targetTable) {
        ArrayList accounts = new ArrayList(this.sourceTable.getBarTabs());
        boolean goAhead = true;
        EventContext context = LoginManager.getEventContext();
        for (BarTabAccount account : accounts) {
            goAhead = true;
            if (!account.isLocked(user)) {
                goAhead = account.lock(user);
            }
            if (!goAhead) continue;
            LogicalTable existingTable = account.getLogicalTable();
            account.delinkFromLogicalTable();
            ReservationNotifier.notifyForDelinkedAccount((LogicalTable)existingTable, (Account)account, (ReservationNotifier.DelinkReason)ReservationNotifier.DelinkReason.TRANSFER);
            account.linkToLogicalTable(targetTable);
            WaitermateSaveAccount.getInstance().saveAccount((Account)account, context);
            ReservationNotifier.notifyForLinkedAccount((LogicalTable)targetTable, (Account)account);
            account.unlock();
        }
        this.sourceTable.unlock();
        targetTable.unlock();
        this.done.emit();
    }
}

