/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.transferitems;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ordermate.database.Lockable;
import ordermate.database.finance.CreditLimited;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.ordering.transferitems.QuickMoveBartabs;
import waitermate.gui.screens.ordering.transferitems.selectitems.SelectItems;
import waitermate.gui.screens.ordering.transferitems.selectsourceaccount.SelectSourceAccount;
import waitermate.gui.screens.ordering.transferitems.selecttargetaccount.SelectTargetAccount;
import waitermate.gui.screens.ordering.transferitems.summary.TransferSummary;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.guikit.dialogs.Dialogs;

public class TransferItems {
    private Signal transferDone;
    private Signal back;
    private Signal onGroupChangedSignal;
    private final SelectItems itemSelection;
    private final SelectTargetAccount targetAccountScreen;
    private final SelectSourceAccount sourceAccountScreen;
    private final TransferSummary summaryScreen;
    private List<Sellable> itemList;
    private Account source;
    private Account target;
    private List<Account> sourceAccounts;
    private boolean quick;
    private boolean needToSelectSource = false;
    private String tabToShow = null;
    private QuickMoveBartabs moveBartabs;
    private boolean inTransfer = false;
    private SellableWrapperFactory sellableFactory = new SellableWrapperFactory();
    private static final TransferItems instance = new TransferItems();

    public static TransferItems getInstance() {
        return instance;
    }

    private TransferItems() {
        this.itemSelection = new SelectItems(true, false);
        this.targetAccountScreen = new SelectTargetAccount();
        this.targetAccountScreen.setCanSelectMultipleAccounts(true);
        this.sourceAccountScreen = new SelectSourceAccount();
        this.sourceAccountScreen.setCanSelectMultipleAccounts(true);
        this.summaryScreen = new TransferSummary();
        this.itemSelection.back.connect((Object)this, "gotBack");
        this.itemSelection.items.connect((Object)this, "gotItemList");
        this.itemSelection.itemsSplit.connect((Object)this, "gotItemsSplit");
        this.targetAccountScreen.accountSelected.connect((Object)this, "gotTargetAccount");
        this.targetAccountScreen.accountsSelected.connect((Object)this, "gotTargetMultiAccounts");
        this.sourceAccountScreen.accountSelected.connect((Object)this, "gotSourceAccount");
        this.sourceAccountScreen.accountsSelected.connect((Object)this, "gotMultiSourceAccounts");
        this.sourceAccountScreen.back.connect((Object)this, "gotSelectSourceAborted");
        this.summaryScreen.back.connect((Object)this.targetAccountScreen, "startSelectAccount");
        this.summaryScreen.cancel.connect((Object)this, "gotCancel");
        this.summaryScreen.ok.connect((Object)this, "gotSummaryOk");
    }

    void gotCancel() {
        if (this.needToSelectSource) {
            if (this.source != null) {
                this.source.unlock();
            }
            this.needToSelectSource = false;
        }
        this.gotBack();
    }

    void gotBack() {
        if (this.needToSelectSource) {
            if (this.source != null) {
                this.source.unlock();
            }
            this.selectSource();
        } else {
            this.inTransfer = false;
            this.back.emit();
        }
    }

    void gotSummaryOk() {
        List salesLineItems = this.sellableFactory.getSellingObjectsAs(this.itemList, SalesLineItem.class);
        WaitermateSaveAccount.getInstance().performTransfer(this.source, this.target, salesLineItems, LoginManager.getEventContext());
        if (this.needToSelectSource) {
            this.needToSelectSource = false;
            this.source.unlock();
        }
        if (this.target instanceof TableAccount && this.onGroupChangedSignal != null) {
            this.onGroupChangedSignal.emit((Object)((TableAccount)this.target).getTable().getTableGroup());
        }
        this.source = null;
        this.target = null;
        this.onGroupChangedSignal = null;
        this.cleanUpAfterTransferProcess();
        this.transferDone.emit();
    }

    public void startTransfer(Account sourceAccount, Signal done, Signal backSignal, boolean quickTransfer) {
        this.inTransfer = true;
        this.source = sourceAccount;
        this.transferDone = done;
        this.back = backSignal;
        this.quick = quickTransfer;
        this.sourceAccountScreen.back.disconnect((Object)this.back);
        this.targetAccountScreen.back.disconnect((Object)this.itemSelection);
        this.targetAccountScreen.back.disconnect((Object)this);
        if (sourceAccount instanceof TableAccount && ((TableAccount)sourceAccount).getTable().getTableGroup() != null) {
            this.targetAccountScreen.setTableGroup(((TableAccount)sourceAccount).getTable().getTableGroup());
        }
        if (quickTransfer) {
            this.targetAccountScreen.back.connect((Object)this, "gotBack");
            this.gotItemList(new HashSet<Sellable>(this.sellableFactory.getSellables(sourceAccount.getItemHelper().getUnpaidItems())));
        } else {
            this.targetAccountScreen.back.connect((Object)this.itemSelection, "showSelection");
            this.itemSelection.startSelection(this.sellableFactory.getSellables(sourceAccount.getItemHelper().getUnpaidItems()));
        }
    }

    public void startTransfer(String startingTab, Signal doneSignal, Signal backSignal, boolean quickTransfer) {
        this.needToSelectSource = true;
        this.back = backSignal;
        this.transferDone = doneSignal;
        this.quick = quickTransfer;
        this.tabToShow = startingTab;
        this.selectSource();
    }

    public void startTransfer(String startingTab, Signal done, Signal backSignal, boolean quickTransfer, TableGroup currentGroup, Signal groupChangedSignal) {
        this.sourceAccountScreen.setTableGroup(currentGroup);
        this.onGroupChangedSignal = groupChangedSignal;
        this.startTransfer(startingTab, done, backSignal, quickTransfer);
    }

    private void selectSource() {
        if (this.tabToShow != null) {
            this.sourceAccountScreen.selectState(this.tabToShow);
        }
        if (this.source != null) {
            this.source.unlock();
        }
        this.sourceAccountScreen.startSelectAccount();
    }

    void gotSelectSourceAborted() {
        this.needToSelectSource = false;
        this.inTransfer = false;
        this.back.emit();
    }

    void gotItemsSplit(Account forAccount) {
        forAccount.save();
    }

    void gotItemList(Set<Sellable> items) {
        this.itemList = new ArrayList<Sellable>(items);
        TableGroup.incrementAllReloadNum();
        this.targetAccountScreen.startSelectAccount();
    }

    void gotMultiSourceAccounts(List<Account> accounts, Account selectedAccount) {
        this.sourceAccounts = accounts;
        if (this.sourceAccounts != null && !this.sourceAccounts.isEmpty()) {
            LogicalTable table = ((BarTabAccount)this.sourceAccounts.get(0)).getLogicalTable();
            this.moveBartabs = new QuickMoveBartabs(table);
            this.moveBartabs.cancel.connect((Object)this, "gotCancelMoveBarTabs");
            this.moveBartabs.done.connect((Object)this, "gotMoveBarTabsDone");
            this.moveBartabs.startMove();
        } else {
            this.gotBack();
        }
    }

    public void gotCancelMoveBarTabs() {
        this.disconnectMoveBartabs();
        this.gotBack();
    }

    public void gotMoveBarTabsDone() {
        this.disconnectMoveBartabs();
        this.transferDone.emit();
    }

    private void disconnectMoveBartabs() {
        if (this.moveBartabs != null) {
            this.moveBartabs.done.disconnect((Object)this);
            this.moveBartabs.cancel.disconnect((Object)this);
            this.moveBartabs = null;
        }
    }

    void gotSourceAccount(Account newSourceAccount) {
        this.source = newSourceAccount;
        if (this.source != null) {
            if (this.source.getPaid().equals((Object)Price.ZERO_DOLLAR)) {
                this.startTransfer(this.source, this.transferDone, this.back, this.quick);
            } else {
                Dialogs.displayDialog((JComponent)new JLabel("<html>This account has paid items and cannot be transferred.<br><br>Individual items can be transferred through <b>Account Admin - Transfer Items</b>.</html>"), (String)"Cannot Perform Quick Transfer", null, (String)"Cancel", (boolean)true, (boolean)false, (boolean)false);
                this.selectSource();
            }
        } else {
            this.gotBack();
        }
    }

    void gotTargetAccount(Account newTargetAccount) {
        CreditLimited limitedAcct;
        if (newTargetAccount.equals((Object)this.source)) {
            Dialogs.displayOkDialog((String)"You cannot transfer items to the account they came from", (String)"Select new account");
            return;
        }
        if (newTargetAccount instanceof CreditLimited && (limitedAcct = (CreditLimited)newTargetAccount).exceedsCreditLimit(this.source.getDue()) && !CreditLimitPanel.doCreditLimitDialog(limitedAcct, this.source.getDue(), newTargetAccount.getLabel(), true)) {
            newTargetAccount.unlock();
            return;
        }
        if (this.source.hasCustomer() && !newTargetAccount.hasCustomer()) {
            newTargetAccount.setCustomer(this.source.getCustomer(), LoginManager.getEventContext());
        }
        if (WaitermateSaveAccount.getInstance().addInfo(newTargetAccount)) {
            this.target = newTargetAccount;
            if (!this.target.isPersistent()) {
                this.target.removeAllItems(LoginManager.getEventContext());
            }
            if (SystemProperty.getInstance().isShowTransferSummary()) {
                this.summaryScreen.showSummary(this.itemList, this.source, this.target);
            } else {
                this.gotSummaryOk();
            }
        } else {
            this.targetAccountScreen.startSelectAccount();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void gotTargetMultiAccounts(List<Account> accounts, Account selectedTargetAccount) {
        if (accounts.isEmpty() || selectedTargetAccount != null) return;
        DataScrollPaneModel selection = new DataScrollPaneModel();
        selection.setItems(accounts, true, true, false);
        CustomScrollPane selectionPane = new CustomScrollPane((CustomScrollPaneModel)selection);
        selectionPane.setColumns(1);
        Dialogs.displayOkDialog((JComponent)selectionPane, (String)"Choose a tab account");
        if (selection.getSelections().isEmpty()) return;
        Account account = (Account)selection.getSelections().get(0);
        if (!WaitermateSaveAccount.getInstance().lockAccount((Lockable)account)) return;
        this.gotTargetAccount(account);
    }

    public boolean isInTransfer() {
        return this.inTransfer;
    }

    private void cleanUpAfterTransferProcess() {
        this.inTransfer = false;
    }
}

