/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.transferitems.summary;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.TextScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class SummaryPanel
extends JPanel
implements ActionListener {
    private static final int MAX_DISPLAY_ITEMS = 7;
    private JLabel sourceAccount;
    private JLabel targetAccount;
    private JLabel headingLabel;
    private List itemLabels;
    private TextScrollPaneModel textScroll;
    private JButton targetPatrons = new JButton();
    private JButton sourcePatrons = new JButton();
    private int sourceNumPatrons;
    private int targetNumPatrons;
    public Signal changeSourceNumPatrons = Signals.createSignal();
    public Signal changeTargetNumPatrons = Signals.createSignal();

    public SummaryPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(16, 20)));
        this.sourceAccount = new JLabel();
        this.sourceAccount.setFont(OrderMateTheme.getLargeFont());
        this.add((Component)this.sourceAccount, new Rectangle(3, 1, 4, 4));
        this.targetAccount = new JLabel();
        this.targetAccount.setFont(OrderMateTheme.getLargeFont());
        this.add((Component)this.targetAccount, new Rectangle(10, 1, 4, 4));
        this.headingLabel = new JLabel();
        this.headingLabel.setFont(OrderMateTheme.getLargeFont());
        this.add((Component)this.headingLabel, new Rectangle(1, 7, 14, 1));
        JLabel labelImage = new JLabel();
        labelImage.setIcon(IconLoader.get((String)"/waitermate/images/transfer.png"));
        this.add((Component)labelImage, new Rectangle(8, 2, 2, 2));
        JLabel patronsLabel = new JLabel(Internationalization.getLiteralFor((String)"COVERS"));
        patronsLabel.setFont(OrderMateTheme.getLargeFont());
        patronsLabel.setHorizontalAlignment(4);
        this.add((Component)patronsLabel, new Rectangle(1, 5, 3, 1));
        this.add((Component)this.sourcePatrons, new Rectangle(5, 5, 2, 2));
        this.add((Component)this.targetPatrons, new Rectangle(10, 5, 2, 2));
        this.sourcePatrons.addActionListener(this);
        this.targetPatrons.addActionListener(this);
        this.textScroll = new TextScrollPaneModel(7);
        this.textScroll.setFont(OrderMateTheme.getMediumFont());
        CustomScrollPane scroll = new CustomScrollPane((CustomScrollPaneModel)this.textScroll);
        this.add((Component)scroll, new Rectangle(2, 9, 8, 11));
        this.itemLabels = new ArrayList();
    }

    public void setItems(List items) {
        this.textScroll.clear();
        for (JLabel toRemove : this.itemLabels) {
            this.remove(toRemove);
        }
        this.headingLabel.setText(items.size() + " items to transfer");
        SellableWrapperFactory factory = new SellableWrapperFactory();
        List salesItems = factory.getSellingObjectsAs(items, SalesLineItem.class);
        for (SalesLineItem item : salesItems) {
            String textDisplay = item.getQuantity() + " " + item.getLabel();
            this.textScroll.addLine(textDisplay);
        }
    }

    public void setAccounts(Account source, Account target) {
        this.sourceAccount.setText("From " + source.getLabel());
        this.targetAccount.setText("To " + target.getLabel());
        this.setSourceNumPatrons(source.getNumPatrons());
        this.setTargetNumPatrons(target.getNumPatrons());
    }

    public int getSourceNumPatrons() {
        return this.sourceNumPatrons;
    }

    public void setSourceNumPatrons(int newSourceNumPatrons) {
        this.sourceNumPatrons = newSourceNumPatrons;
        this.sourcePatrons.setText(Integer.toString(newSourceNumPatrons));
    }

    public int getTargetNumPatrons() {
        return this.targetNumPatrons;
    }

    public void setTargetNumPatrons(int newTargetNumPatrons) {
        this.targetNumPatrons = newTargetNumPatrons;
        this.targetPatrons.setText(Integer.toString(newTargetNumPatrons));
    }

    public void setSourceNumPatronsEnabled(boolean canChange) {
        this.sourcePatrons.setEnabled(canChange);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sourcePatrons) {
            this.changeSourceNumPatrons.emit();
        } else if (e.getSource() == this.targetPatrons) {
            this.changeTargetNumPatrons.emit();
        }
    }

    void setSourcePatronsVisible(boolean b) {
        this.sourcePatrons.setVisible(b);
    }

    void setTargetPatronsVisible(boolean b) {
        this.targetPatrons.setVisible(b);
    }
}

