/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.accountitems.SelectItemsPanel;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.guikit.NavBar;
import waitermate.guikit.components.DrawerToggleButton;

public abstract class AbstractTransactionNav
extends NavBar
implements ActionListener {
    public final Signal<Price, ?, ?, ?, ?> priceSelected = Signals.createSignal(Price.class, (String)"price");
    public final Signal selectionChanged;
    private ItemsWidget items;
    private SelectItemsPanel selectItemsPanel;
    private boolean selectItems;
    private List<Sellable> allPossibleItems;
    private boolean okPriceEnabled;
    private JButton selectAll;
    private JButton selectNone;

    public AbstractTransactionNav(boolean canSelectItems) {
        this.selectItems = canSelectItems;
        this.addLeft(this.getBackButton());
        if (this.selectItems) {
            JPanel itemSelection = new JPanel(new BorderLayout());
            this.selectItemsPanel = new SelectItemsPanel(2);
            this.selectItemsPanel.setShowCourses(false);
            this.selectItemsPanel.selectionChanged.connect((Object)this, "selectionChanged");
            this.selectItemsPanel.itemsSplit.connect((Object)this, "gotItemsSplit");
            this.selectionChanged = this.selectItemsPanel.selectionChanged;
            itemSelection.add(this.selectItemsPanel);
            JPanel controlButtons = new JPanel(new FlowLayout());
            this.selectAll = new JButton("All");
            this.selectAll.addActionListener(this);
            this.selectAll.setIcon(IconLoader.get((String)"/waitermate/images/selectAll.png"));
            controlButtons.add(this.selectAll);
            this.selectNone = new JButton("None");
            this.selectNone.addActionListener(this);
            this.selectNone.setIcon(IconLoader.get((String)"/waitermate/images/selectNone.png"));
            controlButtons.add(this.selectNone);
            itemSelection.add((Component)controlButtons, "South");
            this.items = new ItemsWidget(itemSelection);
            this.addLeft(this.items);
            Dimension size = itemSelection.getPreferredSize();
            size.width = 500;
            size.height = 500;
            itemSelection.setPreferredSize(size);
        } else {
            this.selectionChanged = null;
        }
        this.setText("Create new transaction");
        this.addRight(this.getOkButton());
    }

    public void gotPriceSelected(Price p) {
        this.priceSelected.emit((Object)p);
    }

    public void gotItemsSplit(Account forAccount) {
        forAccount.save();
    }

    public void updateOkButton() {
        this.getOkButton().setEnabled(this.okPriceEnabled && this.hasSelectedItems());
    }

    protected void setOKPriceEnabled(boolean isEnabled) {
        this.okPriceEnabled = isEnabled;
        this.updateOkButton();
    }

    public void setItems(ItemGroup paying, List<Sellable> itemsToSet) {
        this.allPossibleItems = itemsToSet;
        if (this.canSelectItems()) {
            if (Terminal.getLocalHost().getSeatNums() && paying.usesSeatNums()) {
                this.selectItemsPanel.setNumSeats(CoversHelper.getValueForSeats(paying));
            } else {
                this.selectItemsPanel.setNumSeats(0);
            }
            this.selectItemsPanel.setItems(this.allPossibleItems);
            this.selectItemsPanel.selectAll();
        }
    }

    public boolean hasSelectedItems() {
        return !this.selectItems || !this.selectItemsPanel.getSelectedItems().isEmpty();
    }

    public Set<Sellable> getSelectedItems() {
        if (this.canSelectItems()) {
            return this.selectItemsPanel.getSelectedItems();
        }
        return new HashSet<Sellable>(this.allPossibleItems);
    }

    public boolean canSelectItems() {
        return this.selectItems;
    }

    public void selectionChanged(Set newSelection) {
        String numItems = newSelection.size() == this.selectItemsPanel.getItems().size() ? "All" : (newSelection.isEmpty() ? "No" : Integer.toString(newSelection.size()));
        this.items.setNumItems(numItems);
        this.updateOkButton();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectAll) {
            this.selectItemsPanel.selectAll();
        } else if (e.getSource() == this.selectNone) {
            this.selectItemsPanel.selectNone();
        } else {
            super.actionPerformed(e);
        }
    }

    private class ItemsWidget
    extends JPanel {
        private JLabel numItemsLabel;

        public ItemsWidget(JComponent theItems) {
            this.setBorder(new TitledBorder("Paying off:"));
            this.setOpaque(false);
            this.numItemsLabel = new JLabel("All Items");
            this.numItemsLabel.setFont(OrderMateTheme.getMediumFont());
            this.add(this.numItemsLabel);
            DrawerToggleButton upButton = AbstractTransactionNav.this.constructDrawerToggleButton("Select items", IconLoader.get((String)"/waitermate/images/selectItemsUp.png"), IconLoader.get((String)"/waitermate/images/selectItemsDown.png"));
            upButton.setDrawer(theItems);
            this.add((Component)upButton);
        }

        public void setNumItems(String numItems) {
            this.numItemsLabel.setText(numItems + " Items");
        }
    }
}

