/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.cashtransaction;

import au.com.ordermate.util.Price;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.Payable;
import ordermate.database.finance.ChangeCalculator;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.database.users.User;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.AbstractTransactionNav;
import waitermate.gui.screens.payment.AbstractTransactionScreen;
import waitermate.gui.screens.payment.cashtransaction.CashTransactionNav;
import waitermate.gui.screens.payment.cashtransaction.CashTransactionPanel;
import waitermate.gui.screens.payment.cashtransaction.DenominationPopup;
import waitermate.guikit.dialogs.Dialogs;

public class CashTransactionScreen
extends AbstractTransactionScreen {
    final Signal valuesChanged = Signals.createSignal(Price.class, (String)"due", Price.class, (String)"paid", Price.class, (String)"tip", Price.class, (String)"tendered");
    final Signal valuesChangedNav = Signals.createSignal(Price.class, (String)"paid", Price.class, (String)"tip", Price.class, (String)"tendered");
    private Price paid;
    private Price tip;
    private Price tendered;
    private String note;
    private CashTransactionPanel gui = new CashTransactionPanel();

    public CashTransactionScreen() {
        this.gui.paidUpdated.connect((Object)this, "gotPaid");
        this.gui.tenderedUpdated.connect((Object)this, "gotTendered");
        this.gui.tipUpdated.connect((Object)this, "gotTip");
        this.valuesChanged.connect((Object)this.gui, "setDetails");
        this.setupNav();
        this.valuesChangedNav.connect((Object)this.getNavBar(), "setDetails");
    }

    @Override
    public void startAddingTransaction(Price due, Payable payGroup) {
        super.startAddingTransaction(due, payGroup);
        Price dueRounded = new Price(due.doubleValue(), Price.DEFAULT_ROUND_AMOUNT);
        this.paid = new Price((Number)due);
        this.tip = new Price(0.0);
        this.tendered = dueRounded;
        this.gui.resetDisplay();
        this.gui.setPaidEnabled(payGroup.isPaidModifiable());
        this.valuesChanged.emit((Object)this.paid, (Object)dueRounded, (Object)this.tip, (Object)this.tendered);
        this.valuesChangedNav.emit((Object)this.paid, (Object)this.tip, (Object)this.tendered);
        this.display();
    }

    @Override
    protected FinanceTransaction createTransaction(boolean autoSurcharge) {
        User user = LoginManager.getInstance().getUser();
        Terminal terminal = Terminal.getLocalHost();
        CashDrawer cashdrawer = terminal.getAssignedCashDrawer(user);
        CashTransaction newTransaction = new CashTransaction(user, terminal, this.tendered, this.paid, this.tip, cashdrawer, terminal.getShift());
        if (this.note != null && !this.note.isEmpty()) {
            newTransaction.setNote(this.note);
        }
        return newTransaction;
    }

    @Override
    protected void postCreateTransaction(FinanceTransaction txn) {
        ChangeCalculator cakelayta;
        List noms;
        super.postCreateTransaction(txn);
        if (SystemProperty.getInstance().isShowChange() && !(noms = (cakelayta = new ChangeCalculator(Denomination.getDenominations())).calculateChange(this.tendered, this.paid.add(this.tip))).isEmpty()) {
            DenominationPopup popup = new DenominationPopup();
            popup.showDenominations(noms);
        }
    }

    @Override
    public void gotRecommendedPriceSelected(Price p) {
        this.paid = p;
        this.tip = Price.ZERO;
        this.tendered = p;
        this.gui.setDetails(this.getDue(), this.paid, this.tip, this.tendered);
    }

    void gotPaid(Price value) {
        this.paid = value;
        this.updateGui();
    }

    void gotTip(Price value) {
        this.tip = value;
        this.updateGui();
    }

    void gotTendered(Price value) {
        this.tendered = value;
        this.updateGui();
    }

    void gotNote() {
        this.note = Dialogs.getString((String)"Note", (String)"", (boolean)true, (String)"Type note:");
        this.updateGui();
    }

    private void updateGui() {
        Price changeAmount = new Price(this.tendered.doubleValue() - (this.tip.doubleValue() + this.paid.doubleValue()));
        Price balanceAmount = new Price(this.getDue().doubleValue() - this.paid.doubleValue());
        Price subtotalAmount = new Price(this.tip.doubleValue() + this.paid.doubleValue());
        this.gui.updateDisplay(balanceAmount, changeAmount, subtotalAmount);
        this.valuesChangedNav.emit((Object)this.paid, (Object)this.tip, (Object)this.tendered);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    @Override
    public AbstractTransactionNav createNavBar() {
        CashTransactionNav nav = new CashTransactionNav();
        nav.noteUpdated.connect((Object)this, "gotNote");
        return nav;
    }

    @Override
    public List<Sellable> getPayableItemsFromItemGroup(ItemGroup group) {
        return this.sellableFactory.getSellables(group);
    }
}

