/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.credittransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.TransactionSummary;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.components.CustomCheckButton;

class CreditTransactionPanel
extends JPanel
implements ActionListener {
    private static int LABEL_START = 0;
    private static int LABEL_WIDTH;
    private static int COMPONENT_START;
    private static int COMPONENT_WIDTH;
    private JLabel due;
    private JLabel subTotal;
    private JLabel balance;
    private JLabel surchargeLabel;
    private CustomCheckButton surchargeCheck;
    private StandardSecurityDecorator surchargeSecurity;
    private JButton paid;
    private JButton tip;
    private DefaultScrollPaneModel subTypes;
    private List buttons;
    public final Signal paidSelected = Signals.createSignal();
    public final Signal tipSelected = Signals.createSignal();
    public final Signal typeChanged = Signals.createSignal();

    public CreditTransactionPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        JPanel textPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 7), 0, 0));
        this.add((Component)textPanel, new Rectangle(7, 0, 10, 20));
        textPanel.add((Component)new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"DUE") + "</h2></html>"), new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.due = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.due.setName("dueLabel");
        textPanel.add((Component)this.due, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        JPanel group1 = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 4), 5, 5));
        group1.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SUBTOTAL")));
        textPanel.add((Component)group1, new Rectangle(0, 1, 10, 3));
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"PAID")), new Rectangle(LABEL_START, 0, LABEL_WIDTH, 1));
        this.paid = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.paid.addActionListener(this);
        group1.add((Component)this.paid, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, 1));
        this.paid.setName("paid");
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"TIP")), new Rectangle(LABEL_START, 1, LABEL_WIDTH, 1));
        this.tip = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.tip.addActionListener(this);
        this.tip.setName("tip");
        group1.add((Component)new StandardSecurityDecorator((JComponent)this.tip, AllPermissions.TIPS), new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, 1));
        this.surchargeLabel = new JLabel(Internationalization.getLiteralFor((String)"SURCHARGE"));
        group1.add((Component)this.surchargeLabel, new Rectangle(LABEL_START, 2, LABEL_WIDTH, 1));
        this.surchargeLabel.setName("creditSurchargeLabel");
        this.surchargeCheck = new CustomCheckButton();
        this.surchargeCheck.setName("creditSurchargeCheck");
        this.surchargeCheck.addActionListener((ActionListener)this);
        this.surchargeCheck.setSelected(true);
        this.surchargeSecurity = new StandardSecurityDecorator((JComponent)this.surchargeCheck, AllPermissions.REMOVE_PAYMENT_SURCHARGE);
        this.surchargeCheck.setVisible(true);
        this.surchargeSecurity.setVisible(true);
        this.surchargeSecurity.setSecurityVisible(true);
        group1.add((Component)this.surchargeSecurity, new Rectangle(COMPONENT_START, 2, COMPONENT_WIDTH, 1));
        group1.add((Component)new JLabel("       " + Internationalization.getLiteralFor((String)"SUB_TOTAL")), new Rectangle(LABEL_START, 3, LABEL_WIDTH, 1));
        this.subTotal = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        group1.add((Component)this.subTotal, new Rectangle(COMPONENT_START, 3, COMPONENT_WIDTH, 1));
        this.subTotal.setName("subTotalLabel");
        textPanel.add((Component)new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"BALANCE") + "</h2></html>"), new Rectangle(LABEL_START, 4, LABEL_WIDTH, 1));
        this.balance = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        textPanel.add((Component)this.balance, new Rectangle(COMPONENT_START, 4, COMPONENT_WIDTH, 1));
        this.balance.setName("balanceLabel");
        this.subTypes = new DefaultScrollPaneModel(1, 7);
        CustomScrollPane pane = new CustomScrollPane((CustomScrollPaneModel)this.subTypes);
        this.add((Component)pane, new Rectangle(0, 0, 5, 20));
    }

    public void setDetails(TransactionSummary summary) {
        this.due.setText("<html><h2>" + summary.getDue() + "</h2></html>");
        this.paid.setText(summary.getPaid().toString());
        this.tip.setText(summary.getTip().toString());
        this.subTotal.setText(summary.getTotal().toString());
        Price balancePrice = new Price(summary.getDue().doubleValue() - summary.getPaid().doubleValue(), 0.01);
        this.surchargeSecurity.setSecurityVisible(true);
        this.surchargeSecurity.setVisible(true);
        this.surchargeCheck.setText(summary.getSurcharge().toString(true));
        if (balancePrice.doubleValue() >= 0.0) {
            this.balance.setText("<html><h2>" + balancePrice + "</h2></html>");
        } else {
            this.balance.setText("<html><h2><font color=\"red\">" + balancePrice + "</font></h2></html>");
        }
    }

    public void setPaidEnabled(boolean enabled) {
        this.paid.setEnabled(enabled);
    }

    public FinanceUnit getSelectedSubType() {
        Iterator it = this.buttons.iterator();
        CustomToggleButton selectedButton = null;
        while (it.hasNext()) {
            NameDecorator decorator = (NameDecorator)it.next();
            CustomToggleButton button = (CustomToggleButton)decorator.getDecorateComponent();
            if (!button.isSelected()) continue;
            selectedButton = button;
        }
        return selectedButton != null ? (FinanceUnit)selectedButton.getData() : null;
    }

    public void setSubTypes(List subtypes) {
        this.buttons = DataScrollPaneModel.createToggleButtons((Collection)subtypes, (ButtonGroup)new ButtonGroup(), (ActionListener)this);
        this.subTypes.setItems((Collection)this.buttons);
        this.typeChanged.emit();
    }

    void enableAutoSurcharge(boolean surchargeAuto) {
        this.surchargeLabel.setEnabled(!surchargeAuto);
        this.surchargeCheck.setEnabled(!surchargeAuto && !AdyenIntegrationConfig.getInstance().isConfigured());
        this.surchargeSecurity.setEnabled(!surchargeAuto && !AdyenIntegrationConfig.getInstance().isConfigured());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.paid) {
            this.paidSelected.emit();
        } else if (e.getSource() == this.tip) {
            this.tipSelected.emit();
        } else {
            this.typeChanged.emit();
        }
    }

    public boolean isSurchargeSelected() {
        if (this.surchargeCheck != null) {
            return this.surchargeCheck.isSelected();
        }
        return true;
    }

    public void setSurchargeLabel(String string) {
        this.surchargeLabel.setText(string);
    }

    public void setSurchargeSelected(boolean selected) {
        this.surchargeCheck.setSelected(selected);
    }

    public void setButtonsEnabled(boolean enabled) {
        this.paid.setEnabled(enabled);
        this.tip.setEnabled(enabled);
        this.surchargeCheck.setEnabled(enabled && !AdyenIntegrationConfig.getInstance().isConfigured());
    }

    static {
        COMPONENT_START = LABEL_WIDTH = 7;
        COMPONENT_WIDTH = 3;
    }
}

