/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.credittransaction;

import au.com.ordermate.util.Price;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.TransactionSummary;
import ordermate.database.finance.transactions.CreditTransactionHelper;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.unorderable.UnorderableSalesItemFactory;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.AbstractTransactionNav;
import waitermate.gui.screens.payment.credittransaction.CreditTransactionNav;
import waitermate.gui.screens.payment.credittransaction.CreditTransactionPanel;
import waitermate.gui.screens.payment.eftpos.EftposTransactionScreen;
import waitermate.guikit.dialogs.Dialogs;

public class CreditTransactionScreen
extends EftposTransactionScreen {
    private final DecimalFormat format = new DecimalFormat("0.0#%");
    private Price paid;
    private Price tip;
    private CreditTransactionPanel gui;
    private Price surcharge;
    private FinanceUnit type;
    Signal<TransactionSummary, ?, ?, ?, ?> valuesChanged = Signals.createSignal(TransactionSummary.class, (String)"due");

    public CreditTransactionScreen() {
        this.gui = new CreditTransactionPanel();
        this.gui.paidSelected.connect((Object)this, "gotPaid");
        this.gui.tipSelected.connect((Object)this, "gotTip");
        this.gui.typeChanged.connect((Object)this, "gotType");
        this.valuesChanged.connect((Object)this.gui, "setDetails");
        this.valuesChanged.connect((Object)this.getNavBar(), "setDetails");
    }

    @Override
    public void startAddingTransaction(Price due, Payable payGroup) {
        super.startAddingTransaction(due, payGroup);
        this.paid = new Price(due.doubleValue(), 0.01);
        this.tip = new Price(0.0, 0.01);
        this.gui.setSubTypes(FinanceUnit.getActiveCreditUnits());
        this.gui.setPaidEnabled(payGroup.isPaidModifiable());
        if (!this.autoSurchargeEnabled) {
            this.gui.setSurchargeSelected(true);
        }
        this.update();
        this.display();
    }

    private void update() {
        if (this.gui != null && this.type != null) {
            if (this.gui.isSurchargeSelected() && !this.autoSurchargeEnabled) {
                this.surcharge = FinanceSurchargeCalculator.calculateSurcharge((Price)this.paid, (Price)this.tip, (FinanceUnit)this.type);
                this.gui.setSurchargeLabel("Surcharge for " + this.type.getLabel() + " (" + this.format.format(this.type.getSurcharge()) + ")");
            } else {
                this.surcharge = Price.ZERO_DOLLAR;
            }
        } else {
            this.surcharge = Price.ZERO_DOLLAR;
        }
        this.valuesChanged.emit((Object)TransactionSummary.TransactionSummaryBuilder.start().due(this.getDue()).paid(this.paid).tip(this.tip).surcharge(this.surcharge).build());
    }

    @Override
    protected void checkAutoSurcharge() {
        this.gui.enableAutoSurcharge(this.autoSurchargeEnabled);
    }

    @Override
    protected FinanceTransaction createTransaction(boolean autoSurcharge) {
        FinanceUnit unit = this.gui.getSelectedSubType();
        if (!this.autoSurchargeEnabled) {
            this.paid = this.paid.add(this.surcharge);
        } else {
            this.surcharge = Price.ZERO_DOLLAR;
        }
        FinanceTransaction newTransaction = this.getTransactionFactory().createCreditTransaction(LoginManager.getEventContext(), this.paid, this.tip, unit);
        newTransaction.setSurcharge(this.surcharge);
        if (this.getNote() != null && !this.getNote().isEmpty()) {
            newTransaction.setNote(this.getNote());
        }
        return newTransaction;
    }

    @Override
    public void gotRecommendedPriceSelected(Price p) {
        this.paid = p;
        this.tip = Price.ZERO_DOLLAR;
        this.update();
    }

    @Override
    protected void transactionCompleted(FinanceTransaction transaction) {
        if (transaction.getSystemState().equals("ACTIVE") && this.getPayable() instanceof ItemGroup) {
            CreditTransactionHelper helper = new CreditTransactionHelper();
            ItemGroup itemGroup = (ItemGroup)this.getItemGroup();
            if (helper.shouldCreateUnorderableItem(itemGroup, this.type)) {
                itemGroup.getItemHelper().addItem((SalesLineItem)UnorderableSalesItemFactory.createUnorderableSalesItem((EventContext)LoginManager.getEventContext()));
            } else if (helper.shouldRemoveUnorderableItem(itemGroup)) {
                itemGroup.getItemHelper().removeItem((SalesLineItem)helper.getUnorderableItem(itemGroup), LoginManager.getEventContext());
            }
        }
        super.transactionCompleted(transaction);
    }

    void gotPaid() {
        double newPaid = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"PAID") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")), (boolean)this.isCustomRefundEnabled());
        if (newPaid != Double.MIN_VALUE) {
            this.paid = new Price(newPaid, 0.01);
            this.update();
        }
    }

    void gotTip() {
        double newTip = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"TIP") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")));
        if (newTip != Double.MIN_VALUE) {
            this.tip = new Price(newTip, 0.01);
            this.update();
        }
    }

    void gotType() {
        this.type = this.gui.getSelectedSubType();
        this.update();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    @Override
    public AbstractTransactionNav createNavBar() {
        CreditTransactionNav nav = new CreditTransactionNav();
        return nav;
    }

    @Override
    public List<Sellable> getPayableItemsFromItemGroup(ItemGroup group) {
        return this.sellableFactory.getSellables(group);
    }
}

