/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.debtorTransaction;

import au.com.ordermate.xmlintegration.piggy.SearchType;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import javax.swing.JPanel;
import ordermate.OrderMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.guikit.dialogs.KeyboardDialog;

public class KeyPanel
extends JPanel {
    private static final String ENTER_GUEST_NAME = "Enter Guest Name";
    private static final String ENTER_ROOM_NUMBER = "Enter Room Number";
    private static final String GUESTNAME = "GUESTNAME";
    private static final String ROOMNUMBER = "ROOMNUMBER";
    private static final int MAX_DIGITS = 16;
    private static final String ROOM_NUMBER = "Room Number : ";
    private static final String GUEST_NAME_STARTS_WITH = "Guest Name starts with : ";
    private static final String ENTER_CARD_INPUT = "Guest / Room Card Number :  ";
    private final int TRACK2_LENGTH = 16;
    private final String PARSE_ERROR_MESSAGE = "Could not parse Track 2 Information : ";
    private final String DELIMITERS = ";=";
    private KeyboardDialog guestNameDialog = new KeyboardDialog("Enter Guest Name");
    private KeyboardDialog roomNumberDialog = new KeyboardDialog("Enter Room Number");
    private CardLayout cardLayout = new CardLayout(0, 0);
    private volatile boolean scanStarted = false;

    public KeyPanel() {
        this.setLayout(this.cardLayout);
        JPanel guestNamePanel = new JPanel();
        guestNamePanel.setLayout(new BorderLayout());
        guestNamePanel.add((Component)this.guestNameDialog, "Center");
        JPanel roomNumberPanel = new JPanel();
        roomNumberPanel.setLayout(new BorderLayout());
        roomNumberPanel.add((Component)this.roomNumberDialog, "Center");
        this.roomNumberDialog.setLabel(ROOM_NUMBER);
        this.guestNameDialog.setLabel(GUEST_NAME_STARTS_WITH);
        this.add(GUESTNAME, guestNamePanel);
        this.add(ROOMNUMBER, roomNumberPanel);
        this.showRoomNumberDialog();
    }

    private void disableSwipeCardScan() {
        WaiterMateInputAdapter.getInstance().enableInputParsing(false);
        WaiterMateInputAdapter.getInstance().swipecardInput.disconnect((Object)this);
        this.scanStarted = false;
    }

    public void showGuestNameDialog() {
        this.disableSwipeCardScan();
        this.guestNameDialog.setValue("");
        this.cardLayout.show(this, GUESTNAME);
    }

    public void showRoomNumberDialog() {
        this.disableSwipeCardScan();
        this.roomNumberDialog.setValue("");
        this.cardLayout.show(this, ROOMNUMBER);
    }

    public void showCardSwipeDialog() {
        WaiterMateInputAdapter.getInstance().enableInputParsing(false);
        if (!this.scanStarted) {
            WaiterMateInputAdapter.getInstance().swipecardInput.connect((Object)this, "gotTrack2Data");
            this.scanStarted = true;
        }
        this.roomNumberDialog.setValue("");
        this.cardLayout.show(this, "KEYPAD");
    }

    public void gotTrack2Data(String track2Data) {
        try {
            this.roomNumberDialog.setValue(this.getGuestDetailsFromCard(track2Data));
        }
        catch (DataFormatException e) {
            OrderMate.LOG.error("Could not obtain Track 2 Information", (Throwable)e);
        }
    }

    public String getSearchText(SearchType searchType) {
        String searchString = "";
        switch (searchType) {
            case ROOM_NUMBER: {
                searchString = this.roomNumberDialog.getValue();
                break;
            }
            case GUEST_NAME: {
                searchString = this.guestNameDialog.getValue();
                break;
            }
            case SWIPE_CARD: {
                searchString = this.roomNumberDialog.getValue();
            }
        }
        return searchString;
    }

    private String getGuestDetailsFromCard(String track2Info) throws DataFormatException {
        String track2 = null;
        StringTokenizer tokenizer = new StringTokenizer(track2Info, ";=", false);
        tokenizer.nextToken();
        track2 = tokenizer.nextToken().trim();
        if (track2 == null || track2.length() == 0) {
            throw new DataFormatException("Could not parse Track 2 Information : " + track2Info);
        }
        if (track2.length() > 16) {
            track2 = track2.substring(0, 16);
        }
        if (track2.length() != 16) {
            throw new DataFormatException("Could not parse Track 2 Information : " + track2Info);
        }
        return track2;
    }
}

