/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.debtorTransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.xmlintegration.piggy.SearchType;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudBackProperty;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PiggyGuestSearchButtonPanel
extends JPanel
implements ActionListener {
    private final String GUESTNAME_SEARCHBUTTON = "guestNameSearchButton";
    private final String ROOMNUMBER_SEARCHBUTTON = "roomNumberSearchButton";
    private final String CARDSWIPE_SEARCHBUTTON = "cardSwipeSearchButton";
    private final String CARDSWIPE_SEARCHCAPTION = "Search Using Room Card";
    private final String ROOMNUMBER_SEARCHCAPTION = "Search By Room Number";
    private final String GUESTNAME_SEARCHCAPTION = "Search By Guest Name";
    public Signal cardSwipeSearchSignal;
    public Signal roomNumberSearchSignal;
    public Signal guestNameSearchSignal;
    private JButton cardSwipeSearchButton;
    private JButton roomNumberSearchButton;
    private JButton guestNameSearchButton;
    private SearchType searchType = SearchType.ROOM_NUMBER;
    private boolean showRoomCardSearchButton = false;

    private void setShowRoomCardSearchButton() {
        CloudBackConfig config = CloudBackConfig.getCloudBackConfig((CloudServerType)CloudServerType.PiggyBack);
        if (config == null) {
            return;
        }
        CloudBackProperty integrationTypeProp = null;
        for (CloudBackProperty cloudBackProperty : config.getCloudProperties()) {
            if (!"SearchByRoomCard".equals(cloudBackProperty.getKey())) continue;
            integrationTypeProp = cloudBackProperty;
        }
        if (integrationTypeProp != null) {
            try {
                this.showRoomCardSearchButton = Boolean.parseBoolean(integrationTypeProp.getValue());
            }
            catch (Exception ex) {
                this.showRoomCardSearchButton = false;
            }
        }
    }

    public PiggyGuestSearchButtonPanel() {
        this.setShowRoomCardSearchButton();
        this.setLayout((LayoutManager)new GraphPaperLayout(1, 7));
        ImageIcon cardIcon = IconLoader.get((String)"/waitermate/images/guestCardIcon.png");
        ImageIcon roomIcon = IconLoader.get((String)"/waitermate/images/roomsIcon.png");
        ImageIcon guestIcon = IconLoader.get((String)"/waitermate/images/guestsIcon.png");
        this.cardSwipeSearchSignal = Signals.createSignal();
        this.roomNumberSearchSignal = Signals.createSignal();
        this.guestNameSearchSignal = Signals.createSignal();
        this.cardSwipeSearchButton = this.constructButton(cardIcon, "Search Using Room Card");
        this.cardSwipeSearchButton.setName("cardSwipeSearchButton");
        this.roomNumberSearchButton = this.constructButton(roomIcon, "Search By Room Number");
        this.roomNumberSearchButton.setName("roomNumberSearchButton");
        this.guestNameSearchButton = this.constructButton(guestIcon, "Search By Guest Name");
        this.guestNameSearchButton.setName("guestNameSearchButton");
        this.cardSwipeSearchButton.setBorderPainted(true);
        this.roomNumberSearchButton.setBorderPainted(true);
        this.guestNameSearchButton.setBorderPainted(true);
        this.cardSwipeSearchButton.addActionListener(this);
        this.roomNumberSearchButton.addActionListener(this);
        this.guestNameSearchButton.addActionListener(this);
        this.add((Component)this.roomNumberSearchButton, new Rectangle(0, 0, 1, 1));
        this.add((Component)this.guestNameSearchButton, new Rectangle(0, 1, 1, 1));
        if (this.showRoomCardSearchButton) {
            this.add((Component)this.cardSwipeSearchButton, new Rectangle(0, 2, 1, 1));
        }
    }

    private JButton constructButton(Icon icon, String buttonText) {
        JButton button = new JButton(buttonText, icon);
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        if (button.equals(this.roomNumberSearchButton)) {
            this.roomNumberSearchSignal.emit();
            this.searchType = SearchType.ROOM_NUMBER;
        } else if (button.equals(this.guestNameSearchButton)) {
            this.guestNameSearchSignal.emit();
            this.searchType = SearchType.GUEST_NAME;
        } else if (button.equals(this.cardSwipeSearchButton) && this.showRoomCardSearchButton) {
            this.cardSwipeSearchSignal.emit();
            this.searchType = SearchType.SWIPE_CARD;
        }
    }

    public SearchType getSearchType() {
        return this.searchType;
    }
}

