/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.eftpos;

import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.users.AllPermissions;
import ordermate.internationalization.Internationalization;
import ordermate.services.finance.transactions.FinanceTransactionFactory;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.AbstractTransactionScreen;
import waitermate.gui.screens.payment.eftpos.EftposController;
import waitermate.gui.screens.payment.eftpos.EftposTransactionNav;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;

public abstract class EftposTransactionScreen
extends AbstractTransactionScreen {
    private EftposController controller;
    private final FinanceTransactionFactory transactionFactory = new FinanceTransactionFactory();
    private String note;
    protected final EventContext context;

    public EftposTransactionScreen() {
        this.controller = new EftposController();
        this.controller.txnAdded.connect((Object)this, "gotEftposAdded");
        this.controller.txnRemoved.connect((Object)this, "gotEftposRemoved");
        this.controller.eftposFinished.connect((Object)this, "gotEftposFinished");
        this.context = LoginManager.getEventContext();
        this.setupNav();
        ((EftposTransactionNav)this.getNavBar()).noteUpdated.connect((Object)this, "gotNote");
        ((EftposTransactionNav)this.getNavBar()).doOfflineEftpos.connect((Object)this, "gotDoOfflineEftpos");
    }

    public void gotDoOfflineEftpos() {
        if (this.mayCreateTransaction()) {
            EftposTransaction txn = (EftposTransaction)this.createTransaction(this.autoSurchargeEnabled);
            this.controller.performOfflineTransaction(txn, false, this.getPayable());
        }
    }

    public boolean isCustomRefundEnabled() {
        return ExperimentalFeatureHelper.isWMCustomRefundEnabled() && LoginManager.getInstance().getUser() != null && LoginManager.getInstance().getUser().hasPermission(AllPermissions.WAITERMATE_CUSTOM_REFUND);
    }

    @Override
    protected boolean determineAutoSurcharge() {
        return this.getVirtualEftpos() == null ? false : this.getVirtualEftpos().isAutoSurcharge();
    }

    @Override
    protected void postCreateTransaction(FinanceTransaction transaction) {
        if (FinanceUnit.getAllEftposUnits().contains(transaction.getSubType())) {
            this.controller.performTransaction((EftposTransaction)transaction, false, this.getPayable());
        } else {
            super.postCreateTransaction(transaction);
        }
    }

    public void gotEftposRemoved(EftposTransaction txn) {
    }

    public void gotEftposAdded(EftposTransaction txn) {
        this.transactionCompleted((FinanceTransaction)txn);
        ScreenResource.refreshScreen();
    }

    public void gotEftposFinished(EftposTransaction txn) {
        this.done.emit((Object)txn);
    }

    public void gotNote() {
        this.note = Dialogs.getString((String)Internationalization.getLiteralFor((String)"NOTE"), (String)"", (boolean)true, (String)(Internationalization.getLiteralFor((String)"TYPE_NOTE") + ":"));
    }

    protected FinanceTransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public String getNote() {
        return this.note;
    }

    public void display(boolean fullScreen) {
        super.display(fullScreen);
        this.checkAutoSurcharge();
        this.note = null;
    }

    protected abstract void checkAutoSurcharge();

    public EftposController getController() {
        return this.controller;
    }
}

