/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.loyaltytransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.button.CustomButton;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import waitermate.gui.screens.payment.loyaltytransaction.RedeemingItem;

public class RedeemingItemPanel
extends JPanel
implements ActionListener {
    private Signal action;
    private RedeemingItem item;
    private JLabel itemLabel;
    private JLabel customerLabel;
    private CustomButton actionButton;
    private JLabel priceLabel;

    public RedeemingItemPanel(Signal yourAction, boolean isAdd) {
        this.action = yourAction;
        this.setLayout((LayoutManager)new GraphPaperLayout(20, 1));
        this.itemLabel = new JLabel();
        this.itemLabel.setName("itemLabel");
        this.itemLabel.setFont(OrderMateTheme.getMediumFont());
        this.customerLabel = new JLabel();
        this.customerLabel.setName("customerLabel");
        this.customerLabel.setForeground(Color.GRAY);
        this.customerLabel.setFont(OrderMateTheme.getMediumFont());
        this.priceLabel = new JLabel();
        this.priceLabel.setName("priceLabel");
        this.priceLabel.setFont(OrderMateTheme.getMediumFont());
        this.actionButton = new CustomButton();
        this.actionButton.addActionListener((ActionListener)this);
        if (isAdd) {
            this.actionButton.setName("addLoyalty");
            this.actionButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/rightarrow.png"));
        } else {
            this.actionButton.setName("deleteLoyalty");
            this.actionButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/delete.png"));
        }
        this.add((Component)this.itemLabel, new Rectangle(0, 0, 10, 1));
        this.add((Component)this.customerLabel, new Rectangle(11, 0, 4, 1));
        this.add((Component)this.priceLabel, new Rectangle(15, 0, 2, 1));
        this.add((Component)this.actionButton, new Rectangle(17, 0, 3, 1));
    }

    public void setItem(RedeemingItem newItem) {
        this.item = newItem;
        SalesLineItem lineItem = this.item.getItem();
        this.itemLabel.setText("(" + this.item.getQuantity() + ") " + lineItem.getLabel());
        this.itemLabel.setForeground(this.item.isAlreadyRedeemed() ? Color.gray : null);
        this.customerLabel.setText(this.item.getCustomer() != null ? this.item.getCustomer().getNameAndTitle() : " ");
        this.priceLabel.setText(Integer.toString(this.item.getCost()));
        this.priceLabel.setForeground(this.item.isAlreadyRedeemed() ? Color.gray : null);
        this.actionButton.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.actionButton) {
            this.action.emit((Object)this.item);
        }
    }

    public void refreshValues() {
        this.itemLabel.setText(String.valueOf(this.item.getItem().getLabel()));
        this.priceLabel.setText("" + this.item.getCost());
    }

    RedeemingItem getRedeemingItem() {
        return this.item;
    }
}

