/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.paths;

import au.com.ordermate.util.Price;
import ordermate.database.Payable;
import ordermate.database.finance.AccountPercentagePayable;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.payment.paths.Path;
import waitermate.gui.screens.payment.paths.PercentageSplitSelector;
import waitermate.gui.screens.payment.transactions.PercentagePaymentScreen;
import waitermate.guikit.dialogs.Dialogs;

public class PercentageSplitPath
extends Path {
    private PercentageSplitSelector splitSelector;
    private PercentagePaymentScreen transactions = new PercentagePaymentScreen();
    private ItemGroup account;
    private double accountTotalSnapShot;
    private boolean mustBePaid;
    double[] percents;
    int it;

    public PercentageSplitPath() {
        this.transactions.doneSignal.connect((Object)this, "nextPayment");
        this.transactions.back.connect((Object)this.back, "emit");
        this.splitSelector = new PercentageSplitSelector();
    }

    @Override
    public void start(Account toPay, boolean restrictSaveToPaid) {
        this.start((ItemGroup)toPay, restrictSaveToPaid);
    }

    public void start(ItemGroup toPay, boolean restrictSaveToPaid) {
        this.account = toPay;
        this.accountTotalSnapShot = toPay.getDue().doubleValue();
        this.mustBePaid = restrictSaveToPaid;
        int numWaysToSplit = toPay.getNumPatrons();
        if (numWaysToSplit < 2) {
            numWaysToSplit = 2;
        }
        this.splitSelector.setup(numWaysToSplit);
        if (this.splitSelector.start()) {
            this.percents = this.splitSelector.getPercentages();
            if (this.percents.length > 1) {
                this.it = 0;
                this.nextPayment();
            }
        }
    }

    public void nextPayment() {
        if (this.it < this.percents.length) {
            boolean lastPayment = this.it == this.percents.length - 1;
            Price percentagePrice = new Price(this.accountTotalSnapShot * this.percents[this.it], 0.01);
            AccountPercentagePayable payable = new AccountPercentagePayable(this.account, this.percents[this.it], percentagePrice, this.it + 1, lastPayment);
            Dialogs.displayOkDialog((String)payable.getLabel(), (String)Internationalization.getLiteralFor((String)"NEXT_CUSTOMER"));
            this.transactions.startTransactions((Payable)payable, this.mustBePaid);
            ++this.it;
        } else {
            this.done.emit();
        }
    }
}

