/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.paths;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.MathsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class PercentageSplitSelector
extends PopupWindow
implements ActionListener {
    private JTabbedPane pane;
    private JPanel simpleMode = new JPanel(new FlowLayout(1, 10, 50));
    private JButton splitWaysButton;
    private int splitWays;
    private double defaultPercentage;
    private DefaultScrollPaneModel scrollModel;

    public PercentageSplitSelector() {
        JLabel text1 = new JLabel(Internationalization.getLiteralFor((String)"SPLIT_BILL"));
        text1.setFont(OrderMateTheme.getMediumFont());
        JLabel text2 = new JLabel(Internationalization.getLiteralFor((String)"_WAYS"));
        text2.setFont(OrderMateTheme.getMediumFont());
        this.splitWaysButton = new JButton();
        this.splitWaysButton.setFont(OrderMateTheme.getMediumFont());
        this.splitWaysButton.addActionListener(this);
        this.simpleMode.add(text1);
        this.simpleMode.add(this.splitWaysButton);
        this.simpleMode.add(text2);
        this.scrollModel = new DefaultScrollPaneModel(1, 4);
        CustomScrollPane scrollPanel = new CustomScrollPane((CustomScrollPaneModel)this.scrollModel);
        this.pane = new JTabbedPane();
        this.pane.setFont(OrderMateTheme.getMediumFont());
        OrderMateTheme.setupTabbedPane((JTabbedPane)this.pane);
        this.pane.setPreferredSize(new Dimension(300, 300));
        this.pane.add(Internationalization.getLiteralFor((String)"EQUAL_SPLIT"), this.simpleMode);
        this.pane.add(Internationalization.getLiteralFor((String)"ADVANCED_SPLIT"), (Component)scrollPanel);
        this.setComponent(this.pane);
    }

    public void setup(int numSplitWays) {
        this.splitWays = numSplitWays;
        this.defaultPercentage = 100.0 / (double)this.splitWays;
        this.splitWaysButton.setText(this.splitWays + "");
        ArrayList<SplitButton> comps = new ArrayList<SplitButton>(this.splitWays);
        for (int i = 1; i <= this.splitWays; ++i) {
            comps.add(new SplitButton(i));
        }
        this.pane.setSelectedIndex(0);
        this.scrollModel.setItems(comps);
        this.validatePercentages();
    }

    public double[] getPercentages() {
        if (this.splitWays <= 1) {
            return new double[0];
        }
        for (SplitButton button : this.scrollModel.getComponents()) {
            if (button.getPercentage() != 100.0) continue;
            return new double[0];
        }
        if (this.pane.getSelectedIndex() == 0) {
            double[] nums = new double[this.splitWays];
            for (int i = 0; i < this.splitWays; ++i) {
                nums[i] = this.defaultPercentage / 100.0;
            }
            return nums;
        }
        ArrayList<Double> percentages = new ArrayList<Double>();
        for (SplitButton button : this.scrollModel.getComponents()) {
            if (!(button.getPercentage() > 0.0)) continue;
            percentages.add(new Double(button.getPercentage()));
        }
        double[] nums = new double[percentages.size()];
        for (int i = 0; i < percentages.size(); ++i) {
            Double percent = (Double)percentages.get(i);
            nums[i] = percent / 100.0;
        }
        return nums;
    }

    private void validatePercentages() {
        double total = 0.0;
        for (SplitButton button : this.scrollModel.getComponents()) {
            total += button.getPercentage();
        }
        if (!MathsUtils.approxEquals((double)total, (double)100.0)) {
            double difference = total - 100.0;
            for (int i = this.scrollModel.getComponents().size() - 1; i >= 0 && difference != 0.0; --i) {
                SplitButton button = (SplitButton)this.scrollModel.getComponents().get(i);
                if (button.getPercentage() >= difference) {
                    button.setPercentage(button.getPercentage() - difference);
                    difference = 0.0;
                    continue;
                }
                difference -= button.getPercentage();
                button.setPercentage(0.0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.splitWaysButton) {
            this.setup(Dialogs.getInteger((String)"", (int)this.splitWays, (boolean)false, (String)Internationalization.getLiteralFor((String)"SELECT_NUMBER_OF_WAYS_TO_SPLIT")));
        } else if (((Component)e.getSource()).getParent() instanceof SplitButton) {
            SplitButton source = (SplitButton)((Component)e.getSource()).getParent();
            double percent = Dialogs.getDouble((String)"%", (double)source.getRoundedPercentage());
            if (percent > 100.0) {
                percent = 100.0;
            }
            source.setPercentage(percent);
            this.validatePercentages();
        }
    }

    private class SplitButton
    extends JPanel {
        private JButton percentButton;
        private double percentage;

        public SplitButton(int patronNum) {
            super((LayoutManager)new GraphPaperLayout(5, 1));
            JLabel label = new JLabel(Internationalization.getLiteralFor((String)"CUSTOMER") + " " + patronNum);
            this.percentButton = new JButton();
            this.percentButton.addActionListener(PercentageSplitSelector.this);
            this.setPercentage(PercentageSplitSelector.this.defaultPercentage);
            if (patronNum == PercentageSplitSelector.this.splitWays) {
                this.percentButton.setEnabled(false);
            }
            this.add((Component)label, new Rectangle(0, 0, 3, 1));
            this.add((Component)this.percentButton, new Rectangle(3, 0, 2, 1));
        }

        public void setPercentage(double percent) {
            this.percentage = percent;
            this.percentButton.setText(this.getRoundedPercentage() + "%");
        }

        public double getPercentage() {
            return this.percentage;
        }

        public double getRoundedPercentage() {
            return MathsUtils.roundDouble((double)this.percentage, (double)0.01);
        }
    }
}

