/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.paypaltransaction;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.AbstractComponentDecorator;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class WebTransactionPanel
extends JPanel
implements ActionListener {
    private static int LABEL_START = 0;
    private static int LABEL_WIDTH = 7;
    private static int LABEL_HEIGHT = 1;
    private static int COMPONENT_START = LABEL_WIDTH;
    private static int COMPONENT_WIDTH = 3;
    private static int COMPONENT_HEIGHT = 1;
    private JLabel due;
    private JLabel subTotal;
    private JLabel balance;
    private JButton paid;
    private JButton tip;
    public final Signal paidSelected = Signals.createSignal();
    public final Signal tipSelected = Signals.createSignal();
    private final AbstractComponentDecorator tipSecurityDecorator;

    public WebTransactionPanel() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        JPanel textPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 5), 0, 0));
        this.add((Component)textPanel, new Rectangle(0, 0, 20, 20));
        textPanel.add((Component)new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"DUE") + "</h2></html>"), new Rectangle(LABEL_START, 0, LABEL_WIDTH, LABEL_HEIGHT));
        this.due = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        textPanel.add((Component)this.due, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, COMPONENT_HEIGHT));
        JPanel group1 = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 3), 5, 5));
        group1.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SUBTOTAL")));
        textPanel.add((Component)group1, new Rectangle(0, 1, 10, 3));
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"PAID")), new Rectangle(LABEL_START, 0, LABEL_WIDTH, LABEL_HEIGHT));
        this.paid = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.paid.addActionListener(this);
        group1.add((Component)this.paid, new Rectangle(COMPONENT_START, 0, COMPONENT_WIDTH, COMPONENT_HEIGHT));
        this.paid.setName("paid");
        group1.add((Component)new JLabel(Internationalization.getLiteralFor((String)"TIP")), new Rectangle(LABEL_START, 1, LABEL_WIDTH, LABEL_HEIGHT));
        this.tip = new JButton(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        this.tip.addActionListener(this);
        this.tipSecurityDecorator = new StandardSecurityDecorator((JComponent)this.tip, AllPermissions.TIPS);
        group1.add((Component)this.tipSecurityDecorator, new Rectangle(COMPONENT_START, 1, COMPONENT_WIDTH, COMPONENT_HEIGHT));
        group1.add((Component)new JLabel("       " + Internationalization.getLiteralFor((String)"SUB_TOTAL")), new Rectangle(LABEL_START, 2, LABEL_WIDTH, LABEL_HEIGHT));
        this.subTotal = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        group1.add((Component)this.subTotal, new Rectangle(COMPONENT_START, 2, COMPONENT_WIDTH, COMPONENT_HEIGHT));
        textPanel.add((Component)new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"BALANCE") + "</h2></html>"), new Rectangle(LABEL_START, 4, LABEL_WIDTH, LABEL_HEIGHT));
        this.balance = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_ZERO_DOT_ZERO"));
        textPanel.add((Component)this.balance, new Rectangle(COMPONENT_START, 4, COMPONENT_WIDTH, COMPONENT_HEIGHT));
    }

    public void setDetails(Price dueAmount, Price paidAmount, Price tipAmount) {
        this.due.setText("<html><h2>" + dueAmount + "</h2></html>");
        this.paid.setText(paidAmount.toString());
        this.tip.setText(tipAmount.toString());
        this.subTotal.setText(new Price(tipAmount.doubleValue() + paidAmount.doubleValue(), 0.01).toString());
        Price balancePrice = new Price(dueAmount.doubleValue() - paidAmount.doubleValue(), 0.01);
        if (balancePrice.doubleValue() >= 0.0) {
            this.balance.setText("<html><h2>" + balancePrice + "</h2></html>");
        } else {
            this.balance.setText("<html><h2><font color=\"red\">" + balancePrice + "</font></h2></html>");
        }
    }

    public void setPaidEnabled(boolean enabled) {
        this.paid.setEnabled(enabled);
    }

    public void setTipEnabled(boolean enabled) {
        this.tipSecurityDecorator.setEnabled(enabled);
    }

    public FinanceUnit getSelectedSubType() {
        return FinanceUnit.getUnitForName((String)"PayPal");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.paid) {
            this.paidSelected.emit();
        } else if (e.getSource() == this.tip) {
            this.tipSelected.emit();
        }
    }
}

