/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.selectadjustment;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentI;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.InventoryPriceAdjustmentI;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationHelper;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.payment.selectadjustment.InventoryNavBar;
import waitermate.gui.screens.payment.selectadjustment.SelectPriceAdjustmentPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class SelectPriceAdjustment
extends AbstractScreen {
    public final Signal addAdjustment = Signals.createSignal(InventoryPriceAdjustment.class, (String)"selected");
    public final Signal removeAdjustment = Signals.createSignal(SalesPriceAdjustmentI.class, (String)"selected");
    public final Signal back = Signals.createSignal();
    private boolean showDollarAdjustments;
    private PriceAdjustmentDirection direction;
    private PriceAdjustmentType type;
    private PriceAdjustmentLevel level;
    private Collection existingAdjustments;
    private Collection allAdjustments;
    private final SelectPriceAdjustmentPanel gui = new SelectPriceAdjustmentPanel();
    private final InventoryNavBar inventoryNav;

    public SelectPriceAdjustment(boolean showCustomButton) {
        this.inventoryNav = new InventoryNavBar(showCustomButton);
        this.gui.selected.connect((Object)this, "gotSelectAdjustment");
        this.gui.removed.connect((Object)this, "gotRemoveAdjustment");
        this.inventoryNav.customSelected.connect((Object)this, "selectCustom");
        this.inventoryNav.back.connect((Object)this, "back");
        this.showDollarAdjustments = true;
    }

    public void start(Collection existingAdj, Collection allAdj, PriceAdjustmentDirection theDirection, PriceAdjustmentType adjType, PriceAdjustmentLevel theLevel, TriggerActivationContext context) {
        if (existingAdj == null) {
            throw new IllegalArgumentException("Existing adjustment is null.");
        }
        if (theDirection == null) {
            throw new IllegalArgumentException("Price adjustement direction is null.");
        }
        if (adjType == null) {
            throw new IllegalArgumentException("Price adjustment type is null.");
        }
        if (theLevel == null) {
            throw new IllegalArgumentException("Price adjustment level is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Trigger activation context is null.");
        }
        this.existingAdjustments = existingAdj;
        this.allAdjustments = allAdj == null ? existingAdj : allAdj;
        this.direction = theDirection;
        this.type = adjType;
        this.level = theLevel;
        this.displayInventoryScreen(context);
    }

    public void allowDollarValue(boolean allow) {
        this.showDollarAdjustments = allow;
    }

    public void gotSelectAdjustment(PriceAdjustmentI adjustment) {
        this.addAdjustment.emit((Object)adjustment);
    }

    public void gotRemoveAdjustment(SalesPriceAdjustmentI adjustment) {
        this.removeAdjustment.emit((Object)adjustment);
    }

    public void selectCustom() {
        double amount = Double.MIN_VALUE;
        PriceAdjustmentUnit unit = null;
        if (this.gui.isDollarDisplayed()) {
            amount = Dialogs.getPriceDouble((String)(this.getFormattedType() + " " + Internationalization.getLiteralFor((String)"_AMOUNT")));
            unit = PriceAdjustmentUnit.DOLLAR_UNIT;
        } else if (this.gui.isPercentageDisplayed()) {
            amount = Dialogs.getDouble((String)(this.getFormattedType() + " " + Internationalization.getLiteralFor((String)"_AMOUNT") + " %"));
            unit = PriceAdjustmentUnit.PERCENTAGE_UNIT;
        }
        if (amount == Double.MIN_VALUE) {
            return;
        }
        if (this.direction.equals((Object)PriceAdjustmentDirection.DISCOUNT)) {
            this.addAdjustment.emit((Object)PriceAdjustmentFactory.getInstance().createCustomDiscount(amount, unit));
        } else if (this.direction.equals((Object)PriceAdjustmentDirection.SURCHARGE)) {
            this.addAdjustment.emit((Object)PriceAdjustmentFactory.getInstance().createCustomSurcharge(amount, unit));
        }
    }

    public void back() {
        this.back.emit();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.inventoryNav;
    }

    private String getFormattedType() {
        return this.direction.getLabel();
    }

    private void displayInventoryScreen(TriggerActivationContext context) {
        PriceAdjustmentManager mgr = PriceAdjustmentManager.getInstance();
        Collection triggerActivatedAdjustments = mgr.getMatching((Collection)mgr.getMatching((Collection)mgr.getDisplayablePriceAdjustments(), this.type, this.level), this.direction);
        this.filterAppliedAdjustments(triggerActivatedAdjustments);
        triggerActivatedAdjustments = TriggerActivationHelper.getActive((Collection)triggerActivatedAdjustments, (TriggerActivationContext)context);
        this.inventoryNav.setText(Internationalization.getLiteralFor((String)"SELECT") + " " + this.getFormattedType());
        this.gui.displayAdjustmentsOnTabs(triggerActivatedAdjustments, this.showDollarAdjustments, this.existingAdjustments);
        this.display();
    }

    private void filterAppliedAdjustments(Collection<? extends InventoryPriceAdjustmentI> toDisplay) {
        ArrayList<InventoryPriceAdjustmentI> toRemove = new ArrayList<InventoryPriceAdjustmentI>();
        for (Object obj : this.allAdjustments) {
            InventoryPriceAdjustmentI adj;
            if (obj instanceof InventoryPriceAdjustmentI) {
                adj = (InventoryPriceAdjustmentI)obj;
            } else if (obj instanceof SalesPriceAdjustmentI) {
                adj = ((SalesPriceAdjustmentI)obj).getInventoryPriceAdjustment();
            } else {
                throw new IllegalStateException("Got object " + obj + " of incorrect type " + obj.getClass());
            }
            if (!toDisplay.contains(adj)) continue;
            toRemove.add(adj);
        }
        toDisplay.removeAll(toRemove);
    }
}

