/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.singlecardtransaction;

import au.com.ordermate.util.Price;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.Payable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.TransactionSummary;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.Sellable;
import ordermate.internationalization.Internationalization;
import ordermate.services.finance.transactions.FinanceTransactionFactory;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.AbstractTransactionNav;
import waitermate.gui.screens.payment.eftpos.EftposTransactionScreen;
import waitermate.gui.screens.payment.singlecardtransaction.SingleCardTransactionNav;
import waitermate.gui.screens.payment.singlecardtransaction.SingleCardTransactionPanel;
import waitermate.guikit.dialogs.Dialogs;

public class SingleCardTransactionScreen
extends EftposTransactionScreen {
    private final DecimalFormat format = new DecimalFormat("0.0#%");
    private FinanceTransactionFactory transactionFactory = new FinanceTransactionFactory();
    private Price paid;
    private Price tip;
    private Price cashOut;
    private Price surcharge;
    private FinanceUnit type;
    Signal<TransactionSummary, ?, ?, ?, ?> valuesChanged = Signals.createSignal(TransactionSummary.class, (String)"summary");
    private SingleCardTransactionPanel gui;

    public SingleCardTransactionScreen(boolean cashoutOnly) {
        this.gui = new SingleCardTransactionPanel(cashoutOnly);
        this.gui.paidSelected.connect((Object)this, "gotPaid");
        this.gui.tipSelected.connect((Object)this, "gotTip");
        this.gui.cashSelected.connect((Object)this, "gotCash");
        this.valuesChanged.connect((Object)this.gui, "setDetails");
        this.valuesChanged.connect((Object)this.getNavBar(), "setDetails");
    }

    public SingleCardTransactionScreen() {
        this(false);
    }

    @Override
    public void startAddingTransaction(Price due, Payable payGroup) {
        super.startAddingTransaction(due, payGroup);
        this.paid = new Price(due.doubleValue(), 0.01);
        this.cashOut = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
        this.tip = new Price(0.0, 0.01);
        this.gui.setPaidEnabled(payGroup.isPaidModifiable());
        this.gui.setSurchargeSelected(true);
        this.update();
        this.display();
    }

    @Override
    protected FinanceTransaction createTransaction(boolean autoSurcharge) {
        FinanceUnit unit = this.type;
        if (!this.autoSurchargeEnabled) {
            this.paid = this.paid.add(this.surcharge);
        } else {
            this.surcharge = Price.ZERO_DOLLAR;
        }
        FinanceTransaction newTransaction = this.transactionFactory.createDebitTransaction(LoginManager.getEventContext(), this.paid, this.tip, this.cashOut, unit);
        newTransaction.setSurcharge(this.surcharge);
        if (this.getNote() != null && !this.getNote().isEmpty()) {
            newTransaction.setNote(this.getNote());
        }
        return newTransaction;
    }

    @Override
    public void gotRecommendedPriceSelected(Price p) {
        this.paid = p;
        this.tip = Price.ZERO_DOLLAR;
        this.cashOut = Price.ZERO_DOLLAR;
        this.update();
    }

    private void update() {
        this.type = (FinanceUnit)FinanceUnit.getActiveDebitUnits().get(0);
        if (this.gui != null) {
            this.surcharge = this.gui.isSurchargeSelected() && !this.autoSurchargeEnabled ? FinanceSurchargeCalculator.calculateSurcharge((Price)this.paid, (Price)this.tip, (FinanceUnit)this.type) : Price.ZERO_DOLLAR;
            this.gui.setSurchargeLabel("Payment Surcharge (" + this.format.format(this.type.getSurcharge()) + ")");
        } else {
            this.surcharge = Price.ZERO_DOLLAR;
        }
        TransactionSummary summary = TransactionSummary.TransactionSummaryBuilder.start().paid(this.paid).tip(this.tip).cashout(this.cashOut).surcharge(this.surcharge).due(this.getDue()).build();
        this.valuesChanged.emit((Object)summary);
    }

    void gotPaid() {
        double newPaid = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"PAID") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")));
        if (newPaid != Double.MIN_VALUE) {
            this.paid = new Price(newPaid, 0.01);
            this.update();
        }
    }

    void gotTip() {
        double newTip = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"TIP") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")));
        if (newTip != Double.MIN_VALUE) {
            this.tip = new Price(newTip, 0.01);
            this.update();
        }
    }

    void gotCash() {
        double newCashOut = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"CASH_OUT") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")));
        if (newCashOut != Double.MIN_VALUE) {
            this.cashOut = new Price(newCashOut, Price.DEFAULT_ROUND_AMOUNT);
            this.update();
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    @Override
    public AbstractTransactionNav createNavBar() {
        return new SingleCardTransactionNav();
    }

    @Override
    public List<Sellable> getPayableItemsFromItemGroup(ItemGroup group) {
        return this.sellableFactory.getSellables(group);
    }

    @Override
    protected void checkAutoSurcharge() {
        this.gui.enableAutoSurcharge(this.autoSurchargeEnabled);
    }
}

