/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.tabtransaction;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.database.Lockable;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.users.User;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.displayitems.BarTabRenderer;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class TabTransactionScreen
extends AbstractScreen {
    public final Signal cancel = Signals.createSignal();
    public final Signal<BarTabAccount, ?, ?, ?, ?> tabSelectedSignal = Signals.createSignal(BarTabAccount.class, (String)"tab");
    private final NavBar nav;
    private final CustomScrollPane accountsPane;
    private final RendererScrollPaneModel accounts;
    private AccountSearcher searcher;

    public TabTransactionScreen() {
        this.searcher = new AccountSearcher(1000, BarTabAccount.Properties.TAB_NAME);
        this.searcher.setAccountTypes(Collections.singletonList(AccountType.barTabType));
        this.searcher.setAccountOpen(true);
        BarTabRenderer renderer = new BarTabRenderer();
        this.accounts = new RendererScrollPaneModel((Renderer)renderer, 3, 6);
        this.accountsPane = new CustomScrollPane((CustomScrollPaneModel)this.accounts);
        this.accountsPane.setEmptyMessage("There are no bar tabs for the current trading day.");
        renderer.selected.connect((Object)this, "gotAccount");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.back.connect(this.cancel);
        JButton create = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/addCard.png"), "New Bar Tab", "New Bar Tab");
        create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabTransactionScreen.this.createNewAccount();
            }
        });
        this.nav.addRight((Component)create);
    }

    protected void createNewAccount() {
        String name = Dialogs.getString((String)"Bar Tab Name");
        if (name != "\u0000") {
            User user = LoginManager.getInstance().getUser();
            Terminal localhost = Terminal.getLocalHost();
            BarTabAccount newAccount = new BarTabAccount(user, localhost, name);
            if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)newAccount)) {
                this.tabSelectedSignal.emit((Object)newAccount);
            }
        }
    }

    public JComponent getMainArea() {
        return this.accountsPane;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public synchronized void gotAccount(Displayable selected) {
        if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)((BarTabAccount)selected))) {
            this.tabSelectedSignal.emit((Object)((BarTabAccount)selected));
        }
    }

    public void start() {
        this.searcher.setTradingDay(TradingDay.getCurrentTradingDay());
        this.accounts.setObjects(this.searcher.search());
        try {
            WaiterMateInputAdapter.getInstance().customerCardInput.connect((Object)this, "gotCustomerCard");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.display();
    }

    public void gotCustomerCard(CustomerCard card) {
        if (this.isDisplaying()) {
            CustomerCardHelper helper = new CustomerCardHelper((GuiHandler)new WaitermateGuiHandler());
            final BarTabAccount account = helper.createOrGetBarTab(card, LoginManager.getEventContext());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabTransactionScreen.this.gotAccount((Displayable)account);
                }
            });
        }
    }
}

