/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.debtors.DebtorTransactionManager;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.AccountPercentagePayable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.SplitItemGroup;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.VoucherTopupReversalHelper;
import ordermate.database.finance.transactions.VoucherTransaction;
import ordermate.database.finance.transactions.VoucherTransactionHelper;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.PoleDisplay;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.videopro.CCTVIntegration;
import ordermate.integration.voucher.VoucherAdministratorRMI;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.admin.closedaccounts.ClosedAccountRefundHelper;
import waitermate.gui.screens.ordering.accountitems.WaitermatePreauth;
import waitermate.gui.screens.ordering.transferitems.selectitems.SplitSelectItems;
import waitermate.gui.screens.payment.cashtransaction.CashTransactionScreen;
import waitermate.gui.screens.payment.credittransaction.CreditTransactionScreen;
import waitermate.gui.screens.payment.debittransaction.DebitTransactionScreen;
import waitermate.gui.screens.payment.eftpos.EftposController;
import waitermate.gui.screens.payment.mototransaction.MOTOTransactionScreen;
import waitermate.gui.screens.payment.selectadjustment.SelectPriceAdjustment;
import waitermate.gui.screens.payment.singlecardtransaction.SingleCardTransactionScreen;
import waitermate.gui.screens.payment.transactions.PaymentsNav;
import waitermate.gui.screens.payment.transactions.PaymentsPanel;
import waitermate.gui.screens.payment.voucher.VoucherPayment;
import waitermate.gui.screens.payment.webtransaction.WebTransactionScreen;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public abstract class AbstractPaymentsScreen
extends AbstractScreen {
    private Payable payableObject;
    private PaymentsPanel gui;
    private PaymentsNav navPanel;
    private CashTransactionScreen cashScreen = new CashTransactionScreen();
    private CreditTransactionScreen creditScreen = new CreditTransactionScreen();
    private DebitTransactionScreen debitScreen = new DebitTransactionScreen();
    private SingleCardTransactionScreen singleCardScreen = new SingleCardTransactionScreen();
    private MOTOTransactionScreen motoScreen = new MOTOTransactionScreen();
    private VoucherPayment voucherScreen = new VoucherPayment();
    private WebTransactionScreen webScreen = new WebTransactionScreen();
    private SelectPriceAdjustment adjustmentScreen;
    private Set<FinanceTransaction> newTransactions;
    private EftposController controller;
    public final Signal back = Signals.createSignal();
    public final Signal displaySignal = Signals.createSignal();
    private final SplitSelectItems selectItemsToRefund = new SplitSelectItems(false, true);
    public final Signal<ItemGroup, ?, ?, ?, ?> voucherReversalDone = Signals.createSignal(ItemGroup.class, (String)"account");
    private boolean onlySaveOnPaid = false;
    public static final String CONTINUE_WITH_PAYMENT_PROMPT = "Make a New Payment";
    public static final String VOID_ITEMS_PROMPT = "Void Items";
    public static final String DISCOUNT_ITEMS_PROMPT = "Apply Account Discount";

    protected abstract void doDone();

    protected abstract void doPrint();

    protected abstract void doShowDetails();

    protected abstract void doDelete(FinanceTransaction var1);

    protected abstract void setNavBarText();

    protected abstract void update();

    protected abstract void updateNavBar();

    protected AbstractPaymentsScreen(PaymentsPanel theGui, PaymentsNav theNav) {
        this.gui = theGui;
        this.navPanel = theNav;
        this.navPanel.back.connect((Object)this, "gotBack");
        this.navPanel.save.connect((Object)this, "gotDone");
        this.navPanel.print.connect((Object)this, "gotPrint");
        this.navPanel.showItems.connect((Object)this, "gotShowDetails");
        this.navPanel.balanceAccount.connect((Object)this, "gotBalanceAccount");
        this.gui.deleteTransaction.connect((Object)this, "gotDelete");
        this.gui.adjustTip.connect((Object)this, "gotAdjustTip");
        this.gui.preauthTransaction.connect((Object)this, "gotPreauth");
        this.gui.newCashTransaction.connect((Object)this, "gotCash");
        this.cashScreen.cancel.connect((Object)this, "display");
        this.cashScreen.done.connect((Object)this, "resumeTransactions");
        this.gui.newCreditTransaction.connect((Object)this, "gotCredit");
        this.creditScreen.cancel.connect((Object)this, "display");
        this.creditScreen.done.connect((Object)this, "resumeTransactions");
        this.gui.newDebitTransaction.connect((Object)this, "gotDebit");
        this.debitScreen.cancel.connect((Object)this, "display");
        this.debitScreen.done.connect((Object)this, "resumeTransactions");
        this.gui.newSingleCardTransaction.connect((Object)this, "gotSingleCard");
        this.singleCardScreen.cancel.connect((Object)this, "display");
        this.singleCardScreen.done.connect((Object)this, "resumeTransactions");
        this.gui.newMotoTransaction.connect((Object)this, "gotMoto");
        this.motoScreen.cancel.connect((Object)this, "display");
        this.motoScreen.done.connect((Object)this, "resumeTransactions");
        this.gui.newVoucherTransaction.connect((Object)this, "gotVoucher");
        this.voucherScreen.done.connect((Object)this, "resumeTransactions");
        this.gui.newWebTransaction.connect((Object)this, "gotWeb");
        this.webScreen.cancel.connect((Object)this, "display");
        this.webScreen.done.connect((Object)this, "resumeTransactions");
        this.navPanel.printEftposDockets.connect((Object)this, "gotPrintEftposDockets");
        this.adjustmentScreen = new SelectPriceAdjustment(true);
        this.adjustmentScreen.back.connect((Object)this, "display");
        this.displaySignal.connect((Object)this, "display");
        this.selectItemsToRefund.itemsSplit.connect((Object)this, "gotItemsSplit");
        this.selectItemsToRefund.back.connect((Object)this, "display");
        this.selectItemsToRefund.items.connect((Object)this, "gotItemsToRefund");
    }

    public void gotItemsSplit() {
        ((Account)this.payableObject).save();
    }

    public void gotItemsToRefund(Set selectedItems) {
        ClosedAccountRefundHelper carHelper = new ClosedAccountRefundHelper((Account)this.payableObject, new SellableWrapperFactory(), this, new VoucherTopupReversalHelper());
        carHelper.gotItemsToRefund(selectedItems, this.displaySignal, this.displaySignal);
    }

    void setPayable(Payable payable) {
        this.payableObject = payable;
    }

    public void startTransactions(Payable toPay, boolean allowSplitBill, boolean restrictSaveToPaid) {
        this.setPayable(toPay);
        this.newTransactions = new HashSet<FinanceTransaction>();
        this.getTransactionNavBar().setAllowModeChange(allowSplitBill);
        this.onlySaveOnPaid = restrictSaveToPaid;
        this.resumeTransactions();
        this.display();
    }

    protected DebtorTransactionManager getDebtorTransactionManager() {
        return null;
    }

    public void resumeTransactions(FinanceTransaction newTransaction) {
        this.newTransactions.add(newTransaction);
        this.resumeTransactions();
        this.display();
    }

    public void resumeTransactions(List<FinanceTransaction> newTrans) {
        this.newTransactions.addAll(newTrans);
        this.resumeTransactions();
        this.display();
    }

    public void resumeTransactions() {
        this.setupPaymentMethodButtons();
        this.gui.setTransactions(this.getFinanceTransactions(), this.newTransactions, this.getDebtorTransactionManager());
        ((PaymentsNav)this.getNavBar()).showPrintEftpos(this.payableObject.hasEftposDockets());
        this.update();
        this.navPanel.showAutoSplitBill(Terminal.getLocalHost().getSeatNums());
        if (this.payableObject instanceof Account) {
            this.navPanel.showBalanceAccounts(!((Account)this.payableObject).isOpen());
        } else {
            this.navPanel.showBalanceAccounts(false);
        }
        this.setNavBarText();
    }

    protected List<FinanceTransaction> getFinanceTransactions() {
        return this.payableObject.getFinanceTransactions();
    }

    protected void setupPaymentMethodButtons() {
        SystemProperty property = SystemProperty.getInstance();
        if (property.isSinglePaymentMode() && !this.getFinanceTransactions().isEmpty()) {
            this.gui.setAdditionalTransactionsEnabled(false);
        } else {
            this.gui.setAdditionalTransactionsEnabled(true);
        }
        this.gui.setUpVendorBarTabButton(this.getSourceBarTabIntegrationPartner());
    }

    private String getSourceBarTabIntegrationPartner() {
        if (this.payableObject instanceof BarTabAccount) {
            return ((BarTabAccount)this.payableObject).getSource();
        }
        return null;
    }

    public JComponent getMainArea() {
        return this.getTransactionPanel();
    }

    protected PaymentsPanel getTransactionPanel() {
        return this.gui;
    }

    protected SelectPriceAdjustment getAdjustmentScreen() {
        return this.adjustmentScreen;
    }

    public NavBar getNavBar() {
        return this.getTransactionNavBar();
    }

    protected PaymentsNav getTransactionNavBar() {
        return this.navPanel;
    }

    public final void gotBack() {
        this.doBack();
    }

    protected void doBack() {
        this.ValidateVoucherTransactions(false);
        this.back.emit();
    }

    public void gotPreauth() {
        if (this.getPayable() instanceof ItemGroup) {
            WaitermatePreauth preauth = new WaitermatePreauth((ItemGroup)this.getPayable());
            preauth.preauthFinished.connect((Object)this, "gotPreauthFinished");
            preauth.begin();
        }
    }

    public void gotPreauthFinished(PreauthResult result) {
        this.resumeTransactions();
    }

    public void gotCash() {
        this.cashScreen.startAddingTransaction(this.payableObject.getDue(), this.payableObject);
    }

    public void gotCredit() {
        this.creditScreen.startAddingTransaction(this.payableObject.getDue(), this.payableObject);
    }

    public void gotDebit() {
        this.debitScreen.startAddingTransaction(this.payableObject.getDue(), this.payableObject);
    }

    public void gotSingleCard() {
        this.singleCardScreen.startAddingTransaction(this.payableObject.getDue(), this.payableObject);
    }

    public void gotMoto() {
        this.motoScreen.startAddingTransaction(this.payableObject.getDue(), this.payableObject);
    }

    public void gotVoucher() {
        this.voucherScreen.startProcess(this.payableObject);
    }

    public void gotWeb() {
        this.webScreen.startAddingTransaction(this.payableObject.getDue(), this.payableObject);
    }

    public void gotDone() {
        if (this.onlySaveOnPaid && this.getPayable().getPaidState().equals(Payable.NOT_PAID)) {
            WaiterMate.LOG.warn("Attempt to save unpaid account when only save on paid is set. Save not allowed.");
            return;
        }
        if (SystemProperty.getInstance().isCctvEnabled() && Terminal.getLocalHost().getCCTVCamera() != null) {
            CCTVIntegration.showPayoff((Payable)this.payableObject, this.newTransactions, (User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost());
        }
        this.doDone();
        this.ValidateVoucherTransactions(true);
    }

    private void ValidateVoucherTransactions(boolean reacquireFinanceTransaction) {
        for (FinanceTransaction financeTxn : this.getNewTransactions()) {
            if ("VOUCHER".equals(financeTxn.getType()) && "ACTIVE".equals(financeTxn.getSystemState())) {
                GiftVoucherTransaction vTxn = (GiftVoucherTransaction)PersistenceManager.reacquire((PersistentObjectI)((VoucherTransaction)financeTxn).getGiftVoucherTxn());
                if (!SystemState.DELETED_STATE.equals((Object)vTxn.getSystemState())) continue;
                financeTxn.setSystemState("DELETED");
                financeTxn.saveChild();
                continue;
            }
            if (!reacquireFinanceTransaction || !financeTxn.isPersistent()) continue;
            FinanceTransaction financeTransaction = (FinanceTransaction)PersistenceManager.reacquire((PersistentObjectI)financeTxn);
        }
    }

    public void gotPrint() {
        this.doPrint();
    }

    public void balanceAccount(double amt) {
        EventContext currentContext = LoginManager.getEventContext();
        String value = (String)Dialogs.displaySelectionDialogNoCancel((String)"Refund Transaction", (String)"Deleting a transaction has left the account unbalanced, please select an option", Arrays.asList(VOID_ITEMS_PROMPT, DISCOUNT_ITEMS_PROMPT, CONTINUE_WITH_PAYMENT_PROMPT));
        if (value == null) {
            return;
        }
        if (DISCOUNT_ITEMS_PROMPT.equals(value)) {
            if (amt < 0.0) {
                Dialogs.displayOkDialog((String)"Discount cannot be applied to overpaid account", (String)"Cannot Apply Discount");
                return;
            }
            InventoryPriceAdjustment discount = PriceAdjustmentFactory.getInstance().createCustomDiscount(amt, PriceAdjustmentUnit.DOLLAR_UNIT);
            discount.createSalesPriceAdjustment((PriceAdjustable)((Account)this.payableObject), currentContext);
        } else {
            if (VOID_ITEMS_PROMPT.equals(value)) {
                this.selectItemsToRefund.startSelection(new SellableWrapperFactory().getSellables((ItemGroup)((Account)this.payableObject)));
                return;
            }
            if (CONTINUE_WITH_PAYMENT_PROMPT.equals(value)) {
                // empty if block
            }
        }
        this.updateTotals();
    }

    public void balanceReversalOnAccount(FinanceTransaction toDelete) {
        if (this.payableObject instanceof Account && ((Account)this.payableObject).getAccountState().equals((Object)AccountState.CLOSED) && !this.isBalanced()) {
            this.balanceAccount(toDelete.getPaid().abs().doubleValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void gotDelete(FinanceTransaction toDelete) {
        OrderMate.LOG.info("AbstractPaymentsScreen - Deleted Transaction");
        EventContext currentContext = LoginManager.getEventContext();
        if (toDelete.getMovedTransaction() != null) {
            OrderMate.LOG.info("AbstractPaymentsScreen - Found Moved Transaction");
            if (this.getDebtorTransactionManager() == null) throw new IllegalStateException("Cannot return a moved transaction without a debtor manager");
            if (this.getDebtorTransactionManager().returnTransactionBackOnDebtor(toDelete, LoginManager.getInstance().getUser())) {
                if (!this.getDebtorTransactionManager().getTransferringTransactions().contains(toDelete)) {
                    this.deleteTransaction(toDelete);
                } else {
                    this.resumeTransactions();
                }
            } else {
                this.resumeTransactions();
            }
        } else if (toDelete instanceof VoucherTransaction) {
            OrderMate.LOG.info("AbstractPaymentsScreen - Found Voucher Transaction");
            boolean reverse = Dialogs.displayChoiceDialog((String)("Are you sure you want to " + "Reverse".toLowerCase() + " this voucher redemption? This action cannot be undone!"), (String)"Reverse voucher redemption?", (String)"Yes", (String)"No", (boolean)true);
            if (reverse) {
                VoucherTransaction redemptionToDelete = (VoucherTransaction)toDelete;
                VoucherResponse response = redemptionToDelete.getGiftVoucherTxn().isConfirmed() ? VoucherAdministratorRMI.getInstance().reverseTransaction(redemptionToDelete.getGiftVoucherTxn(), currentContext) : VoucherAdministratorRMI.getInstance().cancelTransaction(redemptionToDelete.getGiftVoucherTxn(), currentContext);
                if (response != null && response.isApproved()) {
                    this.payableObject = this.payableObject instanceof AccountPercentagePayable ? (ItemGroup)PersistenceManager.reacquire((PersistentObjectI)((AccountPercentagePayable)this.payableObject).getItemGroup().getAccount()) : (this.payableObject instanceof SplitItemGroup ? (ItemGroup)PersistenceManager.reacquire((PersistentObjectI)((SplitItemGroup)this.payableObject).getAccount()) : (ItemGroup)PersistenceManager.reacquire((PersistentObjectI)((ItemGroup)this.payableObject)));
                    this.voucherReversalDone.emit((Object)((ItemGroup)this.payableObject));
                    this.newTransactions.add((FinanceTransaction)response.getTxn().getFinanceTransaction());
                    this.setupPaymentMethodButtons();
                    this.gui.setTransactions(this.getFinanceTransactions(), this.newTransactions, this.getDebtorTransactionManager());
                    this.setNavBarText();
                    this.updateTotals();
                } else {
                    Dialogs.displayOkDialog((String)response.getDescription(), (String)"Gift Card Transaction Reverse Not Approved");
                }
            }
        } else if (toDelete instanceof WebTransaction && !StringUtils.isEmpty((String)toDelete.getTransactionReference()) && !toDelete.getSubType().isModifiable()) {
            OrderMate.LOG.info("AbstractPaymentsScreen - Found Web Transaction");
            Dialogs.displayOkDialog((String)("Online transaction " + toDelete.getTransactionReference() + " cannot be reversed."), (String)"Cannot Reverse Transaction");
        } else if (!StringUtils.isEmpty((String)toDelete.getSource()) && !toDelete.getSubType().isModifiable()) {
            OrderMate.LOG.info("AbstractPaymentsScreen - Found Third Party Transaction");
            Dialogs.displayOkDialog((String)("This transaction was made via a third party " + toDelete.getSource() + " and cannot be reversed."), (String)"Cannot Reverse Transaction");
        } else {
            OrderMate.LOG.info("AbstractPaymentsScreen - Found Regular Transaction");
            TerminalEventLog.logPaymentCanceled((EventContext)currentContext, (FinanceTransaction)toDelete, (Payable)this.payableObject);
            if (toDelete.usesEftpos()) {
                this.reverseEftposTransaction((EftposTransaction)toDelete);
            } else {
                this.deleteTransaction(toDelete);
                this.balanceReversalOnAccount(toDelete);
            }
        }
        OrderMate.LOG.info("AbstractPaymentsScreen - Deleted Transaction Complete");
    }

    public void gotAdjustTip(FinanceTransaction toModify) {
        if (toModify != null && toModify instanceof EftposTransaction) {
            double tipAmount = Dialogs.getPriceDouble((String)"Tip");
            if (tipAmount != Double.MIN_VALUE) {
                OrderMateLog.LOG.info("Adjusting tip for transaction: " + toModify);
                this.getController().performTipAdjust((EftposTransaction)toModify, new Price(tipAmount, 0.01));
            }
        } else {
            OrderMateLog.LOG.warn("Should not be able to adjust tip for a null or non-eftpos transaction: " + toModify);
        }
    }

    private void deleteTransaction(FinanceTransaction toDelete) {
        this.newTransactions.remove(toDelete);
        this.doDelete(toDelete);
        if (!toDelete.isActive() && this.getPayable() instanceof PriceAdjustable) {
            FinanceSurchargeCalculator.removeSurcharge((Payable)this.getPayable(), (Price)toDelete.getSurcharge(), (EventContext)LoginManager.getEventContext(), (FinanceUnit)toDelete.getSubType());
        }
        this.setupPaymentMethodButtons();
        this.gui.setTransactions(this.getFinanceTransactions(), this.newTransactions, this.getDebtorTransactionManager());
        this.setNavBarText();
        this.updateTotals();
    }

    public void gotEftposAdded(EftposTransaction txn) {
        this.newTransactions.add((FinanceTransaction)txn);
        if (txn.isFullyRefund()) {
            CreditTransaction refundedTxn = (CreditTransaction)PersistenceManager.getByID((long)txn.getReversedTransactionId(), CreditTransaction.class);
            FinanceSurchargeCalculator.removeSurcharge((Payable)txn.getAccount(), (Price)refundedTxn.getSurcharge(), (EventContext)LoginManager.getEventContext(), (FinanceUnit)refundedTxn.getSubType());
        }
    }

    public void gotEftposRemoved(EftposTransaction txn) {
        this.newTransactions.remove(txn);
        FinanceSurchargeCalculator.removeSurcharge((Payable)this.getPayable(), (Price)txn.getSurcharge(), (EventContext)LoginManager.getEventContext(), (FinanceUnit)txn.getSubType());
        this.balanceReversalOnAccount((FinanceTransaction)txn);
    }

    public void gotEftposFinished(EftposTransaction txn) {
        if ("ACTIVE".equals(txn.getSystemState()) && (txn.isPartialRefund() || txn.isFullyRefund())) {
            this.balanceReversalOnAccount((FinanceTransaction)txn);
        }
        this.resumeTransactions();
    }

    public void gotShowDetails() {
        this.doShowDetails();
    }

    public void gotBalanceAccount() {
        this.balanceAccount(this.payableObject.getDue().doubleValue());
    }

    public Payable getPayable() {
        return this.payableObject;
    }

    public boolean hasNewTransactions() {
        return !this.newTransactions.isEmpty();
    }

    public Set<FinanceTransaction> getNewTransactions() {
        return this.newTransactions;
    }

    public void setAllowAccountAdjustement(boolean allow) {
        this.gui.setAccountAdjustmentsEnabled(allow);
    }

    protected Price getPaid() {
        return this.getPayable().getPaid();
    }

    private boolean isBalanced() {
        return Price.ZERO_DOLLAR.equals((Object)((Account)this.payableObject).getDue()) || Price.ZERO_DOLLAR.greaterThan((Object)((Account)this.payableObject).getDue());
    }

    protected void updateTotals() {
        Account account;
        Payable payable = this.getPayable();
        Price totalAmount = payable.getTotal();
        Price paidAmount = this.getPaid();
        Price dueAmount = payable.getDue();
        Price lastChange = Price.ZERO;
        Price tendered = Price.ZERO;
        Price remaining = Price.ZERO_DOLLAR;
        if (!this.getFinanceTransactions().isEmpty()) {
            List<FinanceTransaction> allTransactions = this.getFinanceTransactions();
            FinanceTransaction lastTransaction = allTransactions.get(allTransactions.size() - 1);
            if (lastTransaction instanceof CashTransaction) {
                CashTransaction cashTrans = (CashTransaction)lastTransaction;
                lastChange = cashTrans.getChange();
                tendered = cashTrans.getTendered();
            }
            remaining = VoucherTransactionHelper.getInstance().getRemainingBalance(lastTransaction);
        }
        if (!paidAmount.equals((Object)payable.getPaid())) {
            Price difference = paidAmount.subtract(payable.getPaid());
            dueAmount = dueAmount.subtract(difference);
        }
        this.getTransactionPanel().setInfo(totalAmount, paidAmount, dueAmount);
        this.updateNavBar();
        for (PoleDisplay display : Terminal.getLocalHost().getAvailablePoleDisplays()) {
            display.setFinanceInfo(totalAmount, dueAmount, paidAmount, tendered, lastChange, remaining);
        }
        StandardSecurityDecorator saveButton = ((PaymentsNav)this.getNavBar()).getSaveButton();
        if (this.onlySaveOnPaid) {
            Payable.PaidState state = this.getPayable().getPaidState();
            boolean timeToSave = state.equals(Payable.PAID) || state.equals(Payable.UNPAYABLE) || state.equals(Payable.UNPAYABLE_BY_ROUNDING);
            saveButton.setEnabled(timeToSave);
            this.getNavBar().getBackButton().setEnabled(!timeToSave);
        } else {
            saveButton.setEnabled(true);
            boolean changed = this.hasNewTransactions();
            this.getNavBar().getBackButton().setEnabled(!changed);
        }
        ((PaymentsNav)this.getNavBar()).getBalanceAccountButton().setEnabled(this.payableObject instanceof Account && ((Account)this.payableObject).getAccountState().equals((Object)AccountState.CLOSED) && !Price.ZERO_DOLLAR.equals((Object)((Account)this.payableObject).getDue()));
        if (!Price.ZERO_DOLLAR.equals((Object)dueAmount) && payable instanceof Account && !(account = (Account)payable).isDebtorSale() && !account.isOpen()) {
            this.getNavBar().getBackButton().setEnabled(false);
        }
    }

    public void setBackEnabled(boolean enabled) {
        this.getNavBar().getBackButton().setEnabled(enabled);
    }

    public boolean hasTransactions() {
        return this.getFinanceTransactions().size() > 0;
    }

    private EftposController getController() {
        if (this.controller == null) {
            this.controller = new EftposController();
            this.controller.txnAdded.connect((Object)this, "gotEftposAdded");
            this.controller.txnRemoved.connect((Object)this, "gotEftposRemoved");
            this.controller.eftposFinished.connect((Object)this, "gotEftposFinished");
        }
        return this.controller;
    }

    private void reverseEftposTransaction(EftposTransaction toReverse) {
        this.getController().performTransaction(toReverse, true, this.getPayable());
    }

    public void gotPrintEftposDockets() {
        List toReprint = this.payableObject.getEftposDockets();
        for (FinanceTransactionDocket docket : toReprint) {
            try {
                DocketProcessor.rePrintDocket((AbstractDocket)docket);
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("Problem reprinting EftposDockets:" + ex);
            }
        }
    }

    public void setUp() {
        super.setUp();
        WaiterMateInputAdapter.getInstance().getUnknownCardHandler().done.connect((Object)this, "display");
        WaiterMateInputAdapter.getInstance().enableUnknownCardHandler(true);
    }

    public void tearDown() {
        WaiterMateInputAdapter.getInstance().enableUnknownCardHandler(false);
        super.tearDown();
    }
}

