/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.EventContext;
import ordermate.database.finance.CreditLimited;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.LoginManager;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class CreditLimitPanel
extends JPanel
implements ActionListener {
    private JLabel creditDifferenceLabel;
    private JLabel amountDue;
    private JLabel creditRemaining;
    private JLabel creditDifference;
    private JLabel creditLimit;
    private JButton changeCreditButton;
    private double limitAmt;
    private Color negCreditColor = Color.RED;
    private Color defaultLabelColor;
    private CreditLimited object;
    private boolean showOverLimit = false;
    private Price newSaleAmount;
    private StandardSecurityDecorator changeCreditButtonDecorator;

    private CreditLimitPanel() {
        JLabel amountDueLabel = new JLabel("Amount Due:", 4);
        JLabel creditRemainLabel = new JLabel("Credit Remaining:", 4);
        this.creditDifferenceLabel = new JLabel("Difference:", 4);
        JLabel creditLimitLabel = new JLabel("Credit Limit:", 4);
        this.defaultLabelColor = creditLimitLabel.getForeground();
        amountDueLabel.setFont(OrderMateTheme.getMediumFont());
        creditRemainLabel.setFont(OrderMateTheme.getMediumFont());
        this.creditDifferenceLabel.setFont(OrderMateTheme.getMediumFont());
        creditLimitLabel.setFont(OrderMateTheme.getMediumFont());
        this.amountDue = new JLabel("", 2);
        this.creditRemaining = new JLabel("", 2);
        this.creditDifference = new JLabel("", 2);
        this.creditLimit = new JLabel("", 2);
        this.amountDue.setFont(OrderMateTheme.getMediumFont());
        this.creditRemaining.setFont(OrderMateTheme.getMediumFont());
        this.creditDifference.setFont(OrderMateTheme.getMediumFont());
        this.creditLimit.setFont(OrderMateTheme.getMediumFont());
        this.changeCreditButton = new JButton(IconLoader.get((String)"/waitermate/images/money.png"));
        this.changeCreditButton.addActionListener(this);
        this.changeCreditButton.setName("changeCreditButton");
        this.creditDifference.setName("difference level");
        this.setLayout((LayoutManager)new GraphPaperLayout(7, 4));
        this.add((Component)amountDueLabel, new Rectangle(0, 0, 3, 1));
        this.add((Component)creditRemainLabel, new Rectangle(0, 1, 3, 1));
        this.add((Component)this.creditDifferenceLabel, new Rectangle(0, 2, 3, 1));
        this.add((Component)creditLimitLabel, new Rectangle(0, 3, 3, 1));
        this.add((Component)this.amountDue, new Rectangle(4, 0, 3, 1));
        this.add((Component)this.creditRemaining, new Rectangle(4, 1, 3, 1));
        this.add((Component)this.creditDifference, new Rectangle(4, 2, 3, 1));
        this.add((Component)this.creditLimit, new Rectangle(4, 3, 2, 1));
        this.changeCreditButtonDecorator = new StandardSecurityDecorator((JComponent)this.changeCreditButton, AllPermissions.CHANGE_CREDIT_LIMIT);
        this.add((Component)this.changeCreditButtonDecorator, new Rectangle(6, 3, 1, 1));
        this.setPreferredSize(new Dimension(450, 200));
    }

    private void setup(CreditLimited creditLimitedObject, Price saleAmount, boolean showOverCreditLimit) {
        this.object = creditLimitedObject;
        this.showOverLimit = showOverCreditLimit;
        this.newSaleAmount = saleAmount;
        this.amountDue.setText(this.newSaleAmount.toString());
        this.creditRemaining.setText(creditLimitedObject.getCreditLimitRemaining().toString());
        this.changeCreditButtonDecorator.setEnabled(creditLimitedObject.isCreditLimitChangeAllowed());
        if (this.showOverLimit && creditLimitedObject.exceedsCreditLimit(this.newSaleAmount)) {
            this.creditRemaining.setForeground(this.negCreditColor);
            Price difference = creditLimitedObject.getCreditLimitRemaining().subtract(this.newSaleAmount);
            this.creditDifference.setText(difference.toString());
            this.creditDifference.setVisible(true);
            this.creditDifferenceLabel.setVisible(true);
        } else {
            this.creditRemaining.setForeground(this.defaultLabelColor);
            this.creditDifference.setVisible(false);
            this.creditDifferenceLabel.setVisible(false);
        }
        this.creditLimit.setText(creditLimitedObject.getCreditLimit().toString());
        this.limitAmt = creditLimitedObject.getCreditLimit().doubleValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double newLimit;
        if (e.getSource() == this.changeCreditButton && (newLimit = Dialogs.getPriceDouble((String)"", (double)this.limitAmt)) != this.limitAmt && newLimit != Double.MIN_VALUE) {
            this.changeLimit(newLimit);
        }
    }

    private void changeLimit(double newLimit) {
        Price oldLimit = this.object.getCreditLimit();
        Price newAmount = new Price(newLimit, 0.0);
        this.object.setCreditLimit(newAmount);
        this.setup(this.object, this.newSaleAmount, this.showOverLimit);
        TerminalEventLog.logCreditLimitChange((EventContext)LoginManager.getEventContext(), (CreditLimited)this.object, (Price)newAmount, (Price)oldLimit);
    }

    public static boolean doCreditLimitDialog(CreditLimited creditLimitedObject, Price saleAmount, String name, boolean showOverCreditLimit) {
        return CreditLimitPanel.doCreditLimitDialog(creditLimitedObject, saleAmount, name, showOverCreditLimit, null);
    }

    public static boolean doCreditLimitDialog(CreditLimited creditLimitedObject, Price saleAmount, String name, boolean showOverCreditLimit, String message) {
        PopupWindow popupWin = new PopupWindow(false);
        popupWin.getNavBar().removeLeft((Component)popupWin.getNavBar().getCancelButton());
        if (message != null) {
            popupWin.getNavBar().setText(message);
        } else {
            popupWin.getNavBar().setText("Credit Limit for " + name);
        }
        CreditLimitPanel panel = new CreditLimitPanel();
        panel.setup(creditLimitedObject, saleAmount, showOverCreditLimit);
        popupWin.setComponent((JComponent)panel);
        popupWin.start();
        return !creditLimitedObject.exceedsCreditLimit(saleAmount);
    }
}

