/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.DebtorTransactionGroupAdapter;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.DebtorPaymentRefundAgent;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.finance.transactions.DebtorAdjustmentTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.gui.SaveAccount;
import ordermate.integration.piggy.PiggyService;
import ordermate.integration.piggy.PiggyServiceBuilder;
import ordermate.integration.piggy.PiggyServiceProvider;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.screens.discount.DiscountGuiUtils;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.selectadjustment.DiscountReasonPopup;
import waitermate.gui.screens.payment.transactions.AbstractPaymentsScreen;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.payment.transactions.DebtorPaymentsNav;
import waitermate.gui.screens.payment.transactions.PaymentsPanel;
import waitermate.guikit.showitem.ShowItemsUtils;

public class DebtorPaymentScreen
extends AbstractPaymentsScreen {
    public final Signal doneSignal = Signals.createSignal();
    private PiggyService piggyService;
    private FinanceTransaction deletedDeleteFinanceTransaction;

    public DebtorPaymentScreen() {
        super(new PaymentsPanel(), new DebtorPaymentsNav());
        DebtorPaymentsNav nav = (DebtorPaymentsNav)this.getTransactionNavBar();
        PaymentsPanel gui = this.getTransactionPanel();
        nav.creditLimitSignal.connect((Object)this, "showCreditLimit");
        gui.accountDiscount.connect((Object)this, "gotDiscountSelected");
        gui.surcharge.connect((Object)this, "gotSurchargeSelected");
        this.getAdjustmentScreen().addAdjustment.connect((Object)this, "addAdjustment");
        this.getAdjustmentScreen().removeAdjustment.connect((Object)this, "removeAdjustment");
    }

    @Override
    protected void setupPaymentMethodButtons() {
        super.setupPaymentMethodButtons();
        PaymentsPanel theGui = this.getTransactionPanel();
        theGui.setVisibleAccountButton(false);
        theGui.setVisibleLoyaltyButton(false);
        theGui.setVisibleVoucherButton(false);
        theGui.setVisibleRoomButton(false);
        theGui.setVisibleTabButton(false);
        theGui.setVisibleItemDiscountButton(false);
        theGui.setVisibleItemDiscountButton(false);
        theGui.setVisiblePreviousTransactionButton(false);
        theGui.setVisibleWebButton(true);
        this.getNavBar().getPrintButton().setEnabled(this.hasTransactions());
        if (SystemProperty.getInstance().getPropertyIntegration().equals((Object)PropertyIntegrationType.PIGGY)) {
            this.initPiggyService();
        }
    }

    private void initPiggyService() {
        PiggyServiceBuilder piggyServiceBuilder = new PiggyServiceBuilder().setStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId()));
        PiggyServiceProvider.setPiggyServiceBuilder((PiggyServiceBuilder)piggyServiceBuilder);
        this.piggyService = PiggyServiceProvider.getPiggyService();
    }

    @Override
    protected void doDelete(FinanceTransaction toDelete) {
        this.getPayable().removeFinanceTransaction(toDelete);
        this.deletedDeleteFinanceTransaction = toDelete;
        this.setPayable((Payable)this.getDebtorPaymentAgent());
    }

    @Override
    protected void doDone() {
        AbstractDebtor debtor = this.getDebtorPaymentAgent().getDebtor();
        this.getDebtorPaymentAgent().pay();
        this.doneSignal.emit();
    }

    @Override
    protected void doPrint() {
        DebtorTransactionGroupAdapter group = new DebtorTransactionGroupAdapter(this.getDebtorPaymentAgent());
        WaitermateSaveAccount.getInstance().printReceiptDockets(Collections.singletonList(group));
    }

    @Override
    protected void doBack() {
        this.getDebtorPaymentAgent().saveRemovedTransactions();
        super.doBack();
    }

    @Override
    protected void updateNavBar() {
    }

    @Override
    protected void doShowDetails() {
        if (this.getDebtorPaymentAgent().getSelectedSales().size() == 0) {
            new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showDebtorAccounts(this.getDebtorPaymentAgent().getDebtor().getUnpaidSales());
        } else {
            new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showDebtorAccounts(this.getDebtorPaymentAgent().getSelectedSales());
        }
    }

    @Override
    protected void setNavBarText() {
        this.getNavBar().setText(this.getDebtorPaymentAgent().getLabel());
    }

    @Override
    protected void update() {
        this.updateTotals();
    }

    private DebtorPaymentAgent getDebtorPaymentAgent() {
        return (DebtorPaymentAgent)this.getPayable();
    }

    public void showCreditLimit() {
        CreditLimitPanel.doCreditLimitDialog((CreditLimited)this.getDebtorPaymentAgent(), Price.ZERO_DOLLAR, this.getDebtorPaymentAgent().getDebtor().getLabel(), false);
        this.setNavBarText();
    }

    void gotDiscountSelected() {
        this.getAdjustmentScreen().allowDollarValue(true);
        this.getAdjustmentScreen().start(new ArrayList(), null, PriceAdjustmentDirection.DISCOUNT, PriceAdjustmentType.NORMAL, PriceAdjustmentLevel.ACCOUNT_LEVEL, new TriggerActivationContext(LoginManager.getEventContext()));
    }

    void gotSurchargeSelected() {
        this.getAdjustmentScreen().allowDollarValue(true);
        this.getAdjustmentScreen().start(new ArrayList(), null, PriceAdjustmentDirection.SURCHARGE, PriceAdjustmentType.NORMAL, PriceAdjustmentLevel.ACCOUNT_LEVEL, new TriggerActivationContext(LoginManager.getEventContext()));
    }

    void addAdjustment(InventoryPriceAdjustment adjustment) {
        Price adjustmentAmount;
        String reason = null;
        if (adjustment.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT) && adjustment.getType().equals((Object)PriceAdjustmentType.CUSTOM) && Terminal.getLocalHost().isPromptForCustomDiscountReason()) {
            if (DiscountReasonPopup.areReasonsAvailable()) {
                reason = DiscountReasonPopup.promptForReason();
                if (reason == null) {
                    return;
                }
            } else {
                WaiterMate.LOG.warn("Cannot supply reason code for debtor discount as none are available.");
            }
        }
        if (adjustment.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT) && adjustment.getType().equals((Object)PriceAdjustmentType.NORMAL) && adjustment.isOpenPrice()) {
            double openPriceDoubleValue = this.getOpenPriceValue(adjustment);
            if (openPriceDoubleValue == Double.MIN_VALUE) {
                return;
            }
            adjustmentAmount = adjustment.getUnit().equals((Object)PriceAdjustmentUnit.DOLLAR_UNIT) ? new Price(openPriceDoubleValue, 0.0) : new Price(this.getDebtorPaymentAgent().getTotal().doubleValue() * openPriceDoubleValue / 100.0, 0.0);
        } else {
            adjustmentAmount = adjustment.getUnit().equals((Object)PriceAdjustmentUnit.DOLLAR_UNIT) ? new Price((Number)adjustment.getDollarAmount(), 0.0) : new Price(this.getDebtorPaymentAgent().getTotal().doubleValue() * adjustment.getPercentage() / 100.0, 0.0);
        }
        FinanceTransaction transaction = adjustment.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT) ? DebtorAdjustmentTransaction.createDebtorDiscountTransaction((FinanceTransactionContext)new FinanceTransactionContext(LoginManager.getEventContext()), (Price)adjustmentAmount) : DebtorAdjustmentTransaction.createDebtorSurchargeTransaction((FinanceTransactionContext)new FinanceTransactionContext(LoginManager.getEventContext()), (Price)adjustmentAmount);
        if (reason != null) {
            TerminalEventLog.logCustomDiscountReason((EventContext)LoginManager.getEventContext(), (String)adjustment.getLabel(), (String)reason);
        }
        this.getDebtorPaymentAgent().addFinanceTransaction(transaction);
        this.resumeTransactions(transaction);
        this.updateTotals();
        this.display();
    }

    private double getOpenPriceValue(InventoryPriceAdjustment adjustment) {
        double openPriceDoubleValue = 0.0;
        if (adjustment.getUnit().equals((Object)PriceAdjustmentUnit.DOLLAR_UNIT)) {
            double defaultDoubleValue = this.getDebtorPaymentAgent().getDue().doubleValue();
            double lowerLimit = 0.0;
            double upperLimit = defaultDoubleValue;
            openPriceDoubleValue = DiscountGuiUtils.getDollarAmountFromUser(defaultDoubleValue, lowerLimit, upperLimit);
        } else {
            double defaultDoubleValue = 100.0;
            double lowerLimit = 0.0;
            double upperLimit = 100.0;
            openPriceDoubleValue = DiscountGuiUtils.getPercentageFromUser(defaultDoubleValue, lowerLimit, upperLimit);
        }
        return openPriceDoubleValue;
    }

    void removeAdjustment(SalesPriceAdjustmentI adjustment) {
        this.updateTotals();
        this.display();
    }

    public void startTransactions(DebtorPaymentAgent toPay) {
        super.startTransactions((Payable)toPay, false, false);
    }

    public void startTransactions(DebtorPaymentRefundAgent toPay) {
        super.startTransactions((Payable)toPay, false, true);
    }
}

