/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.integration.cloudback.nudge.NudgeManager;
import ordermate.services.messages.SendDebtorInvoiceEmailExecutable;

public class DebtorSaleHandler {
    public void salePerformed(AbstractDebtor debtor, Account saleAccount) {
        if ((SystemProperty.getInstance().isMessageServerEnabled() || NudgeManager.isNudgeConfigured()) && debtor instanceof CustomerDebtor) {
            this.postDebtorInvoice((CustomerDebtor)debtor, saleAccount);
        }
    }

    private void postDebtorInvoice(CustomerDebtor theDebtor, Account thePaidAccount) {
        Customer customer = theDebtor.getCustomer();
        if (customer == null) {
            OrderMate.LOG.info("No customer tied to debtor, so no invoice is sent:" + theDebtor);
            return;
        }
        if (!customer.isReceiveDebtorInvoice()) {
            OrderMate.LOG.info("The customer has opted out of invoice emails, debtor:" + theDebtor);
            return;
        }
        String emailAddress = customer.getEmail();
        if (emailAddress == null || emailAddress.length() < 4 || !emailAddress.contains("@")) {
            OrderMate.LOG.info("The customer email is null, empty or malformed, debtor:" + theDebtor);
            return;
        }
        OrderMate.LOG.info("Servermate to send out the Debtor Invoice");
        DebtorSale sale = (DebtorSale)PersistenceManager.getObject(DebtorSale.class, (String)Query.select(DebtorSale.class).equals(DebtorSale.Properties.SALE_ACCOUNT, (Object)thePaidAccount).toString(), null);
        if (sale == null) {
            OrderMate.LOG.warn("Couldn't find the debtor sale attached to the account:" + thePaidAccount);
            return;
        }
        PersistenceManager.getServerConnection().runSync((Executable)new SendDebtorInvoiceEmailExecutable(sale.getID().longValue(), customer.getID().longValue()));
    }
}

