/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.util.Price;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;

public class LoyaltyRefundWarningHelper {
    private ItemGroup itemGroup;

    public LoyaltyRefundWarningHelper(ItemGroup itemGroup) {
        this.itemGroup = itemGroup;
    }

    private ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    public boolean isLoyaltyRefundWarningRequired() {
        boolean hasRefund = false;
        boolean hasLoyaltyEarn = false;
        if (SystemProperty.getInstance().isLoyaltyEnabled() && this.getItemGroup().getCustomer() != null) {
            for (FinanceTransaction tran : this.getItemGroup().getFinanceTransactions()) {
                if (!tran.getPaid().greaterThan((Object)Price.ZERO_DOLLAR)) continue;
                for (SalesLineItem item : this.getItemGroup().getItemHelper().getItemsForTransaction(tran)) {
                    if (!item.getQuantity().equals(0L)) continue;
                    for (SalesItem sItem : item.getSalesItems()) {
                        for (SalesComponent comp : sItem.getComponentList()) {
                            if (comp.getMenuLoyaltyAdd() <= 0) continue;
                            hasLoyaltyEarn = true;
                        }
                    }
                }
            }
            for (FinanceTransaction trans : this.getItemGroup().getFinanceTransactions()) {
                if (!trans.getPaid().lessThan((Object)Price.ZERO_DOLLAR)) continue;
                hasRefund = true;
            }
        }
        return hasRefund && hasLoyaltyEarn;
    }

    public JComponent createLoyaltyRefundWarningPanel() {
        JPanel toReturn = new JPanel();
        toReturn.setLayout(new BoxLayout(toReturn, 1));
        toReturn.add(new JLabel("<html>" + this.getItemGroup().getCustomer().getName() + " earned " + this.getLoyaltyForAccount() + " point(s) on this account.</html>"));
        toReturn.add(new JLabel("Refunding it will remove these points."));
        toReturn.add(new JLabel("<html><br></html>"));
        JLabel currentBalance = new JLabel("<html>Current Points Balance: " + this.getCurrentLoyaltyForCustomer() + "</html>");
        currentBalance.setHorizontalAlignment(0);
        toReturn.add(currentBalance);
        toReturn.add(new JLabel("<html><br></html>"));
        JLabel postRefundBalance = new JLabel("<html>After Refund Balance: " + this.calculatePostRefundLoyaltyBalance() + "</html>");
        postRefundBalance.setHorizontalAlignment(0);
        toReturn.add(postRefundBalance);
        return toReturn;
    }

    public int calculatePostRefundLoyaltyBalance() {
        return this.getCurrentLoyaltyForCustomer() - this.getLoyaltyForAccount();
    }

    public int getCurrentLoyaltyForCustomer() {
        return this.getItemGroup().getCustomer().getLoyaltyPoints();
    }

    public int getLoyaltyForAccount() {
        int toReturn = 0;
        for (SalesLineItem sLItem : this.getItemGroup().getAccount().getAllItemsExcDeleted()) {
            if (!sLItem.getQuantity().equals(0L)) continue;
            for (SalesItem sItem : sLItem.getSalesItems()) {
                for (SalesComponent currentComponent : sItem.getComponentList()) {
                    int purchasedQty = sItem.getQuantity("ACTIVE").getValue().intValue();
                    toReturn += currentComponent.getMenuLoyaltyAdd() * purchasedQty;
                }
            }
        }
        return toReturn;
    }
}

