/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.AbstractComponentDecorator;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import ordermate.OrderMate;
import ordermate.database.debtors.DebtorTransactionManager;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.integration.webpayment.WebPaymentType;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.users.AllPermissions;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.modify.security.SwipeOverSecurityDecorator;
import waitermate.gui.screens.payment.transactions.TransactionPanel;

public class PaymentsPanel
extends JPanel
implements ActionListener {
    private static final int LABEL_START = 20;
    private static final int LABEL_WIDTH = 25;
    private static final int ANS_START = 60;
    private static final int ANS_WIDTH = 40;
    private static final String[] PAYMENT_RETURN_SCREENS = new String[]{"AbstractPaymentsScreen", "AccountPaymentsScreen", "DebtorPaymentScreen", "PercentagePaymentScreen"};
    public final Signal preauthTransaction = Signals.createSignal();
    public final Signal newCashTransaction = Signals.createSignal();
    public final Signal newCreditTransaction = Signals.createSignal();
    public final Signal newDebitTransaction = Signals.createSignal();
    public final Signal newSingleCardTransaction = Signals.createSignal();
    public final Signal newMotoTransaction = Signals.createSignal();
    public final Signal newDebtorTransaction = Signals.createSignal();
    public final Signal newDebtorRoomTransaction = Signals.createSignal();
    public final Signal newLoyaltyTransaction = Signals.createSignal();
    public final Signal newVoucherTransaction = Signals.createSignal();
    public final Signal newApplyPreviousTransaction = Signals.createSignal();
    public final Signal newBarTabTransaction = Signals.createSignal();
    public final Signal newWebTransaction = Signals.createSignal();
    public final Signal<FinanceTransaction, ?, ?, ?, ?> deleteTransaction = Signals.createSignal(FinanceTransaction.class, (String)"transaction");
    public final Signal adjustTip = Signals.createSignal(FinanceTransaction.class, (String)"transaction");
    public final Signal accountDiscount = Signals.createSignal();
    public final Signal itemDiscount = Signals.createSignal();
    public final Signal surcharge = Signals.createSignal();
    private final DefaultScrollPaneModel transactions;
    private final JButton creditButton;
    private final JButton preauthButton;
    private final JButton cashButton;
    private final JButton debitButton;
    private final JButton singleCardButton;
    private final JButton motoButton;
    private final JButton accountButton;
    private final JButton webButton;
    private final JButton tabButton;
    private final JButton loyaltyButton;
    private final JButton roomButton;
    private final JButton applyPreviousTransactionButton;
    private final JButton voucherButton;
    private final StandardSecurityDecorator credit;
    private final StandardSecurityDecorator cash;
    private final StandardSecurityDecorator debit;
    private final StandardSecurityDecorator singleCard;
    private final StandardSecurityDecorator moto;
    private final StandardSecurityDecorator account;
    private final StandardSecurityDecorator web;
    private final StandardSecurityDecorator loyalty;
    private final StandardSecurityDecorator room;
    private final StandardSecurityDecorator tab;
    private final StandardSecurityDecorator applyPreviousTransaction;
    private JButton itemDiscountButton;
    private AbstractComponentDecorator itemDiscountDecorator;
    private JButton accountDiscountButton;
    private AbstractComponentDecorator accountDiscountDecorator;
    private JButton surchargeButton;
    private AbstractComponentDecorator surchargeDecorator;
    private JLabel total;
    private JLabel paid;
    private JLabel due;
    private JLabel accountDiscountLabel;
    private JLabel itemDiscountLabel;
    private JLabel surchargeLabel;
    private Price totalAmount;
    private Price dueAmount;
    private boolean transactionsEnabled = true;
    private boolean tabEnabled = true;
    private boolean debtorsEnabled = true;
    private boolean roomEnabled = true;
    private boolean loyaltyEnabled = true;
    private final JButton vendorBarTabButton;
    private final StandardSecurityDecorator vendorBarTabDecorator;
    private final NameDecorator vendorBarTabNameDecorator;
    private DefaultScrollPaneModel paymentMethodsModel;
    private CustomScrollPane methodPane;

    private JButton getButton(String caption, Icon icon) {
        JButton button = new JButton(caption, icon);
        button.setHorizontalAlignment(2);
        button.setIconTextGap(10);
        return button;
    }

    public PaymentsPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(4, 10)));
        this.setName("TransactionsPanel");
        this.paymentMethodsModel = new DefaultScrollPaneModel(1, 7);
        this.methodPane = new CustomScrollPane((CustomScrollPaneModel)this.paymentMethodsModel);
        this.add((Component)new NameDecorator((JComponent)this.methodPane, "payoffTypes"), new Rectangle(0, 0, 1, 10));
        this.methodPane.setBorder((Border)BorderFactory.createTitledBorder("Payment Methods"));
        ArrayList<Object> buttons = new ArrayList<Object>();
        this.cashButton = this.getButton(Internationalization.getLiteralFor((String)"CASH"), IconLoader.get((String)"/waitermate/images/money.png"));
        this.cashButton.addActionListener(this);
        this.cashButton.setName("cashButton");
        this.cash = new StandardSecurityDecorator((JComponent)this.cashButton, AllPermissions.PAY);
        buttons.add(new NameDecorator((JComponent)this.cash, "cashButton"));
        this.singleCardButton = this.getButton(Internationalization.getLiteralFor((String)"SINGLE_CARD"), IconLoader.get((String)"/waitermate/images/dcard.png"));
        this.singleCardButton.addActionListener(this);
        this.singleCardButton.setName("singleCardButton");
        this.singleCard = new StandardSecurityDecorator((JComponent)this.singleCardButton, AllPermissions.PAY);
        this.motoButton = this.getButton(Internationalization.getLiteralFor((String)"MOTO"), IconLoader.get((String)"/waitermate/images/moto.png"));
        this.motoButton.addActionListener(this);
        this.motoButton.setName("motoButton");
        this.moto = new StandardSecurityDecorator((JComponent)this.motoButton, AllPermissions.PAY);
        this.creditButton = this.getButton(Internationalization.getLiteralFor((String)"CREDIT"), IconLoader.get((String)"/waitermate/images/ccard.png"));
        this.creditButton.addActionListener(this);
        this.creditButton.setName("creditButton");
        this.credit = new StandardSecurityDecorator((JComponent)this.creditButton, AllPermissions.PAY);
        this.debitButton = this.getButton(Internationalization.getLiteralFor((String)"DEBIT"), IconLoader.get((String)"/waitermate/images/dcard.png"));
        this.debitButton.addActionListener(this);
        this.debitButton.setName("debitButton");
        this.debit = new StandardSecurityDecorator((JComponent)this.debitButton, AllPermissions.PAY);
        if (AdyenIntegrationConfig.getInstance().isConfigured()) {
            buttons.add(new NameDecorator((JComponent)this.singleCard, "singleCardButton"));
        } else {
            buttons.add(new NameDecorator((JComponent)this.credit, "creditButton"));
            buttons.add(new NameDecorator((JComponent)this.debit, "debitButton"));
        }
        buttons.add(new NameDecorator((JComponent)this.moto, "motoButton"));
        this.webButton = this.getButton(Internationalization.getLiteralFor((String)"WEB"), IconLoader.get((String)"/waitermate/images/web.png"));
        this.webButton.addActionListener(this);
        this.webButton.setName("webButton");
        this.web = new StandardSecurityDecorator((JComponent)this.webButton, AllPermissions.PAY);
        buttons.add(new NameDecorator((JComponent)this.web, "webButton"));
        this.voucherButton = this.getButton(Internationalization.getLiteralFor((String)"VOUCHER"), IconLoader.get((String)"/waitermate/images/voucher.png"));
        this.voucherButton.addActionListener(this);
        this.voucherButton.setName("voucherButton");
        buttons.add(this.voucherButton);
        this.vendorBarTabButton = this.getButton("", IconLoader.get((String)"/waitermate/images/partners/BookARestaurantLogo.png"));
        this.vendorBarTabButton.addActionListener(this);
        this.vendorBarTabButton.setName("vendorBarTabButton");
        this.vendorBarTabDecorator = new StandardSecurityDecorator((JComponent)this.vendorBarTabButton, AllPermissions.PAY);
        this.vendorBarTabNameDecorator = new NameDecorator((JComponent)this.vendorBarTabDecorator, "vendorBarTabButton");
        this.accountButton = this.getButton(Internationalization.getLiteralFor((String)"CUSTOMER_ACCOUNT"), IconLoader.get((String)"/waitermate/images/customer.png"));
        this.account = new StandardSecurityDecorator((JComponent)this.accountButton, AllPermissions.PAY_CUSTOMER_ACCOUNTS);
        if (Terminal.getLocalHost().hasDebtorsMode()) {
            this.accountButton.addActionListener(this);
            this.accountButton.setName("accountButton");
            buttons.add(new NameDecorator((JComponent)this.account, "accountButton"));
        }
        this.tabButton = this.getButton(Internationalization.getLiteralFor((String)"TRANSFER_TO_TAB"), IconLoader.get((String)"/waitermate/images/card.png"));
        this.tab = new StandardSecurityDecorator((JComponent)this.tabButton, AllPermissions.PAY_TABS);
        if (Terminal.getLocalHost().hasBarTabsMode()) {
            this.tabButton.addActionListener(this);
            this.tabButton.setName("barTab");
            buttons.add(new NameDecorator((JComponent)this.tab, "barTab"));
        }
        this.loyaltyButton = this.getButton(Internationalization.getLiteralFor((String)"LOYALTY"), IconLoader.get((String)"/waitermate/images/loyalty.png"));
        this.loyalty = new StandardSecurityDecorator((JComponent)this.loyaltyButton, AllPermissions.PAY_TO_LOYALTY);
        if (SystemProperty.getInstance().isLoyaltyEnabled()) {
            this.loyaltyButton.addActionListener(this);
            this.loyaltyButton.setName("loyaltyButton");
            buttons.add(new NameDecorator((JComponent)this.loyalty, "loyaltyButton"));
        }
        this.applyPreviousTransactionButton = this.getButton(Internationalization.getLiteralFor((String)"APPLY_PREVIOUS_TRANSCTION"), IconLoader.get((String)"/waitermate/images/fastPay.png"));
        this.applyPreviousTransaction = new StandardSecurityDecorator((JComponent)this.applyPreviousTransactionButton, AllPermissions.PAY_CUSTOMER_ACCOUNTS);
        if (Terminal.getLocalHost().hasDebtorsMode()) {
            this.applyPreviousTransactionButton.addActionListener(this);
            this.applyPreviousTransactionButton.setName("applyPreviousTransactionButton");
            buttons.add(new NameDecorator((JComponent)this.applyPreviousTransaction, "applyPreviousTransactionButton"));
        }
        this.roomButton = this.getButton(Internationalization.getLiteralFor((String)"ROOM_ACCOUNT"), IconLoader.get((String)"/waitermate/images/roomAccountIcon.png"));
        this.room = new StandardSecurityDecorator((JComponent)this.roomButton, AllPermissions.PAY_ROOM_ACCOUNT);
        this.roomButton.addActionListener(this);
        this.roomButton.setName("roomButton");
        buttons.add(new NameDecorator((JComponent)this.room, "roomButton"));
        if (!SystemProperty.getInstance().getPropertyIntegration().equals((Object)PropertyIntegrationType.NONE)) {
            this.roomButton.setVisible(false);
        } else {
            this.roomButton.setVisible(true);
        }
        this.preauthButton = this.getButton(Internationalization.getLiteralFor((String)"PREAUTH"), IconLoader.get((String)"/waitermate/images/card.png"));
        this.preauthButton.addActionListener(this);
        this.preauthButton.setName("preauthButton");
        this.preauthButton.setVisible(false);
        buttons.add(new NameDecorator((JComponent)this.preauthButton, "preauthButton"));
        this.paymentMethodsModel.setItems(buttons);
        this.transactions = new DefaultScrollPaneModel(1, 4);
        CustomScrollPane transactionPane = new CustomScrollPane((CustomScrollPaneModel)this.transactions);
        transactionPane.setDecorationLocation(DecoratorLocation.West);
        transactionPane.setBorder((Border)new TitledBorder(Internationalization.getLiteralFor((String)"TRANSACTIONS") + ":"));
        this.add((Component)transactionPane, new Rectangle(1, 0, 3, 5));
        JPanel totalPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(100, 9)));
        totalPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"TOTALS") + ":"));
        this.surchargeButton = new JButton(Internationalization.getLiteralFor((String)"SURCHARGE"));
        this.surchargeButton.addActionListener(this);
        this.surchargeDecorator = new SwipeOverSecurityDecorator(this.surchargeButton, AllPermissions.SURCHARGE, this.surcharge, PAYMENT_RETURN_SCREENS);
        totalPanel.add((Component)this.surchargeDecorator, new Rectangle(20, 0, 25, 2));
        this.accountDiscountButton = new JButton(Internationalization.getLiteralFor((String)"ACCOUNT_DISCOUNT"));
        this.accountDiscountButton.addActionListener(this);
        this.accountDiscountDecorator = new SwipeOverSecurityDecorator(this.accountDiscountButton, AllPermissions.DISCOUNT, this.accountDiscount, PAYMENT_RETURN_SCREENS);
        totalPanel.add((Component)this.accountDiscountDecorator, new Rectangle(20, 2, 25, 2));
        this.itemDiscountButton = new JButton(Internationalization.getLiteralFor((String)"ITEM_DISCOUNT"));
        this.itemDiscountButton.addActionListener(this);
        this.itemDiscountDecorator = new SwipeOverSecurityDecorator(this.itemDiscountButton, AllPermissions.DISCOUNT, this.itemDiscount, PAYMENT_RETURN_SCREENS);
        totalPanel.add((Component)this.itemDiscountDecorator, new Rectangle(20, 4, 25, 2));
        JLabel totalLabel = new JLabel(this.getTotalString() + ":");
        totalLabel.setHorizontalAlignment(2);
        totalPanel.add((Component)totalLabel, new Rectangle(20, 6, 25, 1));
        JLabel paidLabel = new JLabel(Internationalization.getLiteralFor((String)"AMOUNT_PAID") + ":");
        paidLabel.setHorizontalAlignment(2);
        totalPanel.add((Component)paidLabel, new Rectangle(20, 7, 25, 1));
        JLabel dueLabel = new JLabel(Internationalization.getLiteralFor((String)"AMOUNT_DUE") + ":");
        Font dueFont = OrderMateTheme.getLargeFont().deriveFont(1);
        dueLabel.setFont(dueFont);
        dueLabel.setHorizontalAlignment(2);
        totalPanel.add((Component)dueLabel, new Rectangle(20, 8, 25, 1));
        this.surchargeLabel = new JLabel("0");
        this.surchargeLabel.setHorizontalAlignment(4);
        totalPanel.add((Component)this.surchargeLabel, new Rectangle(60, 0, 40, 2));
        this.surchargeLabel.setName("Surcharge");
        this.accountDiscountLabel = new JLabel("0");
        this.accountDiscountLabel.setHorizontalAlignment(4);
        totalPanel.add((Component)this.accountDiscountLabel, new Rectangle(60, 2, 40, 2));
        this.accountDiscountLabel.setName("Account Discount");
        this.itemDiscountLabel = new JLabel("0");
        this.itemDiscountLabel.setHorizontalAlignment(4);
        totalPanel.add((Component)this.itemDiscountLabel, new Rectangle(60, 4, 40, 2));
        this.itemDiscountLabel.setName("Item Discount");
        this.total = new JLabel(Internationalization.getLiteralFor((String)"_TOTAL"));
        this.total.setName("totalLabel");
        this.total.setHorizontalAlignment(4);
        totalLabel.setLabelFor(this.total);
        totalPanel.add((Component)this.total, new Rectangle(60, 6, 40, 1));
        this.paid = new JLabel(Internationalization.getLiteralFor((String)"_PAID"));
        this.paid.setName("paidLabel");
        this.paid.setHorizontalAlignment(4);
        paidLabel.setLabelFor(this.paid);
        totalPanel.add((Component)this.paid, new Rectangle(60, 7, 40, 1));
        this.due = new JLabel(Internationalization.getLiteralFor((String)"_DUE"));
        this.due.setName("dueLabel");
        this.due.setFont(dueFont);
        this.due.setHorizontalAlignment(4);
        dueLabel.setLabelFor(this.due);
        totalPanel.add((Component)this.due, new Rectangle(60, 8, 40, 1));
        this.totalAmount = new Price(0.0);
        this.dueAmount = new Price(0.0);
        transactionPane.setEmptyMessage(Internationalization.getLiteralFor((String)"PLEASE_SELECT_PAYMENT_METHOD"));
        this.add((Component)totalPanel, new Rectangle(1, 5, 3, 5));
    }

    private String getTotalString() {
        if (SystemProperty.getInstance().isExTax()) {
            return Internationalization.getLiteralFor((String)"TOTAL_INC_TAX");
        }
        return Internationalization.getLiteralFor((String)"TOTAL");
    }

    void setTransactions(List<FinanceTransaction> transactionList, Set newTransactions, DebtorTransactionManager debtorTxnManager) {
        ArrayList<TransactionPanel> components = new ArrayList<TransactionPanel>();
        if (debtorTxnManager != null) {
            for (FinanceTransaction txn : debtorTxnManager.getTransferringTransactions()) {
                if (debtorTxnManager.isCurrentlyBeingTransferred(txn)) continue;
                components.add(new TransactionPanel(txn, debtorTxnManager, this.deleteTransaction, this.adjustTip, false));
            }
        }
        for (FinanceTransaction transaction : transactionList) {
            components.add(new TransactionPanel(transaction, debtorTxnManager, this.deleteTransaction, this.adjustTip, newTransactions.contains(transaction)));
        }
        this.transactions.setItems(components);
    }

    public void setSurchargeInfo(String surchargeString) {
        this.surchargeLabel.setText(surchargeString);
    }

    public void setItemDiscountInfo(String discountString, boolean isLoyalty) {
        this.itemDiscountLabel.setText(discountString);
        this.itemDiscountLabel.setIcon(isLoyalty ? IconLoader.get((String)"/waitermate/images/loyaltySmall.png") : null);
    }

    public void setAccountDiscountInfo(String discountString) {
        this.accountDiscountLabel.setText(discountString);
    }

    public void setAccountAdjustmentsEnabled(boolean enable) {
        this.surchargeDecorator.setEnabled(enable);
        this.accountDiscountDecorator.setEnabled(enable);
    }

    public void setItemAdjustmentsEnabled(boolean enable) {
        this.itemDiscountDecorator.setEnabled(enable);
    }

    public void setInfo(Price totalValue, Price paidValue, Price dueValue) {
        this.totalAmount = totalValue;
        this.dueAmount = dueValue;
        this.total.setText(this.totalAmount.toString());
        this.paid.setText(paidValue.toString());
        if (this.dueAmount.doubleValue() < 0.0) {
            this.due.setText(this.dueAmount.toString());
            this.due.setForeground(Color.RED);
        } else {
            this.due.setText(this.dueAmount.toString());
            this.due.setForeground(null);
        }
        this.methodPane.displayPage(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cashButton) {
            this.newCashTransaction.emit();
        } else if (e.getSource() == this.preauthButton) {
            this.preauthTransaction.emit();
        } else if (e.getSource() == this.creditButton) {
            this.newCreditTransaction.emit();
        } else if (e.getSource() == this.debitButton) {
            this.newDebitTransaction.emit();
        } else if (e.getSource() == this.singleCardButton) {
            this.newSingleCardTransaction.emit();
        } else if (e.getSource() == this.motoButton) {
            this.newMotoTransaction.emit();
        } else if (e.getSource() == this.webButton) {
            this.newWebTransaction.emit();
        } else if (e.getSource() == this.accountButton) {
            this.newDebtorTransaction.emit();
        } else if (e.getSource() == this.loyaltyButton) {
            this.newLoyaltyTransaction.emit();
        } else if (e.getSource() == this.voucherButton) {
            this.newVoucherTransaction.emit();
        } else if (e.getSource() == this.roomButton) {
            this.newDebtorRoomTransaction.emit();
        } else if (e.getSource() == this.tabButton) {
            this.newBarTabTransaction.emit();
        } else if (e.getSource() == this.applyPreviousTransactionButton) {
            this.newApplyPreviousTransaction.emit();
        } else if (e.getSource() == this.vendorBarTabButton) {
            this.newWebTransaction.emit((Object)WebPaymentType.BarTabPartner);
        }
    }

    public void setLoyaltyButtonEnabled(boolean enable) {
        this.loyaltyEnabled = enable;
        if (this.loyalty != null) {
            this.loyalty.setEnabled(this.loyaltyEnabled && this.transactionsEnabled);
        }
    }

    public void setRoomButtonEnabled(boolean enable) {
        this.roomEnabled = enable;
        if (this.room != null) {
            this.room.setEnabled(this.roomEnabled && this.transactionsEnabled);
            this.roomButton.setVisible(enable);
        }
    }

    public void setDebtorsEnabled(boolean enable) {
        this.debtorsEnabled = enable;
        if (this.account != null) {
            this.account.setEnabled(this.debtorsEnabled && this.transactionsEnabled);
        }
    }

    public void setTabEnabled(boolean enable) {
        this.tabEnabled = enable;
        if (this.tab != null) {
            this.tab.setEnabled(this.tabEnabled && this.transactionsEnabled);
        }
    }

    public void setVoucherButtonEnabled(boolean enable) {
        if (this.voucherButton != null) {
            this.voucherButton.setEnabled(enable && this.transactionsEnabled);
        }
    }

    public void setVisibleAccountButton(boolean showIt) {
        this.account.setVisible(showIt);
    }

    public void setVisibleLoyaltyButton(boolean showIt) {
        if (this.loyalty != null) {
            this.loyalty.setVisible(showIt);
        }
    }

    public void setVisiblePreauth(boolean value) {
        if (this.preauthButton != null) {
            this.preauthButton.setVisible(true);
        }
    }

    public void setVisibleVoucherButton(boolean showIt) {
        if (this.voucherButton != null) {
            this.voucherButton.setVisible(showIt);
        }
    }

    public void setVisibleWebButton(boolean showIt) {
        if (this.web != null) {
            this.web.setVisible(showIt);
        }
    }

    public void setVisibleTabButton(boolean showIt) {
        if (this.tab != null) {
            this.tab.setVisible(showIt);
        }
    }

    public void setVisibleItemDiscountButton(boolean showIt) {
        this.itemDiscountDecorator.setVisible(showIt);
        this.itemDiscountLabel.setVisible(showIt);
    }

    public void setVisibleRoomButton(boolean showIt) {
        if (this.room != null) {
            this.room.setVisible(showIt);
        }
    }

    public void setVisiblePreviousTransactionButton(boolean showIt) {
        if (this.applyPreviousTransaction != null) {
            this.applyPreviousTransaction.setVisible(showIt);
        }
    }

    public boolean isMOTOEnabled() {
        if (LoginManager.getEventContext().getUser() == null) {
            return false;
        }
        if (FinanceUnit.getActiveMOTOUnits().isEmpty() || !AdyenIntegrationConfig.getInstance().isConfigured()) {
            return false;
        }
        return LoginManager.getEventContext().getUser().hasPermission(AllPermissions.PERFORM_MOTO);
    }

    private boolean isPaymentMethodEnabled(String paymentType) {
        FinanceUnit financeUnit = FinanceUnit.getUnitForUnitType((String)paymentType);
        return financeUnit != null;
    }

    public void setAdditionalTransactionsEnabled(boolean enable) {
        this.transactionsEnabled = enable;
        this.cash.setEnabled(this.transactionsEnabled && this.isPaymentMethodEnabled("CASH"));
        this.credit.setEnabled(this.transactionsEnabled && this.isPaymentMethodEnabled("CREDIT"));
        this.debit.setEnabled(this.transactionsEnabled && this.isPaymentMethodEnabled("DEBIT"));
        this.singleCard.setEnabled(this.transactionsEnabled);
        this.moto.setEnabled(this.transactionsEnabled && this.isMOTOEnabled());
        this.web.setEnabled(this.transactionsEnabled && this.isPaymentMethodEnabled(Internationalization.getLiteralFor((String)"DEBIT")));
        this.voucherButton.setEnabled(this.transactionsEnabled);
        this.account.setEnabled(this.transactionsEnabled && this.debtorsEnabled);
        this.vendorBarTabButton.setEnabled(this.transactionsEnabled);
        if (this.tab != null) {
            this.tab.setEnabled(this.transactionsEnabled && this.tabEnabled);
        }
        if (this.room != null) {
            this.room.setEnabled(this.roomEnabled && this.transactionsEnabled);
        }
    }

    void setUpVendorBarTabButton(String integrationVendorId) {
        BarTabsConfiguration barTabConfig = null;
        if (integrationVendorId != null && !integrationVendorId.isEmpty()) {
            barTabConfig = BarTabsConfiguration.getBarTabConfigForVendorId((String)integrationVendorId);
        }
        if (barTabConfig != null && barTabConfig.isAllowsPayOff()) {
            try {
                this.vendorBarTabButton.setIcon(IconLoader.get((String)barTabConfig.getIcon()));
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error while loading icon: " + barTabConfig.getIcon(), (Throwable)ex);
            }
            this.vendorBarTabButton.setText(barTabConfig.getPayButtonTxt());
            this.vendorBarTabDecorator.setVisible(true);
            this.paymentMethodsModel.addComponent((Component)this.vendorBarTabNameDecorator, 0);
        } else {
            this.paymentMethodsModel.removeComponent((Component)this.vendorBarTabNameDecorator);
            this.vendorBarTabDecorator.setVisible(false);
        }
    }
}

