/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.transactions;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.debtors.DebtorTransactionManager;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionHelper;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.VoucherTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import waitermate.LoginManager;

class TransactionPanel
extends JPanel
implements ActionListener {
    private final FinanceTransaction txn;
    private final DebtorTransactionManager debtorTxnManager;
    private final Signal<FinanceTransaction, ?, ?, ?, ?> deleteTxn;
    private final Signal<FinanceTransaction, ?, ?, ?, ?> adjustTip;
    private boolean isNew;
    private JLabel name;
    private JPanel noteHolder;
    private JPanel cardNumberHolder;
    private JPanel priceHolder;
    private JPanel buttonHolder;
    private JButton deleteButton;

    TransactionPanel(FinanceTransaction yourTxn, DebtorTransactionManager yourDebtorTxnManager, Signal<FinanceTransaction, ?, ?, ?, ?> deleteTransaction, Signal<FinanceTransaction, ?, ?, ?, ?> adjustTip, boolean isNew) {
        super((LayoutManager)new GraphPaperLayout(100, 100));
        this.txn = yourTxn;
        this.debtorTxnManager = yourDebtorTxnManager;
        this.deleteTxn = deleteTransaction;
        this.adjustTip = adjustTip;
        this.isNew = isNew;
        this.setupComponents();
    }

    private void setupComponents() {
        boolean hasTipButton;
        this.name = new JLabel(this.makeLabel());
        this.name.setHorizontalAlignment(2);
        this.name.setOpaque(true);
        this.name.setName("name_label");
        this.noteHolder = new JPanel(new BorderLayout());
        String notes = this.makeNotes();
        JLabel note = new JLabel();
        note.setText(notes);
        note.setForeground(Color.GRAY);
        note.setHorizontalAlignment(2);
        note.setName("note_label");
        this.noteHolder.add((Component)note, "Center");
        this.noteHolder.setOpaque(true);
        this.cardNumberHolder = new JPanel(new BorderLayout());
        JLabel cardNumber = new JLabel();
        cardNumber.setText(this.txn.getMaskedCardNumber());
        cardNumber.setForeground(Color.GRAY);
        cardNumber.setHorizontalAlignment(2);
        cardNumber.setName("card_number_label");
        this.cardNumberHolder.add((Component)cardNumber, "Center");
        this.cardNumberHolder.setOpaque(true);
        this.priceHolder = new JPanel(new BorderLayout());
        this.priceHolder.setOpaque(true);
        JLabel price = new JLabel(this.makePriceLabel());
        price.setName("price_label");
        price.setOpaque(true);
        price.setHorizontalAlignment(4);
        this.priceHolder.add((Component)price, "Center");
        boolean bl = hasTipButton = this.txn.usesEftpos() && ((EftposTransaction)this.txn).isAllowTipAdjustment() && ((EftposTransaction)this.txn).mayAdjustTip();
        if (hasTipButton) {
            JComponent tipButton = this.createTipAdjustmentButton(this.txn);
            this.priceHolder.add((Component)tipButton, "East");
        }
        this.buttonHolder = new JPanel(new BorderLayout());
        if (!(!this.txn.canDelete() && !this.isNew || this.txn.isTransactionProcessed() || this.txn.isPartialRefund() || this.txn.isFullyRefund() || FinanceTransactionHelper.getInstance().isTransactionFullyRefunded(this.txn))) {
            this.deleteButton = new JButton();
            if (this.txn.getMovedTransaction() != null) {
                this.deleteButton.setIcon(IconLoader.get((String)"/waitermate/images/redo.png"));
            } else {
                this.deleteButton.setIcon(IconLoader.get((String)"/waitermate/images/delete.png"));
            }
            this.deleteButton.addActionListener(this);
            this.deleteButton.setText("");
            this.deleteButton.setName("deleteTransaction");
            if (this.cannotDeleteTransaction(this.txn)) {
                this.deleteButton.setEnabled(false);
                this.buttonHolder.add(this.deleteButton);
            } else if (this.isNew) {
                this.buttonHolder.add(this.deleteButton);
            } else {
                this.buttonHolder.add((Component)new StandardSecurityDecorator((JComponent)this.deleteButton, AllPermissions.DELETE_PAY_TRANSACTION));
            }
        }
        this.add((Component)this.name, new Rectangle(1, 1, 19, 99));
        this.add((Component)this.noteHolder, new Rectangle(21, 1, 24, 99));
        this.add((Component)this.cardNumberHolder, new Rectangle(46, 1, 24, 99));
        this.add((Component)this.priceHolder, new Rectangle(64, 1, 22, 99));
        this.add((Component)this.buttonHolder, new Rectangle(87, 1, 13, 99));
    }

    private String makeLabel() {
        StringBuilder SB = new StringBuilder("<html>").append(this.txn.getSubType().getLabel());
        if (!StringUtils.isEmpty((String)this.txn.getSource())) {
            SB.append(" ").append(this.txn.getSource());
        }
        SB.append("</html>");
        return SB.toString();
    }

    private String makeNotes() {
        DebtorPayment payment;
        StringBuilder SB = new StringBuilder("<html>");
        if (this.txn.getNote() != null) {
            SB.append(this.txn.getNote());
        }
        if (this.txn.getMovedTransaction() != null && (payment = (DebtorPayment)PersistenceManager.getObject(DebtorPayment.class, (String)Query.select(DebtorPayment.class).equals(DebtorPayment.Properties.FINANCE_TRANSACTION, (Object)this.txn.getMovedTransaction()).toString())) != null) {
            SB.append("- Transferred from ").append(payment.getDebtor().getLabel());
        }
        if (this.txn instanceof VoucherTransaction) {
            VoucherTransaction voucherTxn = (VoucherTransaction)this.txn;
            if (voucherTxn.getRemainingBalanceNote() != null) {
                SB.append(voucherTxn.getRemainingBalanceNote());
            } else if (voucherTxn.getGiftVoucherTxn() != null && voucherTxn.getGiftVoucherTxn().isRedeemReversal()) {
                SB.append(" (Reversal)");
            } else if (voucherTxn.getGiftVoucherTxn() != null && voucherTxn.getGiftVoucherTxn().isRedeeming() && voucherTxn.getGiftVoucherTxn().isReversed()) {
                SB.append(" (Reversed)");
            }
        }
        SB.append("</html>");
        return SB.toString();
    }

    private String makePriceLabel() {
        StringBuilder SB = new StringBuilder("<html><div align=\"right\"><b>");
        if ("CASH".equals(this.txn.getType())) {
            Price change;
            if (this.txn.getTendered() != null && this.txn.getTendered().equals((Object)this.txn.getPaid())) {
                SB.append(this.txn.getTendered().toString());
            } else {
                if (this.txn.getTip() != null && Math.abs(this.txn.getTip().doubleValue()) > 0.001) {
                    Price paid = this.txn.getPaid();
                    if (paid == null) {
                        paid = Price.ZERO_DOLLAR;
                    }
                    SB.append("Paid: ").append(paid.add(this.txn.getTip()).toString());
                    SB.append("</b> (").append(this.txn.getTip()).append(" tip)");
                } else {
                    SB.append("Paid: ").append(this.txn.getPaid() != null ? this.txn.getPaid().toString() : "").append("</b>");
                }
                SB.append("<br>Tendered: ").append(this.txn.getTendered() != null ? this.txn.getTendered().toString() : "");
            }
            if (this.txn.getPaid() != null && this.txn.getTendered() != null && (change = this.txn.getChange()) != null && Math.abs(change.doubleValue()) > 0.0) {
                SB.append("<br><b>Change:<font color=\"green\"> ").append(change.toString()).append("</font></b>");
            }
        } else {
            if (this.txn.getTip() != null && this.txn.getTip().doubleValue() > 0.001) {
                SB.append(new Price(this.txn.getPaid().doubleValue() + this.txn.getTip().doubleValue(), 0.01));
                SB.append("</b><br> (").append(this.txn.getTip()).append(" tip)");
            } else {
                SB.append(this.txn.getPaid() != null ? this.txn.getPaid().toString() : "No Payments").append("</b>");
            }
            if (this.txn.getCashOut() != null && this.txn.getCashOut().doubleValue() > 0.001) {
                SB.append("<br>Cash out: ").append(this.txn.getCashOut());
            }
            if (FinanceTransactionHelper.getInstance().hasPartRefunds(this.txn)) {
                SB.append("<br> (").append(FinanceTransactionHelper.getInstance().getAmountRefunded(this.txn)).append(" Refunded)");
            }
        }
        SB.append("</div></html>");
        return SB.toString();
    }

    private boolean cannotDeleteTransaction(FinanceTransaction txnToDelete) {
        boolean canDelete = true;
        canDelete = txnToDelete.getMovedTransaction() != null || txnToDelete.getShift().equals((Object)Terminal.getLocalHost().getShift()) || !txnToDelete.getShift().equals((Object)Terminal.getLocalHost().getShift()) && this.canDoReferencedRefund(txnToDelete);
        canDelete = canDelete && (txnToDelete.getMovedTransaction() == null || Terminal.getLocalHost().getAssignedCashDrawer(LoginManager.getInstance().getUser()) != null);
        canDelete = canDelete && !txnToDelete.getSubType().equals((Object)FinanceUnit.getPayPalUnit());
        canDelete = canDelete && "ACTIVE".equals(txnToDelete.getSystemState());
        canDelete = canDelete && (txnToDelete.getMovedTransaction() == null || this.debtorTxnManager != null);
        canDelete = canDelete && (txnToDelete.getMovedTransaction() == null || this.debtorTxnManager == null || this.debtorTxnManager.isCurrentlyBeingTransferred(txnToDelete) || !this.debtorTxnManager.getTransferringTransactions().contains(txnToDelete));
        canDelete = canDelete && LoginManager.getInstance().getUser() != null && LoginManager.getInstance().getUser().hasPermission(AllPermissions.DELETE_PAY_TRANSACTION);
        return !canDelete;
    }

    private boolean canDoReferencedRefund(FinanceTransaction txnToDelete) {
        if (!txnToDelete.isActive()) {
            return false;
        }
        if (txnToDelete instanceof EftposTransaction) {
            EftposTransaction eftposTxn = (EftposTransaction)txnToDelete;
            if (!StringUtils.isEmpty((String)txnToDelete.getTransactionReference()) && EftposType.ADYEN.equals((Object)eftposTxn.getVirtualEftpos().getEftposType())) {
                return true;
            }
        }
        return false;
    }

    private JComponent createTipAdjustmentButton(final FinanceTransaction txnToAdjust) {
        JButton tipButton = new JButton();
        tipButton.setAction(new AbstractAction("adjustTip"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransactionPanel.this.adjustTip.emit((Object)txnToAdjust);
            }
        });
        tipButton.setText(Internationalization.getLiteralFor((String)"ADD_TIP"));
        tipButton.setName("adjustTip");
        tipButton.setIcon(IconLoader.get((String)"/waitermate/images/addMoney.png"));
        StandardSecurityDecorator decorator = new StandardSecurityDecorator((JComponent)tipButton, AllPermissions.TIP_ADJUST);
        return decorator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton) {
            VoucherTransaction vtxn;
            GiftVoucherTransaction giftTransaction;
            if (this.txn instanceof VoucherTransaction && (giftTransaction = (vtxn = (VoucherTransaction)this.txn).getGiftVoucherTxn()).getAccount() == null) {
                vtxn.reaquireAndGetGiftTransaction(giftTransaction.getID());
            }
            this.deleteTxn.emit((Object)this.txn);
        }
    }
}

