/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.payment.voucher;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.AccountPercentagePayable;
import ordermate.database.finance.SplitItemGroup;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherError;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.VoucherTransactionHelper;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.integration.voucher.VoucherAdministratorRMI;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.customerdisplay.WaiterMateCustomerDisplay;
import waitermate.gui.screens.ordering.giftvoucher.VoucherGrabber;
import waitermate.gui.screens.payment.voucher.VoucherTransactionPanel;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;

public class VoucherPayment {
    private VoucherTransactionPanel gui;
    private PopupWindow window;
    private Payable payableObject;
    private Price paid;
    private Price maxPayableAmount;
    public Signal<FinanceTransaction, ?, ?, ?, ?> done = Signals.createSignal(FinanceTransaction.class, (String)"newTransaction");
    private GiftVoucher voucher;
    private WaitermateGuiHandler guiHandler = new WaitermateGuiHandler();
    public static final String HIGHLIGHT_COLOR = "green";

    public VoucherPayment() {
        this.window = new PopupWindow();
        this.gui = new VoucherTransactionPanel();
        this.gui.paidSelected.connect((Object)this, "gotPaid");
        this.window.setPreferredSize(new Dimension(600, 500));
        this.window.getNavBar().getCancelButton().setText("Cancel");
        this.window.getNavBar().setText(Internationalization.getLiteralFor((String)"VOUCHER_CAPITAL"));
        this.window.add((Component)this.gui);
    }

    private void updateGUI() {
        this.gui.setDetails(this.getDue(), this.paid, this.getVoucherBalance());
    }

    private Price getVoucherBalance() {
        if (this.voucher != null) {
            return this.voucher.getCachedValue();
        }
        return Price.ZERO_DOLLAR;
    }

    public void startProcess(Payable payable) {
        this.initPaymentValues(payable);
        if (this.isPaidAmountValid()) {
            this.grabVoucher();
            if (this.voucher != null) {
                this.setVoucherDialogDetails();
                this.displayVoucherPaymentDialog(payable);
            }
        }
    }

    private void initPaymentValues(Payable payable) {
        this.payableObject = payable;
        this.maxPayableAmount = this.paid = this.getDue();
    }

    public boolean isPaidAmountValid() {
        if (this.paid == null || !this.paid.greaterThan((Object)Price.ZERO_DOLLAR)) {
            this.guiHandler.displayOkDialog("There is no due amount to be paid!", "Invalid Payment Amount");
            return false;
        }
        return true;
    }

    public void startQuicksaleProcess(Payable payable) {
        this.initPaymentValues(payable);
        if (this.isPaidAmountValid()) {
            this.grabVoucher();
            if (this.voucher != null) {
                if (!this.voucher.getCachedValue().lessThan((Object)this.paid)) {
                    this.doVoucherPayment();
                } else {
                    this.guiHandler.displayOkDialog(HtmlUtils.html((String)("Voucher balance " + HtmlUtils.boldColor((String)this.voucher.getCachedValue().toString(true), (String)HIGHLIGHT_COLOR) + " is not enough for quick voucher payment!")), "Insufficient Voucher Balance");
                }
            }
        }
    }

    private void displayVoucherPaymentDialog(Payable payable) {
        boolean result = this.window.start();
        if (result && this.paid != null) {
            if (this.paid.greaterThan((Object)this.maxPayableAmount)) {
                this.guiHandler.displayOkDialog(HtmlUtils.html((String)("Please enter payment amount less or equal than maximum payable amount " + HtmlUtils.boldColor((String)this.maxPayableAmount.toString(true), (String)HIGHLIGHT_COLOR))), "Invalid Payment Amount");
            } else if (!this.paid.greaterThan((Object)Price.ZERO_DOLLAR)) {
                this.guiHandler.displayOkDialog("Please enter payment amount greater than zero!", "Invalid Payment Amount");
            } else {
                this.doVoucherPayment();
                if (WaiterMateCustomerDisplay.isActive() && payable instanceof Account) {
                    WaiterMateCustomerDisplay.getInstance().accountChanged((Account)payable);
                }
            }
        }
    }

    private void setVoucherDialogDetails() {
        Price voucherBalance = this.getVoucherBalance();
        if (this.paid.greaterThan((Object)voucherBalance)) {
            this.paid = voucherBalance;
            this.maxPayableAmount = voucherBalance;
        }
        this.gui.setDetails(this.getDue(), this.paid, this.getVoucherBalance());
        this.gui.setPaidEnabled(this.payableObject.isPaidModifiable());
    }

    private void grabVoucher() {
        VoucherGrabber grabber = new VoucherGrabber(false);
        this.voucher = grabber.start();
        if (this.voucher == null && !grabber.wasCancelled()) {
            Dialogs.displayOkDialog((String)HtmlUtils.html((String)("Voucher id " + HtmlUtils.boldColor((String)grabber.getScannedString(), (String)HIGHLIGHT_COLOR) + " is not found!")), (String)"Getting Voucher Unsuccessful");
        }
    }

    protected Price getDue() {
        return this.payableObject.getDue();
    }

    public void gotPaid() {
        double newPaid = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"PAID") + " " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")));
        if (newPaid != Double.MIN_VALUE) {
            this.paid = new Price(newPaid, 0.01);
            this.updateGUI();
        }
    }

    public void gotVoucherPaymentDone(FinanceTransaction trans) {
        this.payableObject.addFinanceTransaction(trans);
        this.done.emit((Object)trans);
    }

    private boolean canDoVoucherPayment() {
        return this.payableObject instanceof Account || this.payableObject instanceof AccountPercentagePayable || this.payableObject instanceof SplitItemGroup;
    }

    private void doVoucherPayment() {
        if (this.canDoVoucherPayment()) {
            VoucherPaymentTask paymentTask = this.doPaymentTask(false);
            if (paymentTask.getResponse() != null) {
                VoucherError error = paymentTask.getResponse().getError();
                if (error != null) {
                    if (VoucherError.EXPIRED.equals((Object)error) && this.userHasPermissionToBypassExpiry()) {
                        boolean bypassExpiry = this.guiHandler.displayForcedChoiceDialog("Consume Voucher Anyway?", error.getExplanation(), "Yes", "No");
                        if (bypassExpiry && !(paymentTask = this.doPaymentTask(bypassExpiry)).isSuccessful()) {
                            this.displayConsumptionResponseError(paymentTask.getResponse());
                        }
                    } else {
                        this.displayConsumptionResponseError(paymentTask.getResponse());
                    }
                }
            } else {
                this.displayConsumptionError(VoucherError.SERVER_ERROR);
            }
        } else {
            WaiterMate.LOG.warn("Incoming payable is not instance of Account! Cannot perform voucher payment.");
        }
    }

    private boolean userHasPermissionToBypassExpiry() {
        User currentUser = LoginManager.getInstance().getUser();
        Permission allowExpired = (Permission)PersistenceManager.getObject(Permission.class, (String)Query.select(Permission.class).equals(Permission.Properties.NAME, (Object)"Allow Expired Voucher").toString());
        return currentUser.hasPermission(allowExpired);
    }

    private VoucherPaymentTask doPaymentTask(boolean ignoreExpiry) {
        VoucherPaymentTask paymentTask = new VoucherPaymentTask(ignoreExpiry);
        ProgressDialog.doProgressDialog((Task)paymentTask);
        return paymentTask;
    }

    private void displayConsumptionError(VoucherError error) {
        this.guiHandler.displayOkDialog("Error Occurred While Consuming Voucher", error.getExplanation());
    }

    private void displayConsumptionResponseError(VoucherResponse response) {
        this.guiHandler.displayOkDialog("Error Occurred While Consuming Voucher", response.getDescription() == null ? response.getError().getExplanation() : response.getDescription());
    }

    class VoucherPaymentTask
    extends AbstractTask {
        private boolean successful;
        private boolean ignoreExpiry;
        private VoucherResponse response;

        VoucherPaymentTask() {
            this(false);
        }

        VoucherPaymentTask(boolean ignoreVoucherExpiry) {
            this.ignoreExpiry = ignoreVoucherExpiry;
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        public String getName() {
            return "Requesting Voucher Payment...";
        }

        protected void performTask() throws Exception {
            GiftVoucherTransaction outputVoucherTransaction;
            GiftVoucherTransaction inputVoucherTransaction;
            VoucherPayment.this.payableObject.save();
            List selectedItems = null;
            FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext(), Terminal.getLocalHost().getAssignedCashDrawer(LoginManager.getInstance().getUser()));
            if (VoucherPayment.this.payableObject instanceof AccountPercentagePayable) {
                inputVoucherTransaction = new GiftVoucherTransaction(VoucherPayment.this.paid.negate(), VoucherPayment.this.voucher, null, null, ((AccountPercentagePayable)VoucherPayment.this.payableObject).getItemGroup().getAccount(), (EventContext)context);
            } else if (VoucherPayment.this.payableObject instanceof SplitItemGroup) {
                SplitItemGroup splitItemGroup = (SplitItemGroup)VoucherPayment.this.payableObject;
                inputVoucherTransaction = new GiftVoucherTransaction(VoucherPayment.this.paid.negate(), VoucherPayment.this.voucher, null, null, splitItemGroup.getAccount(), (EventContext)context);
                selectedItems = splitItemGroup.getItems();
            } else {
                inputVoucherTransaction = new GiftVoucherTransaction(VoucherPayment.this.paid.negate(), VoucherPayment.this.voucher, null, null, (Account)VoucherPayment.this.payableObject, (EventContext)context);
            }
            this.response = VoucherAdministratorRMI.getInstance().redeemVoucher(inputVoucherTransaction, context, this.ignoreExpiry, selectedItems);
            if (this.response != null && (outputVoucherTransaction = this.response.getTxn()) != null && outputVoucherTransaction.isAuthorised()) {
                String balanceNote = VoucherTransactionHelper.getInstance().getRemainingBalanceString((FinanceTransaction)outputVoucherTransaction.getFinanceTransaction());
                if (balanceNote != null) {
                    outputVoucherTransaction.getFinanceTransaction().setRemainingBalanceNote(balanceNote);
                }
                if (VoucherPayment.this.payableObject instanceof AccountPercentagePayable) {
                    ((AccountPercentagePayable)VoucherPayment.this.payableObject).getItemGroup().getAccount().removeVoucherTransaction(inputVoucherTransaction);
                    ((AccountPercentagePayable)VoucherPayment.this.payableObject).getItemGroup().getAccount().addVoucherTransaction(outputVoucherTransaction);
                } else if (VoucherPayment.this.payableObject instanceof SplitItemGroup) {
                    ((SplitItemGroup)VoucherPayment.this.payableObject).getAccount().removeVoucherTransaction(inputVoucherTransaction);
                    ((SplitItemGroup)VoucherPayment.this.payableObject).getAccount().addVoucherTransaction(outputVoucherTransaction);
                } else {
                    ((Account)VoucherPayment.this.payableObject).removeVoucherTransaction(inputVoucherTransaction);
                    ((Account)VoucherPayment.this.payableObject).addVoucherTransaction(outputVoucherTransaction);
                }
                if (this.response.isApproved()) {
                    VoucherPayment.this.gotVoucherPaymentDone((FinanceTransaction)outputVoucherTransaction.getFinanceTransaction());
                    this.successful = true;
                    return;
                }
            }
            this.successful = false;
            inputVoucherTransaction.deleteTransaction();
        }

        protected boolean isSuccessful() {
            return this.successful;
        }

        protected VoucherResponse getResponse() {
            return this.response;
        }
    }
}

