/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.pettycash;

import au.com.ordermate.util.Price;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeyboardDialog;
import waitermate.guikit.dialogs.KeypadDialog;

class WMPettyCashEditor
extends JPanel
implements ActionListener,
MouseListener {
    private JLabel cdLabel;
    private JLabel title;
    private JLabel userLabel;
    private JButton valueButton;
    private JCheckBox purchaseCheck;
    private JTextArea descriptionArea;
    private Price value = Price.ZERO_DOLLAR;
    private PettyCashEntry entry;

    WMPettyCashEditor() {
        this.setLayout(new BoxLayout(this, 1));
        this.setupComponents();
    }

    private void setupComponents() {
        this.cdLabel = new JLabel("Cashdrawer ");
        this.title = new JLabel("Petty Cash and date");
        this.userLabel = new JLabel("Performed By User");
        this.purchaseCheck = new JCheckBox("Purchase?");
        this.purchaseCheck.setPreferredSize(new Dimension(100, 40));
        this.purchaseCheck.addActionListener(this);
        this.purchaseCheck.setName("purchaseCheck");
        OrderMateTheme.setupTouchScreenButton((AbstractButton)this.purchaseCheck);
        this.valueButton = new JButton("$0.00");
        this.valueButton.setName("valueButton");
        OrderMateTheme.setupTouchScreenButton((AbstractButton)this.valueButton);
        this.valueButton.setPreferredSize(new Dimension(100, 40));
        this.valueButton.addActionListener(this);
        this.descriptionArea = new JTextArea(3, 30);
        this.descriptionArea.setName("descriptionArea");
        this.descriptionArea.addMouseListener(this);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setWrapStyleWord(true);
        this.add(this.cdLabel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.title);
        this.add(Box.createVerticalStrut(5));
        this.add(this.userLabel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.valueButton);
        this.add(Box.createVerticalStrut(5));
        this.add(this.purchaseCheck);
        this.add(Box.createVerticalStrut(5));
        this.add(this.descriptionArea);
    }

    void setEntry(PettyCashEntry entry) {
        this.entry = entry;
        this.cdLabel.setText("Cashdrawer: " + entry.getParent().getCashDrawer().getLabel());
        this.title.setText("Petty Cash " + entry.getParent().getParent().getShift());
        this.userLabel.setText("Performed by " + entry.getUser() != null ? entry.getUser().toString() : "");
        this.valueButton.setText(entry.getValue().toString(true));
        this.descriptionArea.setText(entry.getDescription());
    }

    public void setEditable(boolean value) {
        this.valueButton.setEnabled(value);
        this.descriptionArea.setEnabled(value);
        this.purchaseCheck.setEnabled(value);
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource() == this.valueButton) {
            double entered;
            KeypadDialog keyDog = new KeypadDialog();
            keyDog.setup(true);
            keyDog.setValue(this.entry.getValue().toString(false));
            if (Dialogs.displayDialog((JComponent)keyDog, (String)"Enter Petty Cash Value", (String)"OK", (String)"Close", (boolean)true, (boolean)false, (boolean)true) && (entered = keyDog.getValueAsDouble()) > 0.0) {
                this.value = new Price(entered, 0.01);
                this.entry.setValue(this.value);
                this.setEntry(this.entry);
            }
        } else if (action.getSource() == this.purchaseCheck) {
            this.entry.setPurchase(this.purchaseCheck.isSelected());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.descriptionArea && this.valueButton.isEnabled()) {
            KeyboardDialog boredDog = new KeyboardDialog("Description: ");
            boredDog.setValue(this.entry.getDescription());
            if (Dialogs.displayDialog((JComponent)boredDog, (String)"Enter a description", (String)"OK", (String)"Close", (boolean)true, (boolean)true, (boolean)true)) {
                this.entry.setDescription(boredDog.getValue());
                this.setEntry(this.entry);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

