/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reconciliation;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.screens.reconciliation.RecEntryHolder;
import waitermate.gui.screens.reconciliation.TopTailHolder;
import waitermate.gui.screens.reconciliation.WMRecCashEntryEditor;
import waitermate.gui.screens.reconciliation.WMRecTipsEntryEditor;
import waitermate.gui.screens.reconciliation.WMRecUnitEntryEditor;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;

public class WMCDReconciliationGui
extends JPanel {
    private Map<AbstractReconciliationEntry.RecEntryType, RecEntryHolder> holderMap;
    private CashdrawerReconciliation cdRec;
    private JLabel titleLabel;
    private TopTailHolder headers;
    private TopTailHolder totals;
    private boolean editable = true;
    private Price systemTotal;

    public WMCDReconciliationGui() {
        this.setLayout(new BoxLayout(this, 1));
        this.titleLabel = new JLabel("Reconciliation");
        this.titleLabel.setFont(OrderMateTheme.getMediumFont());
        this.add(this.titleLabel);
        this.add(Box.createVerticalStrut(5));
        this.headers = new TopTailHolder("head");
        this.add(this.headers);
        this.add(Box.createVerticalStrut(5));
        this.holderMap = new HashMap<AbstractReconciliationEntry.RecEntryType, RecEntryHolder>();
        RecEntryHolder floatHolder = this.addToHolder(AbstractReconciliationEntry.RecEntryType.FLOAT);
        floatHolder.hideExpected();
        floatHolder.negative();
        this.addToHolder(AbstractReconciliationEntry.RecEntryType.ACTUAL_CASH);
        this.addToHolder(AbstractReconciliationEntry.RecEntryType.CASH_OUT);
        RecEntryHolder pettyHolder = this.addToHolder(AbstractReconciliationEntry.RecEntryType.PETTY_CASH);
        pettyHolder.hideExpected();
        this.addToHolder(AbstractReconciliationEntry.RecEntryType.OVERRING);
        this.addToHolder(AbstractReconciliationEntry.RecEntryType.TIPS);
        this.addToHolder(AbstractReconciliationEntry.RecEntryType.CREDIT);
        this.addToHolder(AbstractReconciliationEntry.RecEntryType.WEB);
        this.add(new JSeparator(0));
        this.totals = new TopTailHolder("tail");
        this.add(this.totals);
    }

    private RecEntryHolder addToHolder(AbstractReconciliationEntry.RecEntryType nextType) {
        RecEntryHolder holder = new RecEntryHolder(nextType);
        holder.gotType.connect((Object)this, "gotRecCount");
        this.add(holder);
        this.add(Box.createVerticalStrut(5));
        this.holderMap.put(nextType, holder);
        return holder;
    }

    private void prime() {
        for (RecEntryHolder next : this.holderMap.values()) {
            next.clear();
        }
        for (AbstractReconciliationEntry entry : this.cdRec.getEntries()) {
            this.holderMap.get(entry.getType()).addEntry(entry);
        }
        RecEntryHolder holder = this.holderMap.get(AbstractReconciliationEntry.RecEntryType.PETTY_CASH);
        holder.clear();
        for (PettyCashEntry entry : this.cdRec.getPettyCashEntries()) {
            holder.addEntry((AbstractReconciliationEntry)entry);
        }
        this.updateTotals();
    }

    private void updateTotals() {
        for (RecEntryHolder holder : this.holderMap.values()) {
            holder.clearTotal();
        }
        for (AbstractReconciliationEntry entry : this.cdRec.getEntries()) {
            this.holderMap.get(entry.getType()).addEntry(entry);
        }
        this.systemTotal = new Price("0.0");
        this.addExpectedValue(this.holderMap, AbstractReconciliationEntry.RecEntryType.ACTUAL_CASH, this.cdRec.getSystemCash().subtract(this.cdRec.getPettyCashTotal()));
        if (!Price.ZERO_DOLLAR.equals((Object)this.cdRec.getFloatEntry().getValue())) {
            this.holderMap.get(AbstractReconciliationEntry.RecEntryType.ACTUAL_CASH).setAdditionalValue(this.cdRec.getFloatEntry().getValue());
        } else {
            this.holderMap.get(AbstractReconciliationEntry.RecEntryType.ACTUAL_CASH).setAdditionalValue(null);
        }
        this.addExpectedValue(this.holderMap, AbstractReconciliationEntry.RecEntryType.CASH_OUT, this.cdRec.getSystemCashOut());
        this.addExpectedValue(this.holderMap, AbstractReconciliationEntry.RecEntryType.CREDIT, this.cdRec.getSystemCredit());
        this.addExpectedValue(this.holderMap, AbstractReconciliationEntry.RecEntryType.TIPS, this.cdRec.getSystemTips());
        this.systemTotal = this.systemTotal.subtract(this.cdRec.getSystemTips());
        this.addExpectedValue(this.holderMap, AbstractReconciliationEntry.RecEntryType.PETTY_CASH, this.cdRec.getPettyCashTotal());
        this.addExpectedValue(this.holderMap, AbstractReconciliationEntry.RecEntryType.WEB, this.cdRec.getSystemWeb());
        this.addExpectedValue(this.holderMap, AbstractReconciliationEntry.RecEntryType.OVERRING, this.cdRec.getOverringEntry().getValue());
        for (RecEntryHolder holder : this.holderMap.values()) {
            holder.update();
        }
        Price actualTotal = this.cdRec.getAllComponentsTotal();
        this.totals.setValues(actualTotal.toString(true), this.systemTotal.toString(true), actualTotal.subtract(this.systemTotal).toString(true));
    }

    private void addExpectedValue(Map<AbstractReconciliationEntry.RecEntryType, RecEntryHolder> holderMap, AbstractReconciliationEntry.RecEntryType entryType, Price expectedValue) {
        holderMap.get(entryType).setExpected(expectedValue);
        this.systemTotal = this.systemTotal.add(expectedValue);
    }

    public void gotRecCount(RecEntryHolder selected) {
        if (AbstractReconciliationEntry.RecEntryType.ACTUAL_CASH.equals((Object)selected.getType())) {
            WMRecCashEntryEditor editor = new WMRecCashEntryEditor(this.cdRec);
            Dialogs.displayOkDialog((JComponent)editor, (String)"Cash Entries");
        } else if (AbstractReconciliationEntry.RecEntryType.CREDIT.equals((Object)selected.getType())) {
            ArrayList<FinanceUnit> units = new ArrayList<FinanceUnit>();
            for (FinanceUnit unit : FinanceUnit.getElectronicUnits()) {
                if (!"ACTIVE".equals(unit.getSystemState())) continue;
                units.add(unit);
            }
            WMRecUnitEntryEditor editor = new WMRecUnitEntryEditor(units, this.cdRec.getCreditEntries());
            Dialogs.displayOkDialog((JComponent)editor, (String)"Credit Entries");
        } else if (AbstractReconciliationEntry.RecEntryType.WEB.equals((Object)selected.getType())) {
            WMRecUnitEntryEditor editor = new WMRecUnitEntryEditor(FinanceUnit.getWebUnits(), this.cdRec.getWebEntries());
            Dialogs.displayOkDialog((JComponent)editor, (String)"Web Entries");
        } else if (AbstractReconciliationEntry.RecEntryType.TIPS.equals((Object)selected.getType())) {
            WMRecTipsEntryEditor editor = new WMRecTipsEntryEditor(this.cdRec);
            Dialogs.displayOkDialog((JComponent)editor, (String)"Tips Entries");
        } else {
            KeypadDialog keyDog = new KeypadDialog();
            keyDog.setUnits(selected.getType().name().replace("_", " ") + ": ");
            if (Dialogs.displayDialog((JComponent)keyDog, (String)"Enter Value", (String)"OK", (String)"Close", (boolean)true, (boolean)false, (boolean)true)) {
                Price value = new Price(keyDog.getValueAsDouble(), 0.01);
                if (AbstractReconciliationEntry.RecEntryType.CASH_OUT.equals((Object)selected.getType())) {
                    this.cdRec.getCashOutEntry().setValue(value);
                } else if (AbstractReconciliationEntry.RecEntryType.FLOAT.equals((Object)selected.getType())) {
                    this.cdRec.getFloatEntry().setValue(value);
                } else if (AbstractReconciliationEntry.RecEntryType.OVERRING.equals((Object)selected.getType())) {
                    this.cdRec.getOverringEntry().setValue(value);
                }
            }
        }
        this.updateTotals();
    }

    public void setReconciliation(CashdrawerReconciliation cdRec) {
        this.cdRec = cdRec;
        this.titleLabel.setText("Reconciliation for " + cdRec.getCashDrawer().getLabel() + ", " + cdRec.getParent().getShift().getLabel());
        this.prime();
    }

    public void setEditable(boolean value) {
        this.editable = value;
        for (RecEntryHolder holder : this.holderMap.values()) {
            holder.setEditable(value);
        }
        this.holderMap.get(AbstractReconciliationEntry.RecEntryType.PETTY_CASH).setEditable(false);
    }

    public void setBlind(boolean value) {
        for (RecEntryHolder holder : this.holderMap.values()) {
            holder.setBlind(value);
        }
        this.totals.setBlind(value);
        this.headers.setBlind(value);
    }

    public boolean isEditable() {
        return this.editable;
    }
}

