/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reconciliation;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.ActualCashEntry;
import ordermate.database.users.AllPermissions;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.reconciliation.WMCDReconciliationGui;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

class WMCashDrawerReconciliation
extends AbstractScreen {
    private NavBar nav;
    private WMCDReconciliationGui gui;
    private CashdrawerReconciliation cdRec;
    public Signal done = Signals.createSignal();

    WMCashDrawerReconciliation() {
        this.gui = new WMCDReconciliationGui();
        this.nav = new NavBar();
        this.nav.addRight((Component)this.nav.getPrintButton());
        this.nav.getPrintButton().setText("Print");
        this.nav.print.connect((Object)this, "gotPrint");
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.ok.connect((Object)this, "gotSave");
        this.nav.addLeft((Component)this.nav.getCancelButton());
        this.nav.cancel.connect((Object)this, "gotCancel");
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    void gotCancel() {
        this.done.emit();
    }

    void gotSave() {
        if (this.gui.isEditable()) {
            this.cdRec.save();
        }
        this.done.emit();
    }

    public void setReconciliation(CashdrawerReconciliation cdRec, boolean editable, boolean blind) {
        this.gui = new WMCDReconciliationGui();
        this.cdRec = cdRec;
        this.gui.setReconciliation(cdRec);
        this.gui.setEditable(editable);
        this.gui.setBlind(blind);
    }

    void gotPrint() {
        String docket = this.createDocket();
        try {
            DocketProcessor.printSimpleDocket((String)docket);
        }
        catch (IOException e) {
            OrderMate.LOG.error("Cannot print cashdrawer docket", (Throwable)e);
            Dialogs.displayOkDialog((String)"There was an error printing the cashdrawer slip", (String)"Error Printing Docket");
        }
    }

    private String createDocket() {
        StringBuilder SB = new StringBuilder();
        String BR = "\r\n";
        SB.append("[!]Cashdrawer Slip\r\n");
        SB.append("[><]").append(this.cdRec.getParent().getShift()).append(BR);
        SB.append("[><]").append(this.cdRec.getCashDrawer().getLabel()).append(BR);
        SB.append(BR);
        SB.append("Printed by:").append(LoginManager.getInstance().getUser()).append(BR);
        SB.append(DateTimeUtils.getDateTimeFormat().format(new Date())).append(BR);
        SB.append(BR);
        ArrayList cashEntries = new ArrayList(this.cdRec.getActualCashEntries());
        Collections.sort(cashEntries, new Comparator<ActualCashEntry>(){

            @Override
            public int compare(ActualCashEntry arg0, ActualCashEntry arg1) {
                if (arg0 == null) {
                    return -1;
                }
                if (arg1 == null) {
                    return 1;
                }
                return Double.valueOf(arg1.getDenomination().getValue()).compareTo(arg0.getDenomination().getValue());
            }
        });
        SB.append("[||]Float|").append(this.cdRec.getFloatEntry().getValue().toString(true)).append(BR);
        SB.append("[||]Petty Cash|").append(this.cdRec.getPettyCashTotal().toString(true)).append(BR);
        for (ActualCashEntry entry : cashEntries) {
            SB.append("[||]").append(FinanceUtils.denominationToString((Denomination)entry.getDenomination())).append("|").append(entry.getValue().toString(true)).append(BR);
        }
        for (ActualCashEntry entry : this.cdRec.getCreditEntries()) {
            SB.append("[||]").append(entry.getFinanceUnit().getLabel()).append("|").append(entry.getValue()).append(BR);
        }
        for (ActualCashEntry entry : this.cdRec.getWebEntries()) {
            SB.append("[||]").append(entry.getFinanceUnit().getLabel()).append("|").append(entry.getValue()).append(BR);
        }
        SB.append("[||]Total|").append(this.cdRec.getTotal()).append(BR);
        SB.append(BR);
        if (this.hideVariance()) {
            return SB.toString();
        }
        if (Price.ZERO_DOLLAR.compareTo(this.cdRec.getCashVariance()) != 0) {
            SB.append("[||]Cash Variance|").append(this.cdRec.getCashVariance()).append(BR);
        }
        if (Price.ZERO_DOLLAR.compareTo(this.cdRec.getCashOutVariance()) != 0) {
            SB.append("[||]Cash Out Variance|").append(this.cdRec.getCashOutVariance()).append(BR);
        }
        if (Price.ZERO_DOLLAR.compareTo(this.cdRec.getCreditVariance()) != 0) {
            SB.append("[||]Credit Variance|").append(this.cdRec.getCreditVariance()).append(BR);
        }
        if (Price.ZERO_DOLLAR.compareTo(this.cdRec.getTipsVariance()) != 0) {
            SB.append("[||]Tips Variance|").append(this.cdRec.getTipsVariance()).append(BR);
        }
        if (Price.ZERO_DOLLAR.compareTo(this.cdRec.getWebVariance()) != 0) {
            SB.append("[||]Web Variance|").append(this.cdRec.getWebVariance()).append(BR);
        }
        if (Price.ZERO_DOLLAR.compareTo(this.cdRec.getTotalVariance()) != 0) {
            SB.append("[||]Total Variance|").append(this.cdRec.getTotalVariance()).append(BR);
        }
        return SB.toString();
    }

    private boolean hideVariance() {
        boolean isRecEnabled = LoginManager.getInstance().getUser().hasPermission(AllPermissions.WAITERMATE_RECONCILIATION);
        boolean isBlind = LoginManager.getInstance().getUser().hasPermission(AllPermissions.WAITERMATE_RECONCILIATION_BLIND);
        if (!isRecEnabled) {
            return true;
        }
        return isBlind;
    }
}

