/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reconciliation;

import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.ActualCashEntry;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;

class WMRecCashEntryEditor
extends JPanel {
    private static final NumberFormat decimalFormat = NumberFormat.getCurrencyInstance();
    private KeypadDialog keyDog;
    private final CashdrawerReconciliation rec;
    private Map<Denomination, NomHolder> nomnoms;

    WMRecCashEntryEditor(CashdrawerReconciliation rec) {
        this.rec = rec;
        this.setupComponents();
    }

    private void setupComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.nomnoms = new HashMap<Denomination, NomHolder>();
        for (Denomination nom : Denomination.getDenominations()) {
            NomHolder holder = new NomHolder(nom);
            this.nomnoms.put(nom, holder);
            this.add(holder);
            this.add(Box.createVerticalStrut(5));
        }
        List cashEntries = this.rec.getActualCashEntries();
        for (ActualCashEntry entry : cashEntries) {
            this.nomnoms.get(entry.getDenomination()).setEntry(entry);
        }
    }

    class NomHolder
    extends JPanel
    implements ActionListener {
        private ActualCashEntry entry;
        private int count;
        private JLabel nomLabel;
        private JButton countButton;
        private JButton totalButton;
        private Denomination nom;

        public NomHolder(Denomination nom) {
            super(new GridLayout(1, 3, 5, 5));
            this.nom = nom;
            this.nomLabel = new JLabel();
            this.nomLabel.setText(FinanceUtils.denominationToString((Denomination)nom));
            this.countButton = new JButton(nom.getLabel());
            this.countButton.setName(nom.getLabel() + "Button");
            OrderMateTheme.setupTouchScreenButton((AbstractButton)this.countButton);
            this.countButton.addActionListener(this);
            this.countButton.setPreferredSize(new Dimension(120, 40));
            this.totalButton = new JButton("$0.00");
            this.totalButton.setName(nom.getLabel() + "Total");
            this.totalButton.addActionListener(this);
            this.add(this.nomLabel);
            this.add(this.countButton);
            this.add(this.totalButton);
        }

        private void setEntry(ActualCashEntry entry) {
            this.entry = entry;
            this.updateText();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.countButton) {
                this.doCount();
            } else if (event.getSource() == this.totalButton) {
                this.doTotal();
            }
        }

        private void updateText() {
            this.count = this.entry.getValue().divide((Number)this.nom.getValue()).intValue();
            this.countButton.setText("" + this.count);
            this.totalButton.setText(decimalFormat.format(this.entry.getValue().doubleValue()));
        }

        private void doCount() {
            if (WMRecCashEntryEditor.this.keyDog == null) {
                WMRecCashEntryEditor.this.keyDog = new KeypadDialog();
                WMRecCashEntryEditor.this.keyDog.setup(false);
            }
            WMRecCashEntryEditor.this.keyDog.setValue("");
            String pretty = FinanceUtils.denominationToString((Denomination)this.nom);
            WMRecCashEntryEditor.this.keyDog.setUnits(pretty + ": ");
            if (Dialogs.displayDialog((JComponent)WMRecCashEntryEditor.this.keyDog, (String)"Enter Count", (String)"OK", (String)"Close", (boolean)true, (boolean)false, (boolean)true)) {
                this.count = WMRecCashEntryEditor.this.keyDog.getValueAsInt();
                this.entry.setValue(new Price((double)this.count * this.nom.getValue(), 0.01));
                this.updateText();
            }
            WMRecCashEntryEditor.this.keyDog = null;
        }

        private void doTotal() {
            if (WMRecCashEntryEditor.this.keyDog == null) {
                WMRecCashEntryEditor.this.keyDog = new KeypadDialog();
                WMRecCashEntryEditor.this.keyDog.setup(true);
            }
            WMRecCashEntryEditor.this.keyDog.setValue("");
            String pretty = FinanceUtils.denominationToString((Denomination)this.nom);
            WMRecCashEntryEditor.this.keyDog.setUnits(pretty + ": ");
            if (Dialogs.displayDialog((JComponent)WMRecCashEntryEditor.this.keyDog, (String)"Enter Total", (String)"OK", (String)"Close", (boolean)true, (boolean)false, (boolean)true)) {
                double input = WMRecCashEntryEditor.this.keyDog.getValueAsDouble();
                if (input % this.nom.getValue() != 0.0) {
                    input = (double)((int)((input + 1.0E-5) / this.nom.getValue())) * this.nom.getValue();
                }
                this.entry.setValue(new Price(input, 0.01));
                this.updateText();
            }
            WMRecCashEntryEditor.this.keyDog = null;
        }
    }
}

