/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reconciliation;

import au.com.ordermate.util.Price;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;

class WMRecUnitEntryEditor
extends JPanel {
    private KeypadDialog keyDog;
    private Map<FinanceUnit, UnitHolder> unitMap;

    WMRecUnitEntryEditor(List<FinanceUnit> units, List<? extends AbstractReconciliationEntry> entries) {
        this.setupComponents(units, entries);
    }

    private void setupComponents(List<FinanceUnit> units, List<? extends AbstractReconciliationEntry> entries) {
        UnitHolder holder;
        this.setLayout(new BoxLayout(this, 1));
        this.unitMap = new HashMap<FinanceUnit, UnitHolder>();
        for (FinanceUnit financeUnit : units) {
            holder = new UnitHolder(financeUnit);
            this.unitMap.put(financeUnit, holder);
            this.add(holder);
            this.add(Box.createVerticalStrut(5));
        }
        for (AbstractReconciliationEntry abstractReconciliationEntry : entries) {
            holder = this.unitMap.get(abstractReconciliationEntry.getFinanceUnit());
            if (holder == null) {
                holder = new UnitHolder(abstractReconciliationEntry.getFinanceUnit());
                this.unitMap.put(abstractReconciliationEntry.getFinanceUnit(), holder);
                this.add(holder);
                this.add(Box.createVerticalStrut(5));
            }
            holder.setEntry(abstractReconciliationEntry);
        }
    }

    class UnitHolder
    extends JPanel
    implements ActionListener {
        private AbstractReconciliationEntry entry;
        private Price value;
        private JLabel unitLabel;
        private JButton valueButton;
        private FinanceUnit unit;

        public UnitHolder(FinanceUnit unit) {
            super(new GridLayout(1, 2, 5, 5));
            this.value = Price.ZERO_DOLLAR;
            this.unit = unit;
            this.unitLabel = new JLabel(unit.getLabel());
            this.valueButton = new JButton("$0.00");
            OrderMateTheme.setupTouchScreenButton((AbstractButton)this.valueButton);
            this.valueButton.addActionListener(this);
            this.valueButton.setName(unit + "Button");
            this.valueButton.setPreferredSize(new Dimension(120, 40));
            this.add(this.unitLabel);
            this.add(this.valueButton);
        }

        private void setEntry(AbstractReconciliationEntry entry) {
            this.entry = entry;
            this.value = entry.getValue();
            this.updateText();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.doAmount();
        }

        private void updateText() {
            this.valueButton.setText(this.value.toString(true));
        }

        private void doAmount() {
            if (WMRecUnitEntryEditor.this.keyDog == null) {
                WMRecUnitEntryEditor.this.keyDog = new KeypadDialog();
                WMRecUnitEntryEditor.this.keyDog.setup(true);
            }
            WMRecUnitEntryEditor.this.keyDog.setValue(this.entry.getValue().toString(false));
            WMRecUnitEntryEditor.this.keyDog.setUnits("$ " + this.unit.getLabel().replace("_", " ") + ": ");
            if (Dialogs.displayDialog((JComponent)WMRecUnitEntryEditor.this.keyDog, (String)"Enter Value", (String)"OK", (String)"Close", (boolean)true, (boolean)false, (boolean)true)) {
                double entryValue = WMRecUnitEntryEditor.this.keyDog.getValueAsDouble();
                if (entryValue >= 0.0) {
                    this.value = new Price(entryValue, 0.01);
                }
                this.entry.setValue(this.value);
                this.updateText();
            }
            WMRecUnitEntryEditor.this.keyDog = null;
        }
    }
}

