/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reservations;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class ListedReservationPanel
extends JPanel
implements MouseListener {
    public final Signal<Reservation, ?, ?, ?, ?> itemPressed = Signals.createSignal(Reservation.class, (String)"reservation");
    private static final int EXT_ID_BREAK = 20;
    private JLabel name;
    private JLabel id;
    private JLabel time;
    private JLabel section;
    private JLabel patrons;
    private JTextArea comments;
    private Reservation currentReservation;
    private boolean pressed;
    private boolean inComponent;

    public ListedReservationPanel() {
        this.setBackground(null);
        this.setLayout((LayoutManager)new GraphPaperLayout(50, 1));
        this.addMouseListener(this);
        if (ReservationIntegrationUtils.isCloudReservationsConfigured()) {
            this.name = this.makeLabel();
            this.add((Component)this.name, new Rectangle(0, 0, 9, 1));
            this.id = this.makeLabel();
            this.add((Component)this.id, new Rectangle(9, 0, 13, 1));
            this.time = this.makeLabel();
            this.add((Component)this.time, new Rectangle(22, 0, 3, 1));
            this.section = this.makeLabel();
            this.add((Component)this.section, new Rectangle(25, 0, 5, 1));
            this.patrons = this.makeLabel();
            this.add((Component)this.patrons, new Rectangle(31, 0, 3, 1));
            this.comments = this.makeTextArea();
            this.add((Component)this.comments, new Rectangle(34, 0, 16, 1));
        } else {
            this.name = this.makeLabel();
            this.add((Component)this.name, new Rectangle(0, 0, 9, 1));
            this.id = this.makeLabel();
            this.time = this.makeLabel();
            this.add((Component)this.time, new Rectangle(9, 0, 4, 1));
            this.section = this.makeLabel();
            this.add((Component)this.section, new Rectangle(14, 0, 7, 1));
            this.patrons = this.makeLabel();
            this.add((Component)this.patrons, new Rectangle(21, 0, 6, 1));
            this.comments = this.makeTextArea();
            this.add((Component)this.comments, new Rectangle(29, 0, 21, 1));
        }
    }

    private JTextArea makeTextArea() {
        JTextArea textArea = new JTextArea(4, 50);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setOpaque(false);
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setName("comments-text");
        textArea.setBackground(UIManager.getColor("Label.background"));
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setBorder(new EmptyBorder(4, 4, 4, 4));
        return textArea;
    }

    private JLabel makeLabel() {
        JLabel label = new JLabel();
        label.setBorder(new EmptyBorder(4, 4, 4, 4));
        label.setOpaque(false);
        return label;
    }

    Reservation getReservation() {
        return this.currentReservation;
    }

    void setReservation(Reservation reservation) {
        this.currentReservation = reservation;
        boolean notNull = this.currentReservation != null;
        this.setBackground(notNull ? this.currentReservation.getBackgroundColor() : null);
        this.name.setVisible(notNull);
        this.id.setVisible(notNull);
        this.time.setVisible(notNull);
        this.section.setVisible(notNull);
        this.patrons.setVisible(notNull);
        this.comments.setVisible(notNull);
        if (notNull) {
            this.name.setText(this.currentReservation.getCustomerName());
            this.id.setText(this.getExtIdLabel());
            this.time.setText(DateTimeUtils.convertToTwelveHourTime((Date)this.currentReservation.getTime()));
            if (!StringUtils.isEmpty((String)this.currentReservation.getTables())) {
                this.section.setText(this.currentReservation.getSectionLabel() + " " + this.currentReservation.getTables());
            } else if (this.currentReservation.getTableAccount() != null && this.currentReservation.getTableAccount() instanceof TableAccount) {
                TableAccount tac = (TableAccount)this.currentReservation.getTableAccount();
                if (tac.getTable() != null) {
                    this.section.setText(this.currentReservation.getSectionLabel() + " " + tac.getTable().getLabel());
                } else {
                    this.section.setText(this.currentReservation.getSectionLabel() + " UNALLOCATED");
                }
            } else {
                this.section.setText(this.currentReservation.getSectionLabel());
            }
            this.patrons.setText(this.currentReservation.getNumPatrons() + " people");
            this.comments.setText("" + this.currentReservation.getCommentsSafe());
        }
    }

    private String getExtIdLabel() {
        String extId = this.currentReservation.getExternalId();
        if (extId == null) {
            return "Ref: None";
        }
        StringBuilder SB = new StringBuilder("Ref: ");
        if (extId.length() > 20) {
            SB.append(extId.substring(0, 5));
            SB.append("...");
            SB.append(extId.substring(extId.length() - 20 - 5));
        } else {
            SB.append(extId);
        }
        return SB.toString();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.pressed && !this.inComponent) {
            this.setBackground(this.currentReservation.getPressedColor());
        }
        this.inComponent = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.pressed && this.inComponent) {
            this.setBackground(this.currentReservation.getBackgroundColor());
        }
        this.inComponent = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setBackground(this.currentReservation.getPressedColor());
        this.pressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.pressed && this.inComponent) {
            this.setBackground(this.currentReservation.getBackgroundColor());
            this.itemPressed.emit((Object)this.currentReservation);
        }
        this.pressed = false;
    }
}

