/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reservations;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.database.ButtonInfo;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.sales.Customer;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.users.AllPermissions;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.screens.customer.SelectCustomer;
import waitermate.gui.screens.reservations.ReservationsGui;
import waitermate.gui.screens.reservations.ReservationsNav;
import waitermate.gui.screens.reservations.addreservation.AddReservation;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class Reservations
extends AbstractScreen {
    private final ReservationsGui gui;
    private final ReservationsNav nav;
    private final AddReservation addReservationScreen;
    public final Signal reservationsStopped = Signals.createSignal();
    public final Signal accountSelected = Signals.createSignal(ButtonInfo.class, (String)"Selected Account");
    private Timer refreshTimer;
    private static final long DEFAULT_REFRESH_INTERVAL = 2000L;

    public Reservations() {
        this.gui = new ReservationsGui();
        this.gui.item.connect((Object)this, "gotReservationEdit");
        this.gui.dateUpdated.connect((Object)this, "updateGui");
        this.addReservationScreen = new AddReservation();
        this.addReservationScreen.reservationSaved.connect((Object)this, "resume");
        this.addReservationScreen.back.connect((Object)this, "resume");
        this.nav = new ReservationsNav();
        this.nav.back.connect((Object)this, "stopScreen");
        this.nav.ok.connect((Object)this, "stopScreen");
        this.nav.addReservation.connect((Object)this, "gotAddReservation");
        this.nav.addWalkIn.connect((Object)this, "gotAddWalkIn");
        this.nav.printReservations.connect((Object)this, "gotPrintUnallocatedReservations");
        this.updateGui();
    }

    private void createTimer() {
        this.refreshTimer = new Timer();
        this.refreshTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Reservations.this.isDisplaying()) {
                            Reservations.this.updateGui();
                        }
                    }
                });
            }
        }, 2000L, 2000L);
    }

    public void start() {
        if (RDConfiguration.checkConfigured()) {
            ReservationIntegrationUtils.synchronize();
            this.createTimer();
        }
        this.resetGui();
        this.display();
    }

    public void resume() {
        this.updateGui();
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void refreshAddButton() {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setTime(this.gui.getDate());
        GregorianCalendar systemDate = new GregorianCalendar();
        systemDate.setTime(new Date(System.currentTimeMillis()));
        boolean enable = false;
        if (currentDate.get(1) > systemDate.get(1)) {
            enable = true;
        } else {
            boolean bl = enable = currentDate.get(6) >= systemDate.get(6) && currentDate.get(1) >= systemDate.get(1);
        }
        if (enable) {
            this.gui.setDefaultMessage("<html><p align='center'>Select 'Add Reservation' to make<br>a reservation for this day<html>");
        } else {
            this.gui.setDefaultMessage("There are no reservations on this day");
        }
        this.nav.refreshAddButtonView(enable);
    }

    private void gotCustomerForReservation(Customer theCustomer) {
        this.addReservationScreen.start(theCustomer, this.gui.getDate());
    }

    public void stopScreen() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
        this.reservationsStopped.emit();
    }

    public void gotAddReservation() {
        Customer customer = SelectCustomer.startModal(Customer.REQUIRE_BASIC, false);
        if (customer != null) {
            this.gotCustomerForReservation(customer);
        }
    }

    public void gotAddWalkIn() {
        this.gotCustomerForReservation(null);
    }

    public void gotPrintUnallocatedReservations() {
        List reservations = ReservationsHelper.getReservationsForDay((Date)this.gui.getDate(), (boolean)true);
        if (reservations.isEmpty()) {
            Dialogs.displayOkDialog((String)"There are no unallocated Reservations to print", (String)"Nothing to Print");
            return;
        }
        Terminal theTerminal = Terminal.getLocalHost();
        List printers = theTerminal.getAvailableReceiptPrinters();
        try {
            DocketProcessor.printReservationsDocket((Terminal)theTerminal, (Collection)printers, (Date)this.gui.getDate());
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print unallocated reservations for day", (Throwable)e);
        }
    }

    public void gotReservationEdit(Reservation editReservation) {
        if (LoginManager.getInstance().getUser().hasPermission(AllPermissions.EDIT_RESERVATIONS)) {
            this.addReservationScreen.start(editReservation);
        } else {
            Dialogs.displayOkDialog((String)"You do not have permission to edit reservations.", (String)"Operation Not Allowed");
        }
    }

    public void gotReservationDelete(Reservation deleteReservation) {
        boolean result = Dialogs.displayChoiceDialog((String)"Are you sure you want to delete this reservation?", (String)"Delete Reservation", (boolean)false);
        if (result) {
            deleteReservation.deleteReservation();
            this.updateGui();
        }
    }

    public void updateGui() {
        this.gui.refreshData();
        this.nav.setPatronsText(this.gui.getNumPatronsBooked());
        this.refreshAddButton();
    }

    public void resetGui() {
        this.gui.resetData();
        this.nav.setPatronsText(this.gui.getNumPatronsBooked());
        this.refreshAddButton();
    }
}

