/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.reservations;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.reservations.ReservationsRenderer;

class ReservationsGui
extends JPanel
implements ActionListener {
    public final Signal item = Signals.createSignal(Reservation.class, (String)"selectedItem");
    public final Signal dateUpdated = Signals.createSignal();
    private CustomScrollPane gui;
    private List<Reservation> reservationsForDay;
    private RendererScrollPaneModel<Reservation> reservationsModel;
    private ReservationsRenderer renderer;
    private Calendar theCalendar;
    private JLabel dateLabel;
    private JButton today;
    private JButton prevDay;
    private JButton nextDay;
    private JLabel dayLabel;
    private JButton prevWeek;
    private JButton nextWeek;
    private JLabel weekLabel;
    private JButton prevMonth;
    private JButton nextMonth;
    private JLabel monthLabel;

    public ReservationsGui() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        this.theCalendar = new GregorianCalendar();
        this.theCalendar.setTimeInMillis(System.currentTimeMillis());
        this.renderer = new ReservationsRenderer();
        this.reservationsModel = new RendererScrollPaneModel((Renderer)this.renderer, 1, 8);
        this.renderer.item.connect((Object)this, "gotItem");
        this.gui = new CustomScrollPane(this.reservationsModel);
        this.gui.setBorder((Border)new TitledBorder("Reservations:"));
        this.gui.setEmptyMessage("Select 'Add Reservation' to make a reservation for this day");
        JPanel date = new JPanel();
        date.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 4), 5, 0));
        date.setBorder(new TitledBorder("Date:"));
        this.dateLabel = new JLabel("");
        this.today = new JButton("Today");
        this.today.addActionListener(this);
        date.add((Component)this.dateLabel, new Rectangle(1, 0, 8, 2));
        date.add((Component)this.today, new Rectangle(1, 2, 6, 2));
        this.prevDay = new JButton(IconLoader.get((String)"/waitermate/images/downarrow.png"));
        this.prevDay.addActionListener(this);
        date.add((Component)this.prevDay, new Rectangle(8, 2, 2, 2));
        this.dayLabel = new JLabel("<html><h2>Day</h2></html>");
        date.add((Component)this.dayLabel, new Rectangle(10, 0, 2, 4));
        this.nextDay = new JButton(IconLoader.get((String)"/waitermate/images/uparrow.png"));
        this.nextDay.addActionListener(this);
        date.add((Component)this.nextDay, new Rectangle(8, 0, 2, 2));
        this.prevWeek = new JButton(IconLoader.get((String)"/waitermate/images/downarrow.png"));
        this.prevWeek.addActionListener(this);
        date.add((Component)this.prevWeek, new Rectangle(12, 2, 2, 2));
        this.weekLabel = new JLabel("<html><h2>Week</h2></html>");
        date.add((Component)this.weekLabel, new Rectangle(14, 0, 2, 4));
        this.nextWeek = new JButton(IconLoader.get((String)"/waitermate/images/uparrow.png"));
        this.nextWeek.addActionListener(this);
        date.add((Component)this.nextWeek, new Rectangle(12, 0, 2, 2));
        this.prevMonth = new JButton(IconLoader.get((String)"/waitermate/images/downarrow.png"));
        this.prevMonth.addActionListener(this);
        date.add((Component)this.prevMonth, new Rectangle(16, 2, 2, 2));
        this.monthLabel = new JLabel("<html><h2>Month</h2></html>");
        date.add((Component)this.monthLabel, new Rectangle(18, 0, 2, 4));
        this.nextMonth = new JButton(IconLoader.get((String)"/waitermate/images/uparrow.png"));
        this.nextMonth.addActionListener(this);
        date.add((Component)this.nextMonth, new Rectangle(16, 0, 2, 2));
        this.add((Component)this.gui, new Rectangle(0, 4, 20, 16));
        this.add((Component)date, new Rectangle(0, 0, 20, 4));
        this.displayDate();
    }

    public void gotItem(Reservation theReservation) {
        this.item.emit((Object)theReservation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.prevDay) {
            this.theCalendar.add(5, -1);
            this.displayDate();
        } else if (e.getSource() == this.nextDay) {
            this.theCalendar.add(5, 1);
            this.displayDate();
        }
        if (e.getSource() == this.prevWeek) {
            this.theCalendar.add(5, -7);
            this.displayDate();
        } else if (e.getSource() == this.nextWeek) {
            this.theCalendar.add(5, 7);
            this.displayDate();
        } else if (e.getSource() == this.prevMonth) {
            this.theCalendar.add(2, -1);
            this.displayDate();
        } else if (e.getSource() == this.nextMonth) {
            this.theCalendar.add(2, 1);
            this.displayDate();
        } else if (e.getSource() == this.today) {
            this.theCalendar.setTimeInMillis(System.currentTimeMillis());
            this.displayDate();
        }
        this.dateUpdated.emit();
    }

    private void displayDate() {
        this.dateLabel.setText(DateTimeUtils.getLongFormat().format(this.theCalendar.getTime()));
        this.dateLabel.setFont(OrderMateTheme.getLargeFont());
    }

    public Date getDate() {
        return this.theCalendar.getTime();
    }

    public void refreshData() {
        this.reservationsForDay = ReservationsHelper.getReservationsForDay((Date)this.theCalendar.getTime(), (boolean)false);
        this.reservationsModel.setObjects(this.reservationsForDay);
        this.displayDate();
    }

    public void resetData() {
        this.theCalendar.setTimeInMillis(System.currentTimeMillis());
        this.reservationsForDay = ReservationsHelper.getReservationsForDay((Date)this.theCalendar.getTime(), (boolean)false);
        this.reservationsModel.setObjects(this.reservationsForDay);
        this.displayDate();
    }

    public int getNumPatronsBooked() {
        Iterator<Reservation> it = this.reservationsForDay.iterator();
        int totalNumPatrons = 0;
        while (it.hasNext()) {
            totalNumPatrons += it.next().getNumPatrons().intValue();
        }
        return totalNumPatrons;
    }

    public void setDefaultMessage(String message) {
        this.gui.setEmptyMessage(message);
    }
}

